/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeMap;
import org.eclipse.sapphire.modeling.ModelMetadataItem;
import org.eclipse.sapphire.modeling.ModelProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModelElementType
extends ModelMetadataItem {
    private final Class<?> modelElementClass;
    private final List<ModelProperty> properties;
    private Map<String, String> resources;

    public ModelElementType(Class<?> modelElementClass) {
        this.modelElementClass = modelElementClass;
        this.properties = new ArrayList<ModelProperty>();
        this.resources = null;
    }

    public static ModelElementType getModelElementType(Class<?> modelElementClass) {
        return ModelElementType.getModelElementType(modelElementClass, true);
    }

    public static ModelElementType getModelElementType(Class<?> modelElementClass, boolean throwExceptionIfNotFound) {
        Field[] fieldArray = modelElementClass.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.getName().equals("TYPE")) {
                try {
                    Object fieldValue = field.get(null);
                    if (!(fieldValue instanceof ModelElementType)) break;
                    return (ModelElementType)fieldValue;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            ++n2;
        }
        if (throwExceptionIfNotFound) {
            throw new IllegalArgumentException("Did not find TYPE field on " + modelElementClass.getName());
        }
        return null;
    }

    public Class<?> getModelElementClass() {
        return this.modelElementClass;
    }

    public String getSimpleName() {
        return this.modelElementClass.getSimpleName();
    }

    public String getQualifiedName() {
        return this.modelElementClass.getName();
    }

    public List<ModelProperty> getProperties() {
        TreeMap<String, ModelProperty> properties = new TreeMap<String, ModelProperty>();
        Class<?>[] classArray = this.modelElementClass.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> cl = classArray[n2];
            ModelElementType t = ModelElementType.getModelElementType(cl, false);
            if (t != null) {
                for (ModelProperty property : t.getProperties()) {
                    properties.put(property.getName(), property);
                }
            }
            ++n2;
        }
        for (ModelProperty property : this.properties) {
            properties.put(property.getName(), property);
        }
        return new ArrayList<ModelProperty>(properties.values());
    }

    public ModelProperty getProperty(String propertyName) {
        for (ModelProperty property : this.getProperties()) {
            if (!property.getName().equalsIgnoreCase(propertyName)) continue;
            return property;
        }
        return null;
    }

    void addProperty(ModelProperty property) {
        this.properties.add(property);
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> type, boolean localOnly) {
        return this.modelElementClass.getAnnotation(type);
    }

    @Override
    public synchronized String getResource(String key) {
        if (this.resources == null) {
            this.resources = new HashMap<String, String>();
            try {
                ResourceBundle resourceBundle = ResourceBundle.getBundle(this.modelElementClass.getName(), Locale.getDefault(), this.modelElementClass.getClassLoader());
                Enumeration<String> keys = resourceBundle.getKeys();
                while (keys.hasMoreElements()) {
                    String k = keys.nextElement();
                    this.resources.put(k, resourceBundle.getString(k));
                }
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return this.resources.get(key);
    }

    @Override
    protected String getLabelResourceKeyBase() {
        return "$type$";
    }

    @Override
    protected String getDefaultLabel() {
        String className = this.modelElementClass.getName();
        int lastDot = className.lastIndexOf(46);
        if (lastDot != -1) {
            className = className.substring(lastDot + 1);
        }
        return this.transformCamelCaseToLabel(className);
    }

    protected static abstract class ModelPropertyInitListener {
        protected ModelPropertyInitListener() {
        }

        public abstract void propertyInitialized(ModelProperty var1);
    }
}

