/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public final class SapphireMultiStatus
extends Status {
    private static final IStatus[] NO_CHILDREN = new IStatus[0];
    private static final Comparator<IStatus> SEVERITY_COMPARATOR = new Comparator<IStatus>(){

        @Override
        public int compare(IStatus st1, IStatus st2) {
            return st2.getSeverity() - st1.getSeverity();
        }
    };
    private IStatus child;
    private List<IStatus> children;

    public SapphireMultiStatus() {
        super(0, "org.eclipse.sapphire.modeling", null);
    }

    public void add(IStatus status) {
        int sev = status.getSeverity();
        if (sev != 0) {
            if (sev > this.getSeverity()) {
                this.setSeverity(sev);
                this.setMessage(status.getMessage());
            }
            if (this.children != null) {
                this.children.add(status);
            } else if (this.child != null) {
                this.children = new ArrayList<IStatus>();
                this.children.add(this.child);
                this.children.add(status);
                this.child = null;
            } else {
                this.child = status;
            }
        }
    }

    public IStatus[] getChildren() {
        if (this.children != null) {
            IStatus[] array = this.children.toArray(new IStatus[this.children.size()]);
            Arrays.sort(array, SEVERITY_COMPARATOR);
            return array;
        }
        if (this.child != null) {
            return new IStatus[]{this.child};
        }
        return NO_CHILDREN;
    }

    public boolean isMultiStatus() {
        return this.children != null && this.children.size() > 1;
    }

    public final int hashCode() {
        return this.getSeverity() * this.getMessage().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SapphireMultiStatus)) {
            return false;
        }
        return SapphireMultiStatus.equal((IStatus)this, (IStatus)((SapphireMultiStatus)((Object)obj)));
    }

    private static boolean equal(IStatus x, IStatus y) {
        IStatus[] yChildren;
        IStatus[] xChildren;
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        if (x.getSeverity() == y.getSeverity() && x.getMessage().equals(y.getMessage()) && (xChildren = x.getChildren()).length == (yChildren = y.getChildren()).length) {
            int i = 0;
            int n = xChildren.length;
            while (i < n) {
                if (!SapphireMultiStatus.equal(xChildren[i], yChildren[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }
}

