/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModel;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementService;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.DefaultValueProvider;
import org.eclipse.sapphire.modeling.annotations.DefaultValueProviderImpl;
import org.eclipse.sapphire.modeling.annotations.EnabledByBooleanProperty;
import org.eclipse.sapphire.modeling.annotations.EnabledByEnumProperty;
import org.eclipse.sapphire.modeling.annotations.EnabledWhen;
import org.eclipse.sapphire.modeling.annotations.Enabler;
import org.eclipse.sapphire.modeling.annotations.EnablerImpl;
import org.eclipse.sapphire.modeling.annotations.PossibleValues;
import org.eclipse.sapphire.modeling.annotations.PossibleValuesFromModel;
import org.eclipse.sapphire.modeling.annotations.PossibleValuesProvider;
import org.eclipse.sapphire.modeling.annotations.PossibleValuesProviderImpl;
import org.eclipse.sapphire.modeling.internal.BooleanPropertyEnabler;
import org.eclipse.sapphire.modeling.internal.EnumPropertyEnabler;
import org.eclipse.sapphire.modeling.internal.PossibleValuesFromModelProvider;
import org.eclipse.sapphire.modeling.internal.SapphireModelingFrameworkPlugin;
import org.eclipse.sapphire.modeling.internal.ScriptBasedEnabler;
import org.eclipse.sapphire.modeling.internal.StaticValuesProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StandardModelElementService
extends ModelElementService {
    private final Map<ModelProperty, List<EnablerImpl>> enablers = Collections.synchronizedMap(new HashMap());
    private final Map<ValueProperty, DefaultValueProviderImpl> defaultValueProviders = Collections.synchronizedMap(new HashMap());
    private final Map<ValueProperty, String> defaultValues = Collections.synchronizedMap(new HashMap());
    private final Map<ValueProperty, PossibleValuesProviderImpl> valuesProviders = Collections.synchronizedMap(new HashMap());

    public Object read(ModelProperty property) {
        return property.invokeGetterMethod(this.getModelElement());
    }

    public Value<?> read(ValueProperty property) {
        return (Value)property.invokeGetterMethod(this.getModelElement());
    }

    public IModelElement read(ElementProperty property) {
        return (IModelElement)property.invokeGetterMethod(this.getModelElement());
    }

    public ModelElementList<?> read(ListProperty property) {
        return (ModelElementList)property.invokeGetterMethod(this.getModelElement());
    }

    public SortedSet<String> read(ModelPath path) {
        TreeSet<String> result = new TreeSet<String>();
        this.read(path, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(ModelPath path, Collection<String> result) {
        IModel iModel = this.getModelElement().getModel();
        synchronized (iModel) {
            ModelPath.Segment head = path.head();
            IModelElement element = this.getModelElement();
            if (head instanceof ModelPath.ModelRootSegment) {
                element.getModel().service().read(path.tail(), result);
            } else if (head instanceof ModelPath.ParentElementSegment) {
                IModelParticle parent = element.getParent();
                if (parent == null) {
                    this.logInvalidModelPathMessage(path);
                    return;
                }
                if (parent instanceof ModelElementList) {
                    parent = parent.getParent();
                }
                ((IModelElement)parent).service().read(path.tail(), result);
            } else if (head instanceof ModelPath.AllSiblingsSegment) {
                IModelParticle parent = element.getParent();
                if (parent == null || !(parent instanceof ModelElementList)) {
                    this.logInvalidModelPathMessage(path);
                    return;
                }
                parent = parent.getParent();
                ModelPath p = new ModelPath(element.getParentProperty().getName()).append(path.tail());
                ((IModelElement)parent).service().read(p, result);
            } else if (head instanceof ModelPath.AllDescendentsSegment) {
                for (ModelProperty property : element.getModelElementType().getProperties()) {
                    Object obj = this.read(property);
                    if (obj instanceof Value) {
                        String val = ((Value)obj).getText();
                        if (val == null) continue;
                        result.add(val);
                        continue;
                    }
                    if (obj instanceof IModelElement) {
                        ((IModelElement)obj).service().read(path, result);
                        continue;
                    }
                    if (!(obj instanceof ModelElementList)) continue;
                    for (IModelElement entry : (ModelElementList)obj) {
                        entry.service().read(path, result);
                    }
                }
            } else if (head instanceof ModelPath.TypeFilterSegment) {
                String t = element.getModelElementType().getSimpleName();
                boolean match = false;
                for (String type : ((ModelPath.TypeFilterSegment)head).getTypes()) {
                    if (!type.equalsIgnoreCase(t)) continue;
                    match = true;
                    break;
                }
                if (match) {
                    this.read(path.tail(), result);
                }
            } else {
                String propertyName = ((ModelPath.PropertySegment)head).getPropertyName();
                ModelProperty property = element.getModelElementType().getProperty(propertyName);
                if (property == null) {
                    this.logInvalidModelPathMessage(path);
                    return;
                }
                Object obj = this.read(property);
                if (obj instanceof Value) {
                    String val = ((Value)obj).getText();
                    if (val != null) {
                        result.add(val);
                    }
                    if (path.length() != 1) {
                        this.logInvalidModelPathMessage(path);
                        return;
                    }
                } else if (obj instanceof IModelElement) {
                    ((IModelElement)obj).service().read(path.tail(), result);
                } else if (obj instanceof ModelElementList) {
                    for (IModelElement entry : (ModelElementList)obj) {
                        entry.service().read(path.tail(), result);
                    }
                }
            }
        }
    }

    public void write(ValueProperty property, Object value) {
        property.invokeSetterMethod(this.getModelElement(), value);
    }

    public boolean isEnabled(ModelProperty property) {
        if (property == null) {
            throw new IllegalArgumentException();
        }
        List<Object> enablers = null;
        if (this.enablers.containsKey(property)) {
            enablers = this.enablers.get(property);
        } else {
            EnablerImpl enabler;
            enablers = new ArrayList();
            for (EnabledByBooleanProperty enabledByBooleanProperty : property.getAnnotations(EnabledByBooleanProperty.class)) {
                BooleanPropertyEnabler enabler2 = new BooleanPropertyEnabler();
                ((EnablerImpl)enabler2).init(this.getModelElement(), property, new String[]{enabledByBooleanProperty.value()});
                enablers.add(enabler2);
            }
            for (EnabledByEnumProperty enabledByEnumProperty : property.getAnnotations(EnabledByEnumProperty.class)) {
                StringBuilder buf = new StringBuilder();
                String[] stringArray = enabledByEnumProperty.values();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    if (buf.length() > 0) {
                        buf.append(',');
                    }
                    buf.append(value);
                    ++n2;
                }
                enabler = new EnumPropertyEnabler();
                enabler.init(this.getModelElement(), property, new String[]{enabledByEnumProperty.property(), buf.toString()});
                enablers.add(enabler);
            }
            for (Enabler enabler2 : property.getAnnotations(Enabler.class)) {
                Class<? extends EnablerImpl> enablerClass = enabler2.impl();
                try {
                    enabler = enablerClass.newInstance();
                    enabler.init(this.getModelElement(), property, enabler2.params());
                    enablers.add(enabler);
                }
                catch (Exception e) {
                    SapphireModelingFrameworkPlugin.log(e);
                }
            }
            for (EnabledWhen enabledWhen : property.getAnnotations(EnabledWhen.class)) {
                ScriptBasedEnabler enabler3 = new ScriptBasedEnabler();
                ((EnablerImpl)enabler3).init(this.getModelElement(), property, new String[]{enabledWhen.value()});
                enablers.add(enabler3);
            }
            int n = enablers.size();
            if (n == 0) {
                enablers = null;
            } else if (n == 1) {
                enablers = Collections.singletonList((EnablerImpl)enablers.get(0));
            }
            this.enablers.put(property, enablers);
        }
        if (enablers != null) {
            for (EnablerImpl enablerImpl : enablers) {
                try {
                    if (enablerImpl.isEnabled()) continue;
                    return false;
                }
                catch (Exception e) {
                    SapphireModelingFrameworkPlugin.log(e);
                }
            }
        }
        return true;
    }

    public String getDefaultValue(ValueProperty property) {
        DefaultValueProviderImpl provider;
        String defaultValue;
        if (property == null) {
            throw new IllegalArgumentException();
        }
        if (!this.defaultValues.containsKey(property)) {
            defaultValue = null;
            DefaultValueProviderImpl defaultValueProvider = null;
            DefaultValue defaultValueAnnotation = property.getAnnotation(DefaultValue.class);
            if (defaultValueAnnotation != null) {
                defaultValue = defaultValueAnnotation.value();
            } else {
                DefaultValueProvider defaultValueProviderAnnotation = property.getAnnotation(DefaultValueProvider.class);
                if (defaultValueProviderAnnotation != null) {
                    Class<? extends DefaultValueProviderImpl> defaultValueProviderClass = defaultValueProviderAnnotation.impl();
                    try {
                        defaultValueProvider = defaultValueProviderClass.newInstance();
                        defaultValueProvider.init(this.getModelElement(), property, defaultValueProviderAnnotation.params());
                    }
                    catch (Exception e) {
                        SapphireModelingFrameworkPlugin.log(e);
                        defaultValueProvider = null;
                    }
                }
            }
            this.defaultValues.put(property, defaultValue);
            this.defaultValueProviders.put(property, defaultValueProvider);
        }
        if ((defaultValue = this.defaultValues.get(property)) == null && (provider = this.defaultValueProviders.get(property)) != null) {
            try {
                defaultValue = provider.getDefaultValue();
            }
            catch (Exception e) {
                SapphireModelingFrameworkPlugin.log(e);
            }
        }
        return defaultValue;
    }

    public PossibleValuesProviderImpl getPossibleValuesProvider(ValueProperty property) {
        if (property == null) {
            throw new IllegalArgumentException();
        }
        PossibleValuesProviderImpl valuesProvider = null;
        if (this.valuesProviders.containsKey(property)) {
            valuesProvider = this.valuesProviders.get(property);
        } else {
            PossibleValuesFromModel possibleValuesFromModelAnnotation;
            PossibleValues possibleValuesAnnotation;
            PossibleValuesProvider valuesProviderAnnotation = property.getAnnotation(PossibleValuesProvider.class);
            if (valuesProviderAnnotation != null) {
                Class<? extends PossibleValuesProviderImpl> valuesProviderClass = valuesProviderAnnotation.impl();
                try {
                    valuesProvider = valuesProviderClass.newInstance();
                    valuesProvider.init(this.getModelElement(), property, valuesProviderAnnotation.invalidValueMessage(), valuesProviderAnnotation.invalidValueSeverity(), valuesProviderAnnotation.caseSensitive(), valuesProviderAnnotation.params());
                }
                catch (Exception e) {
                    SapphireModelingFrameworkPlugin.log(e);
                    valuesProvider = null;
                }
            }
            if (valuesProvider == null && (possibleValuesAnnotation = property.getAnnotation(PossibleValues.class)) != null) {
                valuesProvider = new StaticValuesProvider(possibleValuesAnnotation.values());
                valuesProvider.init(this.getModelElement(), property, possibleValuesAnnotation.invalidValueMessage(), possibleValuesAnnotation.invalidValueSeverity(), possibleValuesAnnotation.caseSensitive(), new String[0]);
            }
            if (valuesProvider == null && (possibleValuesFromModelAnnotation = property.getAnnotation(PossibleValuesFromModel.class)) != null) {
                valuesProvider = new PossibleValuesFromModelProvider(new ModelPath(possibleValuesFromModelAnnotation.path()));
                valuesProvider.init(this.getModelElement(), property, possibleValuesFromModelAnnotation.invalidValueMessage(), possibleValuesFromModelAnnotation.invalidValueSeverity(), possibleValuesFromModelAnnotation.caseSensitive(), new String[0]);
            }
            this.valuesProviders.put(property, valuesProvider);
        }
        return valuesProvider;
    }

    private void logInvalidModelPathMessage(ModelPath path) {
        String message = NLS.bind((String)Resources.invalidModelPath, (Object)this.getModelElement().getModelElementType().getModelElementClass().getName(), (Object)path.toString());
        SapphireModelingFrameworkPlugin.logError(message, null);
    }

    private static final class Resources
    extends NLS {
        public static String invalidModelPath;

        static {
            Resources.initializeMessages((String)StandardModelElementService.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

