/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.util.Locale;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelParticle;
import org.eclipse.sapphire.modeling.ModelStore;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.ModelPropertyValidator;
import org.eclipse.sapphire.modeling.serialization.ValueSerializationService;
import org.eclipse.sapphire.modeling.util.internal.MiscUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Value<T>
extends ModelParticle {
    private final ValueProperty property;
    private final String raw;
    private final T parsed;
    private IStatus valres;
    private boolean defaultValueInitialized;
    private String defaultText;
    private T defaultContent;

    public Value(IModelElement parent, ValueProperty property, String value) {
        super(parent);
        this.property = property;
        this.raw = this.normalize(value);
        this.parsed = this.parse(property.decodeKeywords(this.raw));
        this.valres = null;
        this.defaultValueInitialized = false;
        this.defaultText = null;
        this.defaultContent = null;
    }

    public void init() {
        this.initValidation();
        this.initDefaultValue();
    }

    private void initValidation() {
        if (this.valres == null) {
            ModelPropertyValidator<?> validator = this.property.getValidator();
            this.valres = validator == null ? Status.OK_STATUS : validator.validate(this);
        }
    }

    private void initDefaultValue() {
        if (!this.defaultValueInitialized) {
            this.defaultText = this.normalize(this.getParent().service().getDefaultValue(this.property));
            this.defaultContent = this.parse(this.property.decodeKeywords(this.defaultText));
            this.defaultValueInitialized = true;
        }
    }

    @Override
    public IModelElement getParent() {
        return (IModelElement)super.getParent();
    }

    public ValueProperty getProperty() {
        return this.property;
    }

    public String getText() {
        return this.getText(true);
    }

    public String getText(boolean useDefaultValue) {
        if (this.raw != null) {
            return this.raw;
        }
        if (useDefaultValue) {
            return this.getDefaultText();
        }
        return null;
    }

    public String getLocalizedText() {
        return this.getLocalizedText(true, Locale.getDefault());
    }

    public String getLocalizedText(boolean useDefaultValue) {
        return this.getLocalizedText(useDefaultValue, Locale.getDefault());
    }

    public String getLocalizedText(boolean useDefaultValue, Locale locale) {
        String originalText = this.getText(useDefaultValue);
        if (originalText != null) {
            ModelStore modelStore = this.getModel().getModelStore();
            return modelStore.getLocalizedText(originalText, locale);
        }
        return null;
    }

    public T getContent() {
        return this.getContent(true);
    }

    public T getContent(boolean useDefaultValue) {
        if (this.parsed != null) {
            return this.parsed;
        }
        if (useDefaultValue) {
            return this.getDefaultContent();
        }
        return null;
    }

    public boolean isDefault() {
        return this.raw == null;
    }

    public T getDefaultContent() {
        this.initDefaultValue();
        return this.defaultContent;
    }

    public String getDefaultText() {
        this.initDefaultValue();
        return this.defaultText;
    }

    public boolean isMalformed() {
        if (this.isDefault()) {
            this.initDefaultValue();
            return this.defaultText != null && this.defaultContent == null;
        }
        return this.raw != null && this.parsed == null;
    }

    @Override
    public IStatus validate() {
        this.initValidation();
        return this.valres;
    }

    public boolean equals(Object val) {
        if (this == val) {
            return true;
        }
        if (val == null) {
            return false;
        }
        this.init();
        Value value = (Value)val;
        return this.getParent() == value.getParent() && this.property == value.property && MiscUtil.equal(this.raw, value.raw) && Value.equal(this.valres, value.valres) && MiscUtil.equal(this.defaultText, value.defaultText);
    }

    public int hashCode() {
        int hashCode = this.getParent().hashCode();
        hashCode ^= this.property.hashCode();
        return hashCode ^= this.raw == null ? 1 : this.raw.hashCode();
    }

    public String toString() {
        return this.raw == null ? "<null>" : this.raw;
    }

    private T parse(String str) {
        if (str == null) {
            return null;
        }
        return (T)this.getParent().service(ValueSerializationService.class).decode(this.property, str);
    }

    private String normalize(String str) {
        if (str != null && str.length() == 0) {
            str = null;
        }
        return str;
    }

    private static boolean equal(IStatus x, IStatus y) {
        return x.getMessage().equals(y.getMessage()) && x.getSeverity() == y.getSeverity();
    }
}

