/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.annotations.processor;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.MirroredTypeException;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.type.VoidType;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.IRemovable;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ReferenceValue;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DelegateImplementation;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.annotations.processor.SapphireAnnotationsProcessor;
import org.eclipse.sapphire.modeling.annotations.processor.util.AccessModifier;
import org.eclipse.sapphire.modeling.annotations.processor.util.Body;
import org.eclipse.sapphire.modeling.annotations.processor.util.ClassModel;
import org.eclipse.sapphire.modeling.annotations.processor.util.FieldModel;
import org.eclipse.sapphire.modeling.annotations.processor.util.IndentingPrintWriter;
import org.eclipse.sapphire.modeling.annotations.processor.util.MethodModel;
import org.eclipse.sapphire.modeling.annotations.processor.util.MethodParameterModel;
import org.eclipse.sapphire.modeling.annotations.processor.util.ParameterizedTypeReference;
import org.eclipse.sapphire.modeling.annotations.processor.util.TypeReference;
import org.eclipse.sapphire.modeling.annotations.processor.util.WildcardTypeReference;
import org.eclipse.sapphire.modeling.serialization.ValueSerializationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenerateModelElementProcessor
extends SapphireAnnotationsProcessor {
    private static final String DATA_REFRESH_METHOD = "refresh.method";
    private static final String DATA_HAS_CONTENTS = "has.contents";
    protected static final String DATA_VARIABLE_NAME = "variable.name";
    protected static final String DATA_IMPL_TYPE = "impl.type";
    protected static final String DATA_ELEMENT_TYPE = "element.type";
    protected static final String DATA_ELEMENT_TYPE_REMOVABLE = "element.type.removable";
    protected static final String DATA_LIST_TYPE = "list.type";
    protected static final String DATA_LIST_MEMBER_TYPE = "list.member.type";
    protected static final String DATA_PROPERTIES = "properties";

    @Override
    public void process(AnnotationProcessorEnvironment env, Declaration annotatedEntity, AnnotationMirror annotation) {
        try {
            if (annotation == null || annotatedEntity == null) {
                return;
            }
            if (!(annotatedEntity instanceof InterfaceDeclaration)) {
                return;
            }
            InterfaceDeclaration interfaceDeclaration = (InterfaceDeclaration)annotatedEntity;
            ClassModel implClassModel = new ClassModel();
            this.process(implClassModel, interfaceDeclaration);
            PrintWriter pw = env.getFiler().createSourceFile(implClassModel.getName().getQualifiedName());
            try {
                implClassModel.write(new IndentingPrintWriter(pw));
            }
            finally {
                pw.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void preProcess(InterfaceDeclaration elInterface, ClassModel elImplClass) {
    }

    protected void postProcess(InterfaceDeclaration elInterface, ClassModel elImplClass) {
    }

    protected void generateRemoveMethodBody(InterfaceDeclaration elInterface, ClassModel elImplClass, Body removeMethodBody) {
    }

    protected boolean prepareValueProperty(InterfaceDeclaration elInterface, ClassModel elImplClass, PropertyFieldDeclaration property) {
        return true;
    }

    protected abstract void generateValuePropertyReadLogic(InterfaceDeclaration var1, ClassModel var2, PropertyFieldDeclaration var3, Body var4);

    protected abstract void generateValuePropertyWriteLogic(InterfaceDeclaration var1, ClassModel var2, PropertyFieldDeclaration var3, Body var4);

    protected boolean prepareElementProperty(InterfaceDeclaration elInterface, ClassModel elImplClass, PropertyFieldDeclaration property) {
        return true;
    }

    protected abstract void generateElementPropertyRefreshLogic(InterfaceDeclaration var1, ClassModel var2, PropertyFieldDeclaration var3, Body var4);

    protected abstract void generateElementPropertyCreateLogic(InterfaceDeclaration var1, ClassModel var2, PropertyFieldDeclaration var3, Body var4);

    protected abstract void generateListPropertyInitLogic(InterfaceDeclaration var1, ClassModel var2, PropertyFieldDeclaration var3, Body var4);

    protected static boolean isInstanceOf(TypeMirror type, String interfaceOrClass) {
        if (type instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)type;
            return GenerateModelElementProcessor.isInstanceOf(declaredType.getDeclaration(), interfaceOrClass);
        }
        return false;
    }

    protected static boolean isInstanceOf(TypeDeclaration type, String interfaceOrClass) {
        if (type != null) {
            ClassType superClassType;
            if (type.getQualifiedName().equals(interfaceOrClass)) {
                return true;
            }
            if (type instanceof ClassDeclaration && (superClassType = ((ClassDeclaration)type).getSuperclass()) != null && GenerateModelElementProcessor.isInstanceOf((TypeDeclaration)superClassType.getDeclaration(), interfaceOrClass)) {
                return true;
            }
            for (InterfaceType superInterface : type.getSuperinterfaces()) {
                if (!GenerateModelElementProcessor.isInstanceOf((TypeMirror)superInterface, interfaceOrClass)) continue;
                return true;
            }
        }
        return false;
    }

    private void process(final ClassModel implClassModel, InterfaceDeclaration interfaceDeclaration) {
        this.preProcess(interfaceDeclaration, implClassModel);
        final TreeMap propFields = new TreeMap();
        implClassModel.setData(DATA_PROPERTIES, propFields);
        Visitor<FieldDeclaration> fieldsVisitor = new Visitor<FieldDeclaration>(){

            @Override
            public void visit(FieldDeclaration field) {
                String fieldName = field.getSimpleName();
                if (fieldName != null && fieldName.startsWith("PROP_")) {
                    PropertyFieldDeclaration propFieldDeclaration = (PropertyFieldDeclaration)propFields.get(fieldName);
                    if (propFieldDeclaration == null) {
                        propFieldDeclaration = new PropertyFieldDeclaration();
                        propFieldDeclaration.name = fieldName;
                        propFieldDeclaration.propertyName = GenerateModelElementProcessor.preparePropName(fieldName);
                        propFields.put(fieldName, propFieldDeclaration);
                    }
                    propFieldDeclaration.declarations.addFirst(field);
                }
            }
        };
        GenerateModelElementProcessor.visitAllFields(interfaceDeclaration, fieldsVisitor);
        for (PropertyFieldDeclaration field : propFields.values()) {
            if (GenerateModelElementProcessor.isInstanceOf(field.getType(), ValueProperty.class.getName())) {
                this.processValueProperty(implClassModel, interfaceDeclaration, field);
                continue;
            }
            if (GenerateModelElementProcessor.isInstanceOf(field.getType(), ElementProperty.class.getName())) {
                this.processElementProperty(implClassModel, interfaceDeclaration, field);
                continue;
            }
            if (!GenerateModelElementProcessor.isInstanceOf(field.getType(), ListProperty.class.getName())) continue;
            this.processListProperty(implClassModel, interfaceDeclaration, field);
        }
        Visitor<MethodDeclaration> methodsVisitor = new Visitor<MethodDeclaration>(){

            @Override
            public void visit(MethodDeclaration method) {
                DelegateImplementation delegateImplementationAnnotation = (DelegateImplementation)method.getAnnotation(DelegateImplementation.class);
                if (delegateImplementationAnnotation != null) {
                    MethodModel m = implClassModel.addMethod(method.getSimpleName());
                    m.setReturnType(GenerateModelElementProcessor.toTypeReference(method.getReturnType()));
                    for (ParameterDeclaration param : method.getParameters()) {
                        MethodParameterModel p = new MethodParameterModel();
                        p.setName(param.getSimpleName());
                        p.setType(GenerateModelElementProcessor.toTypeReference(param.getType()));
                        m.addParameter(p);
                    }
                    TypeReference delegate = null;
                    try {
                        delegateImplementationAnnotation.value();
                    }
                    catch (MirroredTypeException e) {
                        ClassDeclaration typeMirror = ((ClassType)e.getTypeMirror()).getDeclaration();
                        delegate = new TypeReference(typeMirror.getQualifiedName());
                    }
                    Body mb = m.getBody();
                    mb.append("synchronized( this.model )");
                    mb.openBlock();
                    StringBuilder buf = new StringBuilder();
                    if (m.getReturnType() != TypeReference.VOID_TYPE) {
                        buf.append("return ");
                    }
                    buf.append(delegate.getSimpleName()).append('.').append(m.getName()).append("( this");
                    for (MethodParameterModel param : m.getParameters()) {
                        buf.append(", ");
                        buf.append(param.getName());
                    }
                    buf.append(" );");
                    mb.append(buf.toString());
                    mb.closeBlock();
                    implClassModel.addImport(delegate);
                }
            }
        };
        GenerateModelElementProcessor.visitAllMethods(interfaceDeclaration, methodsVisitor);
        MethodModel mRefresh = GenerateModelElementProcessor.getRefreshMethod(implClassModel, false);
        if (mRefresh != null) {
            implClassModel.removeMethod(mRefresh);
            implClassModel.addMethod(mRefresh);
            mRefresh.getBody().closeBlock();
        }
        if (GenerateModelElementProcessor.isInstanceOf((TypeDeclaration)interfaceDeclaration, IRemovable.class.getName())) {
            MethodModel rm = implClassModel.addMethod("remove");
            Body rmb = rm.getBody();
            rmb.append("synchronized( this.model )");
            rmb.openBlock();
            this.generateRemoveMethodBody(interfaceDeclaration, implClassModel, rmb);
            rmb.closeBlock();
            rmb.appendEmptyLine();
            rmb.append("final IModelParticle parent = getParent();\n\nif( parent != null )\n{\n    if( parent instanceof ModelElementList<?> )\n    {\n        ( (ModelElementList<?>) parent ).handleElementRemovedEvent();\n    }\n    else\n    {\n        ( (IModelElement) parent ).refresh( getParentProperty() );\n    }\n}");
            implClassModel.addImport(IModelElement.class);
            implClassModel.addImport(IModelParticle.class);
            implClassModel.addImport(ModelElementList.class);
        }
        this.postProcess(interfaceDeclaration, implClassModel);
    }

    private void processValueProperty(ClassModel implClassModel, InterfaceDeclaration interfaceDeclaration, PropertyFieldDeclaration propField) {
        try {
            this.processValuePropertyInternal(implClassModel, interfaceDeclaration, propField);
        }
        catch (RuntimeException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            InterfaceDeclaration modelElementInterface = propField.getDeclaringType();
            pw.println();
            pw.println("RuntimeException encountered during processValueProperty() method call.");
            pw.println();
            pw.println("interfaceDeclaration : " + (modelElementInterface == null ? "null" : modelElementInterface.getQualifiedName()));
            pw.println("propField : " + propField.name);
            pw.println();
            e.printStackTrace(pw);
            pw.println();
            pw.flush();
            System.err.println(sw.getBuffer().toString());
            throw e;
        }
    }

    private void processValuePropertyInternal(ClassModel implClassModel, InterfaceDeclaration interfaceDeclaration, PropertyFieldDeclaration propField) {
        boolean includeThisProperty = this.prepareValueProperty(interfaceDeclaration, implClassModel, propField);
        if (!includeThisProperty) {
            return;
        }
        TypeReference baseType = null;
        ParameterizedTypeReference wrapperType = null;
        Reference referenceAnnotation = propField.getAnnotation(Reference.class);
        if (referenceAnnotation != null) {
            baseType = new TypeReference(String.class);
            try {
                referenceAnnotation.target();
            }
            catch (MirroredTypeException e) {
                TypeMirror mirror = e.getTypeMirror();
                TypeReference targetType = GenerateModelElementProcessor.toTypeReference(mirror);
                Collection typeParams = mirror instanceof TypeDeclaration ? ((TypeDeclaration)mirror).getFormalTypeParameters() : ((DeclaredType)mirror).getDeclaration().getFormalTypeParameters();
                if (!typeParams.isEmpty()) {
                    Object[] params = new TypeReference[typeParams.size()];
                    Arrays.fill(params, WildcardTypeReference.INSTANCE);
                    targetType = targetType.parameterize((TypeReference[])params);
                }
                wrapperType = new TypeReference(ReferenceValue.class).parameterize(targetType);
            }
        } else {
            Type typeAnnotation = propField.getAnnotation(Type.class);
            if (typeAnnotation == null) {
                baseType = new TypeReference(String.class);
            } else {
                try {
                    typeAnnotation.base();
                }
                catch (MirroredTypeException e) {
                    baseType = GenerateModelElementProcessor.toTypeReference(e.getTypeMirror());
                }
            }
            wrapperType = new TypeReference(Value.class).parameterize(baseType);
        }
        String variableName = String.valueOf(propField.propertyName.substring(0, 1).toLowerCase()) + propField.propertyName.substring(1);
        propField.setData(DATA_VARIABLE_NAME, variableName);
        String setterMethodName = "set" + propField.propertyName;
        String getterMethodName = null;
        InterfaceDeclaration modelElementInterface = propField.getDeclaringType();
        String getterAlt1 = "get" + propField.propertyName;
        String getterAlt2 = "is" + propField.propertyName;
        MethodDeclaration getterMethod = GenerateModelElementProcessor.findMethodDeclaration(modelElementInterface, getterAlt1);
        if (getterMethod == null) {
            getterMethod = GenerateModelElementProcessor.findMethodDeclaration(modelElementInterface, getterAlt2);
        }
        if (getterMethod == null) {
            throw new IllegalStateException("Unable to find getter method for " + modelElementInterface.getSimpleName() + '@' + propField.name);
        }
        getterMethodName = getterMethod.getSimpleName();
        FieldModel field = implClassModel.addField();
        field.setName(variableName);
        field.setType(wrapperType);
        field.setValue("null");
        Body rb = GenerateModelElementProcessor.prepareRefreshMethodBlock(implClassModel, propField);
        rb.append("if( this.#1 != null || force == true )", variableName);
        rb.openBlock();
        rb.append("final #1 oldValue = this.#2;", wrapperType.getSimpleName(), variableName);
        this.generateValuePropertyReadLogic(interfaceDeclaration, implClassModel, propField, rb);
        rb.appendEmptyLine();
        rb.append("this.#1 = new #2( this, #3, #3.encodeKeywords( val ) );\nthis.#1.init();\n\nfinal boolean propertyEnabledStatusChanged = refreshPropertyEnabledStatus( #3 );\n\nif( oldValue != null )\n{\n    if( this.#1.equals( oldValue ) )\n    {\n        this.#1 = oldValue;\n    }\n    \n    if( this.#1 != oldValue || propertyEnabledStatusChanged )\n    {\n        notifyPropertyChangeListeners( #3 );\n    }\n}", variableName, wrapperType.getSimpleName(), propField.name);
        rb.closeBlock();
        rb.closeBlock();
        MethodModel getter = implClassModel.addMethod();
        getter.setName(getterMethodName);
        getter.setReturnType(wrapperType);
        Body gb = getter.getBody();
        gb.append("synchronized( this.model )\n{\n    if( this.#1 == null )\n    {\n        refresh( #2, true );\n    }\n    \n    return this.#1;\n}", variableName, propField.name);
        MethodModel setter = null;
        if (GenerateModelElementProcessor.findMethodDeclaration(modelElementInterface, setterMethodName) != null) {
            setter = implClassModel.addMethod();
            setter.setName(setterMethodName);
            MethodParameterModel param = new MethodParameterModel("value", String.class);
            param.setFinal(false);
            setter.addParameter(param);
            Body sb = setter.getBody();
            sb.append("synchronized( this.model )");
            sb.openBlock();
            sb.append("if( value != null && value.equals( \"\" ) )\n{\n    value = null;\n}\n\nvalue = #1.decodeKeywords( value );\n\nrefresh( #1, true );", propField.name);
            sb.appendEmptyLine();
            sb.append("if( ! equal( this.#1.getText( false ), value ) )", variableName);
            sb.openBlock();
            sb.append("validateEdit();");
            this.generateValuePropertyWriteLogic(interfaceDeclaration, implClassModel, propField, sb);
            sb.append("refresh( #1, false );", propField.name);
            sb.closeBlock();
            sb.closeBlock();
            if (!baseType.getQualifiedName().equals(String.class.getName())) {
                MethodModel setterForTyped = implClassModel.addMethod();
                setterForTyped.setName(setterMethodName);
                setterForTyped.addParameter(new MethodParameterModel("value", baseType));
                Body stb = setterForTyped.getBody();
                stb.append("#1( value != null ? service( ValueSerializationService.class ).encode( #2, value ) : null );", setterMethodName, propField.name);
                implClassModel.addImport(ValueSerializationService.class);
            }
        }
    }

    private void processElementProperty(ClassModel implClassModel, InterfaceDeclaration interfaceDeclaration, PropertyFieldDeclaration propField) {
        try {
            this.processElementPropertyInternal(implClassModel, interfaceDeclaration, propField);
        }
        catch (RuntimeException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            InterfaceDeclaration modelElementInterface = propField.getDeclaringType();
            pw.println();
            pw.println("RuntimeException encountered during processElementProperty() method call.");
            pw.println();
            pw.println("modelElementInterface : " + (modelElementInterface == null ? "null" : modelElementInterface.getQualifiedName()));
            pw.println("propField : " + propField.name);
            pw.println();
            e.printStackTrace(pw);
            pw.println();
            pw.flush();
            System.err.println(sw.getBuffer().toString());
            throw e;
        }
    }

    private void processElementPropertyInternal(ClassModel implClassModel, InterfaceDeclaration interfaceDeclaration, PropertyFieldDeclaration propField) {
        boolean includeThisProperty = this.prepareElementProperty(interfaceDeclaration, implClassModel, propField);
        if (!includeThisProperty) {
            return;
        }
        String getterMethodName = "get" + propField.propertyName;
        String variableName = String.valueOf(propField.propertyName.substring(0, 1).toLowerCase()) + propField.propertyName.substring(1);
        propField.setData(DATA_VARIABLE_NAME, variableName);
        TypeReference type = null;
        boolean removableType = false;
        TypeReference implType = null;
        InterfaceDeclaration modelElementInterface = propField.getDeclaringType();
        for (MethodDeclaration method : modelElementInterface.getMethods()) {
            TypeMirror getterReturnType;
            String methodName = method.getSimpleName();
            if (!methodName.equals(getterMethodName) || !((getterReturnType = method.getReturnType()) instanceof DeclaredType)) continue;
            TypeDeclaration getterReturnTypeDeclaration = ((DeclaredType)getterReturnType).getDeclaration();
            type = new TypeReference(getterReturnTypeDeclaration.getQualifiedName());
            propField.setData(DATA_ELEMENT_TYPE, type);
            removableType = GenerateModelElementProcessor.isInstanceOf(getterReturnTypeDeclaration, IRemovable.class.getName());
            propField.setData(DATA_ELEMENT_TYPE_REMOVABLE, removableType);
            implType = new TypeReference(String.valueOf(getterReturnTypeDeclaration.getPackage().getQualifiedName()) + ".internal." + type.getSimpleName().substring(1));
            propField.setData(DATA_IMPL_TYPE, implType);
        }
        FieldModel f1 = implClassModel.addField();
        f1.setName(variableName);
        f1.setType(type);
        if (removableType) {
            FieldModel f2 = implClassModel.addField();
            f2.setName(String.valueOf(variableName) + "Cached");
            f2.setType(TypeReference.BOOLEAN_TYPE);
            f2.setValue("false");
        }
        MethodModel getter1 = implClassModel.addMethod();
        getter1.setName(getterMethodName);
        getter1.setReturnType(type);
        Body rb = GenerateModelElementProcessor.prepareRefreshMethodBlock(implClassModel, propField);
        if (removableType) {
            getter1.getBody().append("return " + getterMethodName + "( false );\n");
            MethodModel getter2 = implClassModel.addMethod(getterMethodName);
            getter2.setReturnType(type);
            getter2.addParameter(new MethodParameterModel("createIfNecessary", TypeReference.BOOLEAN_TYPE));
            Body g2b = getter2.getBody();
            g2b.append("synchronized( this.model )");
            g2b.openBlock();
            g2b.append("if( this.#1Cached == false )\n{\n    refresh( #2, true );\n}", variableName, propField.name);
            g2b.appendEmptyLine();
            g2b.append("if( this.#1 == null && createIfNecessary )", variableName);
            g2b.openBlock();
            g2b.append("validateEdit();");
            this.generateElementPropertyCreateLogic(interfaceDeclaration, implClassModel, propField, g2b);
            g2b.append("refresh( #1, true );", propField.name);
            g2b.closeBlock();
            g2b.appendEmptyLine();
            g2b.append("return this.#1;", variableName);
            g2b.closeBlock();
            rb.append("if( this.#1Cached == true || force == true )", variableName);
            rb.openBlock();
            rb.append("this.#1Cached = true;", variableName);
            rb.appendEmptyLine();
            rb.append("#1 element = null;", type.getSimpleName());
            rb.appendEmptyLine();
            this.generateElementPropertyRefreshLogic(interfaceDeclaration, implClassModel, propField, rb);
            rb.appendEmptyLine();
            rb.append("final boolean propertyEnabledStatusChanged = refreshPropertyEnabledStatus( #2 );\n\nif( this.#1 != element )\n{\n    if( this.#1 != null )\n    {\n        this.#1.dispose();\n    }\n    \n    this.#1 = element;\n    \n    notifyPropertyChangeListeners( #2 );\n}\nelse if( propertyEnabledStatusChanged )\n{\n    notifyPropertyChangeListeners( #2 );\n}", variableName, propField.name);
            rb.closeBlock();
        } else {
            Body g1b = getter1.getBody();
            g1b.append("synchronized( this.model )\n{\n    if( this.#1 == null )\n    {\n        refresh( #2, true );\n    }\n    \n    return this.#1;\n}", variableName, propField.name);
            rb.append("if( this.#1 == null && force == true )\n{\n    this.#1 = new #2( this, #3 );\n}\n\nfinal boolean propertyEnabledStatusChanged = refreshPropertyEnabledStatus( #3 );\n\nif( propertyEnabledStatusChanged )\n{\n    notifyPropertyChangeListeners( #3 );\n}", variableName, implType.getSimpleName(), propField.name);
        }
        rb.closeBlock();
        implClassModel.addImport(implType);
    }

    private void processListProperty(ClassModel implClassModel, InterfaceDeclaration interfaceDeclaration, PropertyFieldDeclaration propField) {
        try {
            this.processListPropertyInternal(implClassModel, interfaceDeclaration, propField);
        }
        catch (RuntimeException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            InterfaceDeclaration modelElementInterface = propField.getDeclaringType();
            pw.println();
            pw.println("RuntimeException encountered during processListProperty() method call.");
            pw.println();
            pw.println("modelElementInterface : " + (modelElementInterface == null ? "null" : modelElementInterface.getQualifiedName()));
            pw.println("propField : " + propField.name);
            pw.println();
            e.printStackTrace(pw);
            pw.println();
            pw.flush();
            System.err.println(sw.getBuffer().toString());
            throw e;
        }
    }

    private void processListPropertyInternal(ClassModel implClassModel, InterfaceDeclaration interfaceDeclaration, PropertyFieldDeclaration propField) {
        String getterMethodName = "get" + propField.propertyName;
        String variableName = String.valueOf(propField.propertyName.substring(0, 1).toLowerCase()) + propField.propertyName.substring(1);
        propField.setData(DATA_VARIABLE_NAME, variableName);
        TypeReference memberType = null;
        Type typeAnnotation = propField.getAnnotation(Type.class);
        try {
            typeAnnotation.base();
        }
        catch (MirroredTypeException e) {
            InterfaceDeclaration typeMirror = ((InterfaceType)e.getTypeMirror()).getDeclaration();
            memberType = new TypeReference(typeMirror.getQualifiedName());
        }
        ParameterizedTypeReference listType = new TypeReference(ModelElementList.class).parameterize(memberType);
        propField.setData(DATA_LIST_MEMBER_TYPE, memberType);
        propField.setData(DATA_LIST_TYPE, listType);
        FieldModel field = implClassModel.addField();
        field.setName(variableName);
        field.setType(listType);
        MethodModel g = implClassModel.addMethod();
        g.setName(getterMethodName);
        g.setReturnType(listType);
        Body gb = g.getBody();
        gb.append("synchronized( this.model )\n{\n    if( this.#1 == null )\n    {\n        refresh( #2, true );\n    }\n    \n    return this.#1;\n}", variableName, propField.name);
        Body rb = GenerateModelElementProcessor.prepareRefreshMethodBlock(implClassModel, propField);
        rb.append("final boolean propertyEnabledStatusChanged = refreshPropertyEnabledStatus( #1 );", propField.name);
        rb.appendEmptyLine();
        rb.append("if( this.#1 == null && force == true )", variableName);
        rb.openBlock();
        this.generateListPropertyInitLogic(interfaceDeclaration, implClassModel, propField, rb);
        rb.closeBlock();
        rb.appendEmptyLine();
        rb.append("if( this.#1 != null )\n{\n    final boolean notified = this.#1.refresh();\n    \n    if( ! notified && propertyEnabledStatusChanged )\n    {\n        notifyPropertyChangeListeners( #2 );\n    }\n}", variableName, propField.name);
        rb.closeBlock();
    }

    private static final MethodDeclaration findMethodDeclaration(InterfaceDeclaration interfaceDeclaration, String methodName) {
        List<MethodDeclaration> results = GenerateModelElementProcessor.findMethodDeclarations(interfaceDeclaration, methodName);
        if (results.isEmpty()) {
            return null;
        }
        return results.get(0);
    }

    private static final List<MethodDeclaration> findMethodDeclarations(InterfaceDeclaration interfaceDeclaration, String methodName) {
        ArrayList<MethodDeclaration> results = new ArrayList<MethodDeclaration>();
        GenerateModelElementProcessor.findMethodDeclarations(interfaceDeclaration, methodName, results);
        return results;
    }

    private static final void findMethodDeclarations(InterfaceDeclaration interfaceDeclaration, String methodName, List<MethodDeclaration> results) {
        for (MethodDeclaration method : interfaceDeclaration.getMethods()) {
            if (!method.getSimpleName().equals(methodName)) continue;
            results.add(method);
        }
        for (InterfaceType superInterfaceType : interfaceDeclaration.getSuperinterfaces()) {
            GenerateModelElementProcessor.findMethodDeclarations(superInterfaceType.getDeclaration(), methodName, results);
        }
    }

    private static final String preparePropName(String propFieldName) {
        StringBuilder buf = new StringBuilder();
        boolean seenFirstSegment = false;
        String[] stringArray = propFieldName.split("_");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if (seenFirstSegment) {
                buf.append(segment.charAt(0));
                buf.append(segment.substring(1).toLowerCase());
            } else {
                seenFirstSegment = true;
            }
            ++n2;
        }
        return buf.toString();
    }

    private static void visitAllMethods(InterfaceDeclaration interfaceDeclaration, Visitor<MethodDeclaration> visitor) {
        for (InterfaceType superInterface : interfaceDeclaration.getSuperinterfaces()) {
            InterfaceDeclaration superInterfaceDeclaration = superInterface.getDeclaration();
            GenerateModelElementProcessor.visitAllMethods(superInterfaceDeclaration, visitor);
        }
        for (MethodDeclaration method : interfaceDeclaration.getMethods()) {
            visitor.visit(method);
        }
    }

    private static void visitAllFields(InterfaceDeclaration interfaceDeclaration, Visitor<FieldDeclaration> visitor) {
        for (InterfaceType superInterface : interfaceDeclaration.getSuperinterfaces()) {
            InterfaceDeclaration superInterfaceDeclaration = superInterface.getDeclaration();
            GenerateModelElementProcessor.visitAllFields(superInterfaceDeclaration, visitor);
        }
        for (FieldDeclaration field : interfaceDeclaration.getFields()) {
            visitor.visit(field);
        }
    }

    private static MethodModel getRefreshMethod(ClassModel implClassModel, boolean createIfNecessary) {
        MethodModel refreshMethod = (MethodModel)implClassModel.getData(DATA_REFRESH_METHOD);
        if (refreshMethod == null && createIfNecessary) {
            refreshMethod = implClassModel.addMethod("refreshProperty");
            refreshMethod.setAccessModifier(AccessModifier.PROTECTED);
            refreshMethod.addParameter(new MethodParameterModel("property", ModelProperty.class, false));
            refreshMethod.addParameter(new MethodParameterModel("force", TypeReference.BOOLEAN_TYPE));
            refreshMethod.setData(DATA_HAS_CONTENTS, Boolean.FALSE);
            implClassModel.setData(DATA_REFRESH_METHOD, refreshMethod);
            Body rb = refreshMethod.getBody();
            rb.append("synchronized( this.model )");
            rb.openBlock();
            rb.append("property = property.refine( this );");
            rb.appendEmptyLine();
        }
        return refreshMethod;
    }

    private static Body prepareRefreshMethodBlock(ClassModel implClassModel, PropertyFieldDeclaration propField) {
        boolean hasPriorContent;
        MethodModel refreshMethod = GenerateModelElementProcessor.getRefreshMethod(implClassModel, true);
        Body rb = refreshMethod.getBody();
        if (refreshMethod.getData(DATA_HAS_CONTENTS) == Boolean.TRUE) {
            hasPriorContent = true;
        } else {
            hasPriorContent = false;
            refreshMethod.setData(DATA_HAS_CONTENTS, Boolean.TRUE);
        }
        rb.append("#1if( property == #2 )", hasPriorContent ? "else " : "", propField.name);
        rb.openBlock();
        return rb;
    }

    private static TypeReference toTypeReference(TypeMirror typeMirror) {
        if (typeMirror instanceof VoidType) {
            return TypeReference.VOID_TYPE;
        }
        if (typeMirror instanceof PrimitiveType) {
            return TypeReference.PRIMITIVE_TYPES.get(((PrimitiveType)typeMirror).getKind());
        }
        if (typeMirror instanceof DeclaredType) {
            return new TypeReference(((DeclaredType)typeMirror).getDeclaration().getQualifiedName());
        }
        if (typeMirror instanceof ArrayType) {
            return GenerateModelElementProcessor.toTypeReference(((ArrayType)typeMirror).getComponentType()).array(1);
        }
        return new TypeReference(((TypeDeclaration)typeMirror).getQualifiedName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PropertyFieldDeclaration {
        public String name;
        public String propertyName;
        public LinkedList<FieldDeclaration> declarations = new LinkedList();
        private Map<String, Object> data = new HashMap<String, Object>();

        public TypeMirror getType() {
            if (this.declarations.isEmpty()) {
                return null;
            }
            return this.declarations.getFirst().getType();
        }

        public InterfaceDeclaration getDeclaringType() {
            if (!this.declarations.isEmpty()) {
                TypeDeclaration declaringType = this.declarations.getFirst().getDeclaringType();
                if (declaringType instanceof InterfaceDeclaration) {
                    return (InterfaceDeclaration)declaringType;
                }
                if (declaringType instanceof InterfaceType) {
                    return ((InterfaceType)declaringType).getDeclaration();
                }
                throw new IllegalStateException();
            }
            return null;
        }

        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            Annotation annotation = null;
            for (FieldDeclaration fd : this.declarations) {
                annotation = fd.getAnnotation(annotationType);
                if (annotation != null) break;
            }
            return (A)annotation;
        }

        public Object getData(String key) {
            return this.data.get(key);
        }

        public void setData(String key, Object value) {
            this.data.put(key, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Visitor<T> {
        public void visit(T var1);
    }
}

