/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.internal;

import java.util.ArrayList;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.EnablerImpl;
import org.eclipse.sapphire.modeling.internal.SapphireModelingFrameworkPlugin;
import org.eclipse.sapphire.modeling.serialization.ValueSerializationService;

public final class EnumPropertyEnabler
extends EnablerImpl {
    private ValueProperty property;
    private ValueSerializationService serializationService;
    private Enum<?>[] values;

    public void init(IModelElement element, ModelProperty property, String[] params) {
        super.init(element, property, params);
        if (params.length != 2) {
            throw new IllegalArgumentException();
        }
        ModelProperty prop = element.getModelElementType().getProperty(params[0]);
        if (prop == null) {
            throw new IllegalArgumentException();
        }
        if (!Enum.class.isAssignableFrom(prop.getTypeClass())) {
            throw new IllegalArgumentException();
        }
        this.property = (ValueProperty)prop;
        this.serializationService = element.service(ValueSerializationService.class);
        ArrayList<Enum> valuesList = new ArrayList<Enum>();
        String[] stringArray = params[1].split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            Enum value = (Enum)this.serializationService.decode(this.property, segment);
            if (value != null) {
                valuesList.add(value);
            } else {
                String message = NLS.bind((String)Resources.couldNotDecode, (Object[])new Object[]{element.getModelElementType().getModelElementClass().getName(), property.getName(), segment});
                SapphireModelingFrameworkPlugin.logError(message, null);
            }
            ++n2;
        }
        this.values = valuesList.toArray(new Enum[valuesList.size()]);
    }

    public boolean isEnabled() {
        IModelElement element = this.getModelElement();
        if (element.isPropertyEnabled(this.property)) {
            Value result;
            try {
                result = (Value)this.property.invokeGetterMethod(element);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            String res = result.getText(true);
            if (res != null) {
                Enum<?>[] enumArray = this.values;
                int n = this.values.length;
                int n2 = 0;
                while (n2 < n) {
                    Enum<?> value = enumArray[n2];
                    if (value == this.serializationService.decode(this.property, res)) {
                        return true;
                    }
                    ++n2;
                }
            }
        }
        return false;
    }

    private static final class Resources
    extends NLS {
        public static String couldNotDecode;

        static {
            Resources.initializeMessages((String)EnumPropertyEnabler.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

