/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.serialization;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.ModelElementService;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.extensibility.SerializersExtensionPoint;
import org.eclipse.sapphire.modeling.internal.SapphireModelingFrameworkPlugin;
import org.eclipse.sapphire.modeling.serialization.ValueSerializer;
import org.eclipse.sapphire.modeling.serialization.ValueSerializerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValueSerializationService
extends ModelElementService {
    private static final ValueSerializerImpl<Object> DEFAULT_SERIALIZER = new ValueSerializerImpl<Object>(){

        @Override
        protected Object decodeFromString(String value) {
            return value;
        }
    };
    private final Map<ValueProperty, ValueSerializerImpl<Object>> serializers = Collections.synchronizedMap(new HashMap());

    public String encode(ValueProperty property, Object value) {
        return this.getSerializer(property).encode(value);
    }

    public Object decode(ValueProperty property, String value) {
        return this.getSerializer(property).decode(value);
    }

    private ValueSerializerImpl<Object> getSerializer(ValueProperty property) {
        Class<?> type = property.getTypeClass();
        ValueSerializerImpl<Object> serializer = DEFAULT_SERIALIZER;
        if (type != String.class) {
            serializer = this.serializers.get(property);
            ValueSerializer valueSerializerAnnotation = property.getAnnotation(ValueSerializer.class);
            if (valueSerializerAnnotation != null) {
                try {
                    serializer = valueSerializerAnnotation.impl().newInstance();
                    serializer.init(this.getModelElement(), property, valueSerializerAnnotation.params());
                }
                catch (Exception e) {
                    SapphireModelingFrameworkPlugin.log(e);
                }
            }
            if (serializer == null) {
                serializer = SerializersExtensionPoint.getSerializer(type);
                if (serializer != null) {
                    try {
                        serializer.init(this.getModelElement(), property, new String[0]);
                    }
                    catch (Exception e) {
                        SapphireModelingFrameworkPlugin.log(e);
                        serializer = DEFAULT_SERIALIZER;
                    }
                } else {
                    String message = NLS.bind((String)Resources.noSerializer, (Object[])new Object[]{this.getModelElement().getModelElementType().getModelElementClass().getName(), property.getName(), type.getName()});
                    SapphireModelingFrameworkPlugin.logError(message, null);
                    serializer = DEFAULT_SERIALIZER;
                }
                this.serializers.put(property, serializer);
            }
        }
        return serializer;
    }

    private static final class Resources
    extends NLS {
        public static String noSerializer;

        static {
            Resources.initializeMessages((String)ValueSerializationService.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

