/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml;

import org.eclipse.sapphire.modeling.DelimitedListController;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.xml.IModelElementForXml;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlNode;
import org.eclipse.sapphire.modeling.xml.XmlPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DelimitedListControllerForXml<T extends IModelElement>
extends DelimitedListController<T> {
    private final XmlPath path;

    public DelimitedListControllerForXml(XmlPath path, char delimiter) {
        super(',');
        this.path = path;
    }

    @Override
    protected final String read() {
        IModelElementForXml parent = (IModelElementForXml)this.getModelElement();
        XmlElement parentXmlElement = parent.getXmlElement();
        if (parentXmlElement == null) {
            return null;
        }
        XmlNode listXmlNode = parentXmlElement.getChildNode(this.path, false);
        if (listXmlNode == null) {
            return null;
        }
        return listXmlNode.getText();
    }

    @Override
    protected final void write(String str) {
        IModelElementForXml parent = (IModelElementForXml)this.getModelElement();
        XmlElement parentXmlElement = parent.getXmlElement(true);
        XmlNode listXmlNode = parentXmlElement.getChildNode(this.path, false);
        if (str == null) {
            if (listXmlNode != null) {
                listXmlNode.remove();
            }
        } else {
            parentXmlElement.setChildNodeText(this.path, str, false);
        }
    }
}

