/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.calendar.integrated.internal;

import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.LayeredModelStore;
import org.eclipse.sapphire.modeling.ModelElementListener;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.samples.calendar.IAttendee;
import org.eclipse.sapphire.samples.calendar.integrated.internal.AttendeeStub;
import org.eclipse.sapphire.samples.contacts.IContact;
import org.eclipse.sapphire.samples.contacts.IContactsDatabase;

public final class Attendee
extends AttendeeStub {
    private final IAttendee base;
    private final IContactsDatabase contacts;
    private final ModelElementListener listener;

    public Attendee(IModelParticle parent, ModelProperty parentProperty, IAttendee base) {
        super(parent, parentProperty);
        this.base = base;
        this.contacts = (IContactsDatabase)((LayeredModelStore)this.getModel().getModelStore()).getModel(1);
        this.listener = new ModelElementListener(){

            public void propertyChanged(ModelPropertyChangeEvent event) {
                ModelProperty property = event.getProperty();
                if (property == IAttendee.PROP_NAME) {
                    Attendee.this.refresh((ModelProperty)PROP_NAME);
                    Attendee.this.refresh((ModelProperty)PROP_IN_CONTACTS_DATABASE);
                    Attendee.this.refresh((ModelProperty)PROP_E_MAIL);
                } else if (property == IAttendee.PROP_TYPE) {
                    Attendee.this.refresh((ModelProperty)PROP_TYPE);
                } else if (property == IContactsDatabase.PROP_CONTACTS) {
                    Attendee.this.refresh((ModelProperty)PROP_IN_CONTACTS_DATABASE);
                    Attendee.this.refresh((ModelProperty)PROP_E_MAIL);
                } else if (property == IContact.PROP_NAME) {
                    Attendee.this.refresh((ModelProperty)PROP_IN_CONTACTS_DATABASE);
                    Attendee.this.refresh((ModelProperty)PROP_E_MAIL);
                } else if (property == IContact.PROP_E_MAIL) {
                    Attendee.this.refresh((ModelProperty)PROP_E_MAIL);
                }
            }
        };
        this.base.addListener(this.listener);
        this.contacts.addListener(this.listener);
    }

    IAttendee getBase() {
        return this.base;
    }

    protected String readName() {
        return this.base.getName().getText(false);
    }

    protected void writeName(String name) {
        this.base.setName(name);
    }

    protected String readType() {
        return this.base.getType().getText(false);
    }

    protected void writeType(String type) {
        this.base.setType(type);
    }

    protected String readInContactsDatabase() {
        return this.findContactRecord(false) != null ? Boolean.TRUE.toString() : null;
    }

    protected String readEMail() {
        IContact c = this.findContactRecord(false);
        return c != null ? c.getEMail().getText() : null;
    }

    protected void writeEMail(String eMail) {
        IContact c = this.findContactRecord(eMail != null);
        if (c != null) {
            c.setEMail(eMail);
        }
    }

    protected void doRemove() {
        this.base.remove();
    }

    private IContact findContactRecord(boolean createIfNecessary) {
        IContact c = null;
        String name = this.getName().getText();
        if (name != null) {
            for (IContact contact : this.contacts.getContacts()) {
                if (!name.equals(contact.getName().getText())) continue;
                c = contact;
                break;
            }
            if (c == null && createIfNecessary) {
                c = (IContact)this.contacts.getContacts().addNewElement();
                c.setName(name);
            }
            for (IContact contact : this.contacts.getContacts()) {
                contact.addListener(this.listener);
            }
        }
        return c;
    }
}

