/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.calendar.integrated.internal;

import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElementListener;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.samples.calendar.IEventAttachment;
import org.eclipse.sapphire.samples.calendar.integrated.internal.EventAttachmentStub;

public final class EventAttachment
extends EventAttachmentStub {
    private final IEventAttachment base;
    private final ModelElementListener listener;

    public EventAttachment(IModelParticle parent, ModelProperty parentProperty, IEventAttachment base) {
        super(parent, parentProperty);
        this.base = base;
        this.listener = new ModelElementListener(){

            public void propertyChanged(ModelPropertyChangeEvent event) {
                ModelProperty property = event.getProperty();
                if (property == IEventAttachment.PROP_LOCAL_COPY_LOCATION) {
                    EventAttachment.this.refresh((ModelProperty)PROP_LOCAL_COPY_LOCATION);
                } else if (property == IEventAttachment.PROP_PUBLIC_COPY_LOCATION) {
                    EventAttachment.this.refresh((ModelProperty)PROP_PUBLIC_COPY_LOCATION);
                }
            }
        };
        this.base.addListener(this.listener);
    }

    IEventAttachment getBase() {
        return this.base;
    }

    protected String readLocalCopyLocation() {
        return this.base.getLocalCopyLocation().getText(false);
    }

    protected void writeLocalCopyLocation(String localCopyLocation) {
        this.base.setLocalCopyLocation(localCopyLocation);
    }

    protected String readPublicCopyLocation() {
        return this.base.getPublicCopyLocation().getText(false);
    }

    protected void writePublicCopyLocation(String publicCopyLocation) {
        this.base.setPublicCopyLocation(publicCopyLocation);
    }

    protected void doRemove() {
        this.base.remove();
    }
}

