/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.calendar.integrated.internal;

import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.sapphire.modeling.IModel;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.serialization.ValueSerializationService;
import org.eclipse.sapphire.samples.calendar.integrated.IEventAttachment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EventAttachmentStub
extends ModelElement
implements IEventAttachment {
    private Value<IPath> localCopyLocation = null;
    private Value<URL> publicCopyLocation = null;

    public EventAttachmentStub(IModelParticle parent, ModelProperty parentProperty) {
        super(TYPE, parent, parentProperty);
    }

    protected abstract String readLocalCopyLocation();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<IPath> getLocalCopyLocation() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.localCopyLocation == null) {
                this.refresh((ModelProperty)PROP_LOCAL_COPY_LOCATION, true);
            }
            return this.localCopyLocation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLocalCopyLocation(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_LOCAL_COPY_LOCATION.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_LOCAL_COPY_LOCATION, true);
            if (!EventAttachmentStub.equal((String)this.localCopyLocation.getText(false), (String)value)) {
                this.validateEdit();
                this.writeLocalCopyLocation(value);
                this.refresh((ModelProperty)PROP_LOCAL_COPY_LOCATION, false);
            }
        }
    }

    protected abstract void writeLocalCopyLocation(String var1);

    @Override
    public void setLocalCopyLocation(IPath value) {
        this.setLocalCopyLocation(value != null ? ((ValueSerializationService)this.service(ValueSerializationService.class)).encode(PROP_LOCAL_COPY_LOCATION, (Object)value) : null);
    }

    protected abstract String readPublicCopyLocation();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<URL> getPublicCopyLocation() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.publicCopyLocation == null) {
                this.refresh((ModelProperty)PROP_PUBLIC_COPY_LOCATION, true);
            }
            return this.publicCopyLocation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPublicCopyLocation(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_PUBLIC_COPY_LOCATION.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_PUBLIC_COPY_LOCATION, true);
            if (!EventAttachmentStub.equal((String)this.publicCopyLocation.getText(false), (String)value)) {
                this.validateEdit();
                this.writePublicCopyLocation(value);
                this.refresh((ModelProperty)PROP_PUBLIC_COPY_LOCATION, false);
            }
        }
    }

    protected abstract void writePublicCopyLocation(String var1);

    @Override
    public void setPublicCopyLocation(URL value) {
        this.setPublicCopyLocation(value != null ? ((ValueSerializationService)this.service(ValueSerializationService.class)).encode(PROP_PUBLIC_COPY_LOCATION, (Object)value) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModel iModel = this.model;
        synchronized (iModel) {
            property = property.refine((IModelElement)this);
            if (property == PROP_LOCAL_COPY_LOCATION) {
                if (this.localCopyLocation != null || force) {
                    Value<IPath> oldValue = this.localCopyLocation;
                    String val = this.readLocalCopyLocation();
                    this.localCopyLocation = new Value((IModelElement)this, PROP_LOCAL_COPY_LOCATION, PROP_LOCAL_COPY_LOCATION.encodeKeywords(val));
                    this.localCopyLocation.init();
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_LOCAL_COPY_LOCATION);
                    if (oldValue != null) {
                        if (this.localCopyLocation.equals(oldValue)) {
                            this.localCopyLocation = oldValue;
                        }
                        if (this.localCopyLocation != oldValue || propertyEnabledStatusChanged) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_LOCAL_COPY_LOCATION);
                        }
                    }
                }
            } else if (property == PROP_PUBLIC_COPY_LOCATION && (this.publicCopyLocation != null || force)) {
                Value<URL> oldValue = this.publicCopyLocation;
                String val = this.readPublicCopyLocation();
                this.publicCopyLocation = new Value((IModelElement)this, PROP_PUBLIC_COPY_LOCATION, PROP_PUBLIC_COPY_LOCATION.encodeKeywords(val));
                this.publicCopyLocation.init();
                boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_PUBLIC_COPY_LOCATION);
                if (oldValue != null) {
                    if (this.publicCopyLocation.equals(oldValue)) {
                        this.publicCopyLocation = oldValue;
                    }
                    if (this.publicCopyLocation != oldValue || propertyEnabledStatusChanged) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_PUBLIC_COPY_LOCATION);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        IModel iModel = this.model;
        synchronized (iModel) {
            this.validateEdit();
            this.doRemove();
        }
        IModelParticle parent = this.getParent();
        if (parent != null) {
            if (parent instanceof ModelElementList) {
                ((ModelElementList)parent).handleElementRemovedEvent();
            } else {
                ((IModelElement)parent).refresh(this.getParentProperty());
            }
        }
    }

    protected abstract void doRemove();
}

