/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.calendar.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.sapphire.modeling.IModel;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.LayeredModelStore;
import org.eclipse.sapphire.modeling.xml.ModelStoreForXml;
import org.eclipse.sapphire.samples.calendar.CalendarFactory;
import org.eclipse.sapphire.samples.calendar.ICalendar;
import org.eclipse.sapphire.samples.contacts.ContactsDatabaseFactory;
import org.eclipse.sapphire.samples.contacts.IContactsDatabase;
import org.eclipse.sapphire.ui.SapphireEditor;
import org.eclipse.sapphire.ui.editor.views.masterdetails.MasterDetailsPage;
import org.eclipse.sapphire.ui.xml.ModelStoreForXmlEditor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.wst.sse.ui.StructuredTextEditor;

public final class CalendarEditor
extends SapphireEditor {
    private StructuredTextEditor calendarSourceEditor;
    private StructuredTextEditor contactsSourceEditor;
    private ICalendar modelCalendar;
    private org.eclipse.sapphire.samples.calendar.integrated.ICalendar modelCalendarIntegrated;
    private IContactsDatabase modelContacts;
    private MasterDetailsPage calendarDesignPage;
    private MasterDetailsPage contactsDesignPage;

    public CalendarEditor() {
        super("org.eclipse.sapphire.samples");
    }

    protected void createSourcePages() throws PartInitException {
        this.calendarSourceEditor = new StructuredTextEditor();
        this.calendarSourceEditor.setEditorPart((IEditorPart)this);
        FileEditorInput rootEditorInput = (FileEditorInput)this.getEditorInput();
        int index = this.addPage((IEditorPart)this.calendarSourceEditor, (IEditorInput)rootEditorInput);
        this.setPageText(index, "calendar.xml");
        this.contactsSourceEditor = new StructuredTextEditor();
        this.contactsSourceEditor.setEditorPart((IEditorPart)this);
        IFile contactsFile = rootEditorInput.getFile().getParent().getFile((IPath)new Path("contacts.xml"));
        index = this.addPage((IEditorPart)this.contactsSourceEditor, (IEditorInput)new FileEditorInput(contactsFile));
        this.setPageText(index, "contacts.xml");
    }

    protected IModel createModel() {
        this.modelCalendar = CalendarFactory.load((ModelStoreForXml)new ModelStoreForXmlEditor((SapphireEditor)this, this.calendarSourceEditor));
        this.modelContacts = ContactsDatabaseFactory.load((ModelStoreForXml)new ModelStoreForXmlEditor((SapphireEditor)this, this.contactsSourceEditor));
        LayeredModelStore modelStore = new LayeredModelStore(new IModel[]{this.modelCalendar, this.modelContacts});
        this.modelCalendarIntegrated = org.eclipse.sapphire.samples.calendar.integrated.CalendarFactory.load(modelStore);
        return this.modelCalendarIntegrated;
    }

    protected final void createFormPages() throws PartInitException {
        Path path = new Path("org.eclipse.sapphire.samples/sdef/CalendarEditor.sdef/main");
        this.calendarDesignPage = new MasterDetailsPage((SapphireEditor)this, (IModelElement)this.modelCalendarIntegrated, (IPath)path);
        this.addPage(0, (IFormPage)this.calendarDesignPage);
        path = new Path("org.eclipse.sapphire.samples/sdef/ContactsDatabaseEditor.sdef/main");
        this.contactsDesignPage = new MasterDetailsPage((SapphireEditor)this, (IModelElement)this.modelContacts, (IPath)path, "Contacts");
        this.addPage(1, (IFormPage)this.contactsDesignPage);
    }

    public IContentOutlinePage getContentOutline(Object page) {
        if (page == this.calendarSourceEditor) {
            return (IContentOutlinePage)this.calendarSourceEditor.getAdapter(IContentOutlinePage.class);
        }
        if (page == this.contactsSourceEditor) {
            return (IContentOutlinePage)this.contactsSourceEditor.getAdapter(IContentOutlinePage.class);
        }
        return super.getContentOutline(page);
    }

    public ICalendar getCalendar() {
        return this.modelCalendar;
    }

    public org.eclipse.sapphire.samples.calendar.integrated.ICalendar getCalendarIntegrated() {
        return this.modelCalendarIntegrated;
    }

    public IContactsDatabase getContactsDatabase() {
        return this.modelContacts;
    }
}

