/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.contacts;

import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DependsOn;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NonNullValue;
import org.eclipse.sapphire.modeling.annotations.PossibleValuesProvider;
import org.eclipse.sapphire.modeling.xml.IModelElementForXml;
import org.eclipse.sapphire.modeling.xml.annotations.GenerateXmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlNamespace;
import org.eclipse.sapphire.samples.contacts.internal.CityNameValuesProvider;
import org.eclipse.sapphire.samples.contacts.internal.StateCodeValuesProvider;
import org.eclipse.sapphire.samples.contacts.internal.ZipCodeValuesProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GenerateXmlBinding(elementPath={"address"})
@XmlNamespace(uri="http://www.eclipse.org/sapphire/samples/address", prefix="a")
public interface IAddress
extends IModelElementForXml {
    public static final ModelElementType TYPE = new ModelElementType(IAddress.class);
    @XmlBinding(path="a:street")
    @Label(standard="street")
    @NonNullValue
    public static final ValueProperty PROP_STREET = new ValueProperty(TYPE, "Street");
    @XmlBinding(path="a:city")
    @Label(standard="city")
    @NonNullValue
    @PossibleValuesProvider(impl=CityNameValuesProvider.class, caseSensitive=false, invalidValueMessage="\"{0}\" is not a valid city for the specified state and ZIP code.")
    @DependsOn(value={"ZipCode", "State"})
    public static final ValueProperty PROP_CITY = new ValueProperty(TYPE, "City");
    @XmlBinding(path="a:state")
    @Label(standard="state")
    @NonNullValue
    @PossibleValuesProvider(impl=StateCodeValuesProvider.class, caseSensitive=false, invalidValueMessage="\"{0}\" is not a valid state postal code for the specified city and ZIP code.")
    @DependsOn(value={"ZipCode", "City"})
    public static final ValueProperty PROP_STATE = new ValueProperty(TYPE, "State");
    @XmlBinding(path="a:zip")
    @Label(standard="ZIP code")
    @NonNullValue
    @PossibleValuesProvider(impl=ZipCodeValuesProvider.class, caseSensitive=false, invalidValueMessage="\"{0}\" is not a valid ZIP code for the specified city and state.")
    @DependsOn(value={"State", "City"})
    public static final ValueProperty PROP_ZIP_CODE = new ValueProperty(TYPE, "ZipCode");

    public Value<String> getStreet();

    public void setStreet(String var1);

    public Value<String> getCity();

    public void setCity(String var1);

    public Value<String> getState();

    public void setState(String var1);

    public Value<String> getZipCode();

    public void setZipCode(String var1);
}

