/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.gallery.internal;

import org.eclipse.sapphire.modeling.IModel;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.xml.ModelElementForXml;
import org.eclipse.sapphire.modeling.xml.ModelStoreForXml;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.samples.gallery.IMultiSelectListGalleryItem;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MultiSelectListGalleryItem
extends ModelElementForXml
implements IMultiSelectListGalleryItem {
    private Value<String> item = null;

    public MultiSelectListGalleryItem(IModelParticle parent, ModelProperty parentProperty, XmlElement element) {
        super(TYPE, parent, parentProperty, element);
        ((ModelStoreForXml)this.getModel().getModelStore()).registerModelElement((Node)element.getDomNode(), (IModelElement)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getItem() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.item == null) {
                this.refresh((ModelProperty)PROP_ITEM, true);
            }
            return this.item;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setItem(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_ITEM.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_ITEM, true);
            if (!MultiSelectListGalleryItem.equal((String)this.item.getText(false), (String)value)) {
                this.validateEdit();
                this.getXmlElement(true).setText(value);
                this.refresh((ModelProperty)PROP_ITEM, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModel iModel = this.model;
        synchronized (iModel) {
            property = property.refine((IModelElement)this);
            if (property == PROP_ITEM && (this.item != null || force)) {
                Value<String> oldValue = this.item;
                XmlElement element = this.getXmlElement(false);
                String val = element == null ? null : element.getText(false);
                this.item = new Value((IModelElement)this, PROP_ITEM, PROP_ITEM.encodeKeywords(val));
                this.item.init();
                boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_ITEM);
                if (oldValue != null) {
                    if (this.item.equals(oldValue)) {
                        this.item = oldValue;
                    }
                    if (this.item != oldValue || propertyEnabledStatusChanged) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_ITEM);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        IModel iModel = this.model;
        synchronized (iModel) {
            XmlElement element = this.getXmlElement(false);
            if (element != null) {
                this.validateEdit();
                element.remove();
            }
        }
        IModelParticle parent = this.getParent();
        if (parent != null) {
            if (parent instanceof ModelElementList) {
                ((ModelElementList)parent).handleElementRemovedEvent();
            } else {
                ((IModelElement)parent).refresh(this.getParentProperty());
            }
        }
    }
}

