/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.zoo.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.sapphire.modeling.IModel;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.serialization.ValueSerializationService;
import org.eclipse.sapphire.modeling.xml.IModelElementForXml;
import org.eclipse.sapphire.modeling.xml.ModelElementForXml;
import org.eclipse.sapphire.modeling.xml.StandardXmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlNode;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.samples.zoo.IFinancialInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FinancialInfo
extends ModelElementForXml
implements IFinancialInfo {
    private static final Map<ModelProperty, XmlPath> MAP_PROP_TO_XML_PATH = new HashMap<ModelProperty, XmlPath>();
    private static final StandardXmlNamespaceResolver NAMESPACE_RESOLVER = new StandardXmlNamespaceResolver(TYPE);
    private static final XmlPath PATH_CURRENT_YEAR_EXPENSES = new XmlPath("expenses", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private static final XmlPath PATH_CURRENT_YEAR_INCOME = new XmlPath("income", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private Value<Integer> currentYearExpenses = null;
    private Value<Integer> currentYearIncome = null;

    static {
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_CURRENT_YEAR_EXPENSES, PATH_CURRENT_YEAR_EXPENSES);
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_CURRENT_YEAR_INCOME, PATH_CURRENT_YEAR_INCOME);
    }

    public FinancialInfo(IModelParticle parent, ModelProperty parentProperty) {
        super(TYPE, parent, parentProperty, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<Integer> getCurrentYearExpenses() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.currentYearExpenses == null) {
                this.refresh((ModelProperty)PROP_CURRENT_YEAR_EXPENSES, true);
            }
            return this.currentYearExpenses;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCurrentYearExpenses(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_CURRENT_YEAR_EXPENSES.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_CURRENT_YEAR_EXPENSES, true);
            if (!FinancialInfo.equal((String)this.currentYearExpenses.getText(false), (String)value)) {
                this.validateEdit();
                this.getXmlElement(true).setChildNodeText(PATH_CURRENT_YEAR_EXPENSES, value, true);
                this.refresh((ModelProperty)PROP_CURRENT_YEAR_EXPENSES, false);
            }
        }
    }

    @Override
    public void setCurrentYearExpenses(Integer value) {
        this.setCurrentYearExpenses(value != null ? ((ValueSerializationService)this.service(ValueSerializationService.class)).encode(PROP_CURRENT_YEAR_EXPENSES, (Object)value) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<Integer> getCurrentYearIncome() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.currentYearIncome == null) {
                this.refresh((ModelProperty)PROP_CURRENT_YEAR_INCOME, true);
            }
            return this.currentYearIncome;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCurrentYearIncome(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_CURRENT_YEAR_INCOME.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_CURRENT_YEAR_INCOME, true);
            if (!FinancialInfo.equal((String)this.currentYearIncome.getText(false), (String)value)) {
                this.validateEdit();
                this.getXmlElement(true).setChildNodeText(PATH_CURRENT_YEAR_INCOME, value, true);
                this.refresh((ModelProperty)PROP_CURRENT_YEAR_INCOME, false);
            }
        }
    }

    @Override
    public void setCurrentYearIncome(Integer value) {
        this.setCurrentYearIncome(value != null ? ((ValueSerializationService)this.service(ValueSerializationService.class)).encode(PROP_CURRENT_YEAR_INCOME, (Object)value) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModel iModel = this.model;
        synchronized (iModel) {
            property = property.refine((IModelElement)this);
            if (property == PROP_CURRENT_YEAR_EXPENSES) {
                if (this.currentYearExpenses != null || force) {
                    Value<Integer> oldValue = this.currentYearExpenses;
                    XmlElement element = this.getXmlElement(false);
                    String val = element == null ? null : element.getChildNodeText(PATH_CURRENT_YEAR_EXPENSES, false);
                    this.currentYearExpenses = new Value((IModelElement)this, PROP_CURRENT_YEAR_EXPENSES, PROP_CURRENT_YEAR_EXPENSES.encodeKeywords(val));
                    this.currentYearExpenses.init();
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_CURRENT_YEAR_EXPENSES);
                    if (oldValue != null) {
                        if (this.currentYearExpenses.equals(oldValue)) {
                            this.currentYearExpenses = oldValue;
                        }
                        if (this.currentYearExpenses != oldValue || propertyEnabledStatusChanged) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_CURRENT_YEAR_EXPENSES);
                        }
                    }
                }
            } else if (property == PROP_CURRENT_YEAR_INCOME && (this.currentYearIncome != null || force)) {
                Value<Integer> oldValue = this.currentYearIncome;
                XmlElement element = this.getXmlElement(false);
                String val = element == null ? null : element.getChildNodeText(PATH_CURRENT_YEAR_INCOME, false);
                this.currentYearIncome = new Value((IModelElement)this, PROP_CURRENT_YEAR_INCOME, PROP_CURRENT_YEAR_INCOME.encodeKeywords(val));
                this.currentYearIncome.init();
                boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_CURRENT_YEAR_INCOME);
                if (oldValue != null) {
                    if (this.currentYearIncome.equals(oldValue)) {
                        this.currentYearIncome = oldValue;
                    }
                    if (this.currentYearIncome != oldValue || propertyEnabledStatusChanged) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_CURRENT_YEAR_INCOME);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlElement getXmlElement(boolean createIfNecessary) {
        IModel iModel = this.model;
        synchronized (iModel) {
            XmlElement root = ((IModelElementForXml)this.getParent()).getXmlElement(createIfNecessary);
            if (root != null) {
                root = root.getChildElement("financials", createIfNecessary);
            }
            return root;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlNode getXmlNode(ModelProperty property) {
        IModel iModel = this.model;
        synchronized (iModel) {
            XmlPath path;
            property = property.refine((IModelElement)this);
            XmlElement el = this.getXmlElement(false);
            if (el != null && (path = MAP_PROP_TO_XML_PATH.get(property)) != null) {
                return el.getChildNode(path, false);
            }
            return null;
        }
    }
}

