/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.actions.Action;
import org.eclipse.sapphire.ui.def.ISapphireActionLinkDef;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.ui.util.SwtUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;

public final class SapphireActionLink
extends SapphirePart {
    private Action action = null;

    public void render(SapphireRenderingContext context) {
        ISapphireActionLinkDef def = (ISapphireActionLinkDef)this.definition;
        if (def.getImplClass().getText() != null) {
            Class actionClass = (Class)def.getImplClass().resolve();
            Action actionTemp = null;
            try {
                actionTemp = (Action)actionClass.newInstance();
            }
            catch (Exception e) {
                SapphireUiFrameworkPlugin.log(e);
            }
            this.action = actionTemp;
            if (this.action != null) {
                this.action.setPart(this);
            }
        } else {
            this.action = this.getAction(def.getActionId().getText());
        }
        Image image = null;
        if (((Boolean)def.getShowImage().getContent()).booleanValue() && this.action != null) {
            image = this.action.getImage();
        }
        Composite composite = new Composite(context.getComposite(), 0);
        composite.setLayout((Layout)SwtUtil.glayout(image == null ? 1 : 2, 0, 0));
        composite.setLayoutData((Object)SwtUtil.gdhindent(SwtUtil.hspan(SwtUtil.gd(), 2), 8));
        if (image != null) {
            Label label = new Label(composite, 0);
            label.setImage(image);
            label.setLayoutData((Object)SwtUtil.valign(SwtUtil.gd(), 0x1000000));
        }
        final FormText text = new FormText(composite, 0);
        text.setLayoutData((Object)SwtUtil.valign(SwtUtil.gdhfill(), 0x1000000));
        context.adapt((Control)text);
        StringBuilder buf = new StringBuilder();
        buf.append("<form><p vspace=\"false\"><a href=\"action\" nowrap=\"true\">");
        buf.append(def.getLabel().getLocalizedText());
        buf.append("</a></p></form>");
        text.setText(buf.toString(), true, false);
        if (this.action != null) {
            text.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent event) {
                    SapphireActionLink.this.action.execute(text.getShell());
                }
            });
        }
    }
}

