/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.SapphirePartContainer;
import org.eclipse.sapphire.ui.SapphirePartEvent;
import org.eclipse.sapphire.ui.SapphirePartListener;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ISapphireCompositeDef;
import org.eclipse.sapphire.ui.util.SwtUtil;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SapphireComposite
extends SapphirePartContainer {
    public final void render(final SapphireRenderingContext context) {
        ScrolledComposite scrolledComposite;
        SapphireRenderingContext ctxt;
        Composite parent = context.getComposite();
        if (this.getPreferFormStyle()) {
            final FormToolkit toolkit = new FormToolkit(context.getDisplay());
            ctxt = new SapphireRenderingContext(this, context, parent){

                public void adapt(Control control) {
                    super.adapt(control);
                    if (control instanceof Composite) {
                        toolkit.adapt((Composite)control);
                    } else if (control instanceof Label) {
                        toolkit.adapt(control, false, false);
                    } else {
                        toolkit.adapt(control, true, true);
                    }
                }
            };
        } else {
            ctxt = context;
        }
        parent = this.createOuterComposite(ctxt);
        ISapphireCompositeDef def = (ISapphireCompositeDef)this.definition;
        boolean indent = (Boolean)def.getIndent().getContent();
        boolean scrollVertically = (Boolean)def.getScrollVertically().getContent();
        boolean scrollHorizontally = (Boolean)def.getScrollHorizontally().getContent();
        if (indent) {
            Label label = new Label(parent, 0);
            label.setLayoutData((Object)SwtUtil.gd());
            context.adapt((Control)label);
        }
        if (scrollVertically || scrollHorizontally) {
            int style = (scrollVertically ? 512 : 0) | (scrollHorizontally ? 256 : 0);
            scrolledComposite = new ScrolledComposite(parent, style);
            scrolledComposite.setExpandHorizontal(true);
            scrolledComposite.setExpandVertical(true);
            parent = scrolledComposite;
        } else {
            scrolledComposite = null;
        }
        boolean expandVertically = this.definition.getHint("expand.vertically", false);
        int widthHint = this.definition.getHint("width", -1);
        int heightHint = this.definition.getHint("height", -1);
        GridData gd = SwtUtil.gdwhint(SwtUtil.gdhhint(SwtUtil.hspan(expandVertically ? SwtUtil.gdfill() : SwtUtil.gdhfill(), indent ? 1 : 2), heightHint), widthHint);
        int marginLeft = (Integer)def.getMarginLeft().getContent();
        int marginRight = (Integer)def.getMarginRight().getContent();
        int marginTop = (Integer)def.getMarginTop().getContent();
        int marginBottom = (Integer)def.getMarginBottom().getContent();
        final Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)SwtUtil.glayout(2, marginLeft, marginRight, marginTop, marginBottom));
        ctxt.adapt((Control)composite);
        if (scrolledComposite != null) {
            scrolledComposite.setContent((Control)composite);
            scrolledComposite.setLayoutData((Object)gd);
        } else {
            composite.setLayoutData((Object)gd);
        }
        String helpContextId = this.definition.getHelpContextId().getText();
        if (helpContextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, helpContextId);
        }
        final SapphireRenderingContext innerContext = new SapphireRenderingContext(this, ctxt, composite);
        super.render(innerContext);
        if (scrolledComposite != null) {
            scrolledComposite.setMinSize(composite.computeSize(-1, -1));
        }
        final SapphirePartListener partListener = new SapphirePartListener(){

            public void handleStructureChangedEvent(SapphirePartEvent event) {
                ISapphirePart part = event.getContext().getPart();
                Boolean needToReRender = null;
                while (part != null && needToReRender == null) {
                    if (!((part = part.getParentPart()) instanceof SapphireComposite)) continue;
                    needToReRender = part == SapphireComposite.this ? Boolean.TRUE : Boolean.FALSE;
                }
                if (needToReRender == Boolean.TRUE) {
                    Control[] controlArray = composite.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control control = controlArray[n2];
                        control.dispose();
                        ++n2;
                    }
                    SapphireComposite.super.render(innerContext);
                    if (scrolledComposite != null) {
                        scrolledComposite.setMinSize(composite.computeSize(-1, -1));
                    }
                    context.layout();
                }
            }
        };
        this.addListener(partListener);
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                SapphireComposite.this.removeListener(partListener);
            }
        });
    }

    protected Composite createOuterComposite(SapphireRenderingContext context) {
        return context.getComposite();
    }

    public boolean getPreferFormStyle() {
        return this.definition.getHint("prefer.form.style", false);
    }
}

