/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sapphire.modeling.EditFailedException;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.SapphireImageCache;
import org.eclipse.sapphire.ui.actions.ActionGroup;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Action {
    private String id = null;
    private String commandId = null;
    private Type type = Type.PUSH;
    private String label = null;
    private ImageDescriptor imageDescriptor = null;
    private Image image = null;
    private boolean visible = true;
    private boolean enabled = true;
    private boolean checked = false;
    private ISapphirePart part = null;
    private final CopyOnWriteArraySet<Listener> listeners = new CopyOnWriteArraySet();
    private final List<ActionGroup> childActionGroups = new ArrayList<ActionGroup>();
    private final List<ActionGroup> childActionGroupsReadOnly = Collections.unmodifiableList(this.childActionGroups);

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCommandId() {
        return this.commandId;
    }

    public void setCommandId(String commandId) {
        this.commandId = commandId;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Image getImage() {
        return this.getImage(false);
    }

    public Image getImage(boolean useDefaultIfNecessary) {
        if (this.image == null) {
            ImageDescriptor imageDescriptor = this.imageDescriptor;
            if (imageDescriptor == null && useDefaultIfNecessary) {
                imageDescriptor = SapphireImageCache.ACTION_DEFAULT;
            }
            if (imageDescriptor != null) {
                this.image = this.getPart().getImageCache().getImage(imageDescriptor);
            }
        }
        return this.image;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.imageDescriptor;
    }

    public void setImageDescriptor(ImageDescriptor imageDescriptor) {
        this.imageDescriptor = imageDescriptor;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public ISapphirePart getPart() {
        return this.part;
    }

    public void setPart(ISapphirePart part) {
        this.part = part;
        for (ActionGroup childActionGroup : this.childActionGroups) {
            childActionGroup.setPart(part);
        }
    }

    public void addListener(Listener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void notifyChangeListeners() {
        for (Listener listener : this.listeners) {
            try {
                listener.handleActionChanged(this);
            }
            catch (Exception e) {
                SapphireUiFrameworkPlugin.log(e);
            }
        }
    }

    public List<ActionGroup> getChildActionGroups() {
        return this.childActionGroupsReadOnly;
    }

    public void addChildActionGroup(ActionGroup group) {
        this.childActionGroups.add(group);
    }

    public final void execute(Shell shell) {
        Object result;
        block5: {
            result = null;
            try {
                result = this.run(shell);
            }
            catch (Exception e) {
                EditFailedException editFailedException = EditFailedException.findAsCause((Throwable)e);
                if (editFailedException != null) break block5;
                SapphireUiFrameworkPlugin.log(e);
            }
        }
        for (Listener listener : this.listeners) {
            try {
                listener.handleActionExecuted(this, result);
            }
            catch (Exception e) {
                SapphireUiFrameworkPlugin.log(e);
            }
        }
    }

    protected abstract Object run(Shell var1);

    public void dispose() {
        if (this.image != null && this.imageDescriptor != null) {
            this.image.dispose();
            this.image = null;
        }
        for (ActionGroup group : this.childActionGroups) {
            group.dispose();
        }
    }

    public static abstract class Listener {
        public void handleActionChanged(Action action) {
        }

        public void handleActionExecuted(Action action, Object result) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        PUSH,
        TOGGLE;

    }
}

