/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.actions.Action;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ActionGroup {
    private final List<Action> actions = new ArrayList<Action>();
    private final List<Action> actionsReadOnly = Collections.unmodifiableList(this.actions);

    public ActionGroup() {
    }

    public ActionGroup(Action action) {
        this();
        this.actions.add(action);
    }

    public ActionGroup(Collection<Action> actions) {
        this();
        for (Action action : actions) {
            this.actions.add(action);
        }
    }

    public boolean isVisible() {
        for (Action action : this.actions) {
            if (!action.isVisible()) continue;
            return true;
        }
        return false;
    }

    public List<Action> getActions() {
        return this.actionsReadOnly;
    }

    public Action getAction(String id) {
        for (Action action : this.actionsReadOnly) {
            if (action.getId().equals(id)) {
                return action;
            }
            for (ActionGroup group : action.getChildActionGroups()) {
                Action childAction = group.getAction(id);
                if (childAction == null) continue;
                return childAction;
            }
        }
        return null;
    }

    public void addAction(Action action) {
        this.actions.add(action);
    }

    public void replaceAction(Action actionToReplace, Action actionToReplaceWith) {
        int index = this.actions.indexOf(actionToReplace);
        if (index != -1) {
            this.actions.set(index, actionToReplaceWith);
        }
    }

    public void setPart(ISapphirePart part) {
        for (Action action : this.actions) {
            action.setPart(part);
        }
    }

    public void dispose() {
        for (Action action : this.actions) {
            action.dispose();
        }
    }
}

