/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.actions;

import java.util.List;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.action.SubToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sapphire.ui.actions.Action;
import org.eclipse.sapphire.ui.actions.ActionGroup;
import org.eclipse.sapphire.ui.util.internal.MutableReference;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ActionsRenderer {
    public static void fillMenu(final Menu menu, List<ActionGroup> groups) {
        boolean first = true;
        for (ActionGroup group : groups) {
            if (!group.isVisible()) continue;
            if (first) {
                first = false;
            } else {
                new MenuItem(menu, 2);
            }
            for (final Action action : group.getActions()) {
                TriggerSequence triggerSequence;
                IBindingService bindingService;
                TriggerSequence[] triggerSequences;
                MenuItem menuItem;
                if (!action.isVisible()) continue;
                List<ActionGroup> childActionGroups = action.getChildActionGroups();
                if (!childActionGroups.isEmpty()) {
                    Menu childMenu = new Menu(menu);
                    menuItem = new MenuItem(menu, 64);
                    menuItem.setText(action.getLabel());
                    menuItem.setImage(action.getImage());
                    menuItem.setMenu(childMenu);
                    ActionsRenderer.fillMenu(childMenu, childActionGroups);
                } else {
                    menuItem = new MenuItem(menu, 8);
                    menuItem.setText(action.getLabel());
                    menuItem.setImage(action.getImage());
                    menuItem.setEnabled(action.isEnabled());
                    menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent event) {
                            action.execute(menu.getShell());
                        }
                    });
                    final Action.Listener actionChangeListener = new Action.Listener(){

                        public void handleActionChanged(Action action) {
                            menuItem.setEnabled(action.isEnabled());
                        }
                    };
                    action.addListener(actionChangeListener);
                    menuItem.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent event) {
                            action.removeListener(actionChangeListener);
                        }
                    });
                }
                String commandId = action.getCommandId();
                if (commandId == null || (triggerSequences = (bindingService = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class)).getActiveBindingsFor(commandId)) == null || triggerSequences.length <= 0 || !((triggerSequence = triggerSequences[0]) instanceof KeySequence)) continue;
                String keySequenceString = SWTKeySupport.getKeyFormatterForPlatform().format((KeySequence)triggerSequence);
                menuItem.setText(String.valueOf(menuItem.getText()) + "\t" + keySequenceString);
            }
        }
    }

    public static void fillToolBar(ToolBar toolbar, List<ActionGroup> groups) {
        ActionsRenderer.fillToolBar(toolbar, groups, false);
    }

    public static void fillToolBar(final ToolBar toolbar, List<ActionGroup> groups, boolean includeTrailingSeparator) {
        boolean first = true;
        for (ActionGroup group : groups) {
            if (!group.isVisible()) continue;
            if (first) {
                first = false;
            } else {
                new ToolItem(toolbar, 2);
            }
            for (final Action action : group.getActions()) {
                SelectionAdapter toolItemListener;
                List<ActionGroup> childActionGroups;
                if (!action.isVisible()) continue;
                int toolItemStyle = action.getType() == Action.Type.TOGGLE ? 32 : 8;
                final ToolItem toolItem = new ToolItem(toolbar, toolItemStyle);
                toolItem.setImage(action.getImage(true));
                toolItem.setToolTipText(action.getLabel());
                toolItem.setEnabled(action.isEnabled());
                if (action.getType() == Action.Type.TOGGLE) {
                    toolItem.setSelection(action.isChecked());
                }
                if (!(childActionGroups = action.getChildActionGroups()).isEmpty()) {
                    final MutableReference popupMenuRef = new MutableReference();
                    toolItemListener = new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent event) {
                            Menu popupMenu = (Menu)popupMenuRef.get();
                            if (popupMenu != null) {
                                popupMenu.dispose();
                            }
                            popupMenu = new Menu((Decorations)toolbar.getShell(), 8);
                            popupMenuRef.set(popupMenu);
                            ActionsRenderer.fillMenu(popupMenu, childActionGroups);
                            Rectangle rect = toolItem.getBounds();
                            Point pt = new Point(rect.x, rect.y + rect.height);
                            pt = toolItem.getParent().toDisplay(pt);
                            popupMenu.setLocation(pt);
                            popupMenu.setVisible(true);
                        }
                    };
                } else {
                    toolItemListener = new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent event) {
                            if (action.getType() == Action.Type.TOGGLE) {
                                action.setChecked(!action.isChecked());
                            }
                            action.execute(toolbar.getShell());
                        }
                    };
                }
                toolItem.addSelectionListener((SelectionListener)toolItemListener);
                final Action.Listener actionChangeListener = new Action.Listener(){

                    public void handleActionChanged(Action action) {
                        toolItem.setImage(action.getImage(true));
                        toolItem.setToolTipText(action.getLabel());
                        toolItem.setEnabled(action.isEnabled());
                    }
                };
                action.addListener(actionChangeListener);
                toolItem.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent event) {
                        action.removeListener(actionChangeListener);
                    }
                });
            }
        }
        if (!first && includeTrailingSeparator) {
            new ToolItem(toolbar, 2);
        }
        toolbar.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent event) {
                String toolTip;
                ToolItem item;
                if (event.childID != -1 && (item = toolbar.getItem(event.childID)) != null && (toolTip = item.getToolTipText()) != null) {
                    event.result = toolTip;
                }
            }
        });
    }

    public static void fillToolBarManager(final IToolBarManager toolbarManager, final Shell shell, List<ActionGroup> groups) {
        boolean first = true;
        for (ActionGroup group : groups) {
            if (!group.isVisible()) continue;
            if (first) {
                first = false;
            } else {
                toolbarManager.add((IContributionItem)new Separator());
            }
            for (final Action action : group.getActions()) {
                if (!action.isVisible()) continue;
                final List<ActionGroup> childActionGroups = action.getChildActionGroups();
                final MutableReference popupMenuRef = new MutableReference();
                int actionStyle = action.getType() == Action.Type.TOGGLE ? 2 : 1;
                final org.eclipse.jface.action.Action a = new org.eclipse.jface.action.Action(null, actionStyle){

                    public void run() {
                        if (!childActionGroups.isEmpty()) {
                            Menu popupMenu = (Menu)popupMenuRef.get();
                            if (popupMenu != null) {
                                popupMenu.dispose();
                            }
                            popupMenu = new Menu((Decorations)shell, 8);
                            popupMenuRef.set(popupMenu);
                            ActionsRenderer.fillMenu(popupMenu, childActionGroups);
                            ToolItem actionToolItem = null;
                            ToolItem[] toolItemArray = this.getToolBar(toolbarManager).getItems();
                            int n = toolItemArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ToolItem toolItem = toolItemArray[n2];
                                Object data = toolItem.getData();
                                if (data instanceof IContributionItem && this.getAction((IContributionItem)data) == this) {
                                    actionToolItem = toolItem;
                                    break;
                                }
                                ++n2;
                            }
                            Rectangle rect = actionToolItem.getBounds();
                            Point pt = new Point(rect.x, rect.y + rect.height);
                            pt = actionToolItem.getParent().toDisplay(pt);
                            popupMenu.setLocation(pt);
                            popupMenu.setVisible(true);
                        } else {
                            if (action.getType() == Action.Type.TOGGLE) {
                                action.setChecked(!action.isChecked());
                            }
                            action.execute(shell);
                        }
                    }

                    private IAction getAction(IContributionItem item) {
                        if (item instanceof ActionContributionItem) {
                            return ((ActionContributionItem)item).getAction();
                        }
                        if (item instanceof SubContributionItem) {
                            return this.getAction(((SubContributionItem)item).getInnerItem());
                        }
                        return null;
                    }

                    private ToolBar getToolBar(IToolBarManager manager) {
                        if (manager instanceof ToolBarManager) {
                            return ((ToolBarManager)manager).getControl();
                        }
                        if (manager instanceof SubToolBarManager) {
                            return this.getToolBar((IToolBarManager)((SubToolBarManager)manager).getParent());
                        }
                        throw new IllegalStateException(manager.getClass().getName());
                    }
                };
                a.setImageDescriptor(ImageDescriptor.createFromImage((Image)action.getImage(true)));
                a.setToolTipText(action.getLabel());
                a.setEnabled(action.isEnabled());
                if (action.getType() == Action.Type.TOGGLE) {
                    a.setChecked(action.isChecked());
                }
                Action.Listener actionChangeListener = new Action.Listener(){

                    public void handleActionChanged(Action action) {
                        a.setImageDescriptor(ImageDescriptor.createFromImage((Image)action.getImage(true)));
                        a.setToolTipText(action.getLabel());
                        a.setEnabled(action.isEnabled());
                    }
                };
                action.addListener(actionChangeListener);
                toolbarManager.add((IAction)a);
            }
        }
        toolbarManager.update(true);
    }
}

