/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.assist.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.EclipseWorkspacePath;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.assist.JumpHandler;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public final class EclipseWorkspacePathValueJumpHandler
extends JumpHandler {
    public boolean isApplicable(ValueProperty property) {
        return property.isOfType(IPath.class) && property.hasAnnotation(EclipseWorkspacePath.class);
    }

    public boolean canLocateJumpTarget(SapphirePart part, SapphireRenderingContext context, IModelElement modelElement, ValueProperty property) {
        IResource resource;
        IPath path = (IPath)((Value)property.invokeGetterMethod((Object)modelElement)).getContent(true);
        return path != null && (resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path)) != null && resource.exists() && resource.getType() == 1;
    }

    public void jump(SapphirePart part, SapphireRenderingContext context, IModelElement modelElement, ValueProperty property) {
        IWorkbenchWindow window;
        IResource resource;
        IPath path = (IPath)((Value)property.invokeGetterMethod((Object)modelElement)).getContent(true);
        if (path != null && (resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path)) != null && resource.exists() && resource.getType() == 1 && (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
            IWorkbenchPage page = window.getActivePage();
            try {
                IDE.openEditor((IWorkbenchPage)page, (IFile)((IFile)resource));
            }
            catch (PartInitException e) {
                SapphireUiFrameworkPlugin.log(e);
            }
        }
    }
}

