/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.assist.internal;

import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueKeyword;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContext;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContribution;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContributor;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistSection;

public final class MinMaxInfoAssistContributor
extends PropertyEditorAssistContributor {
    public MinMaxInfoAssistContributor() {
        this.setId("System.MinMaxInfoContributor");
        this.setPriority(115);
    }

    public void contribute(PropertyEditorAssistContext context) {
        NumericRange range;
        IModelElement element = context.getModelElement();
        ModelProperty property = context.getProperty();
        if (property instanceof ValueProperty && ((Value)property.invokeGetterMethod((Object)element)).getText(false) != null && (range = (NumericRange)property.getAnnotation(NumericRange.class)) != null) {
            String max;
            ValueProperty valprop = (ValueProperty)property;
            PropertyEditorAssistSection section = context.getSection("info");
            String min = range.min();
            if (min.length() > 0) {
                String label = NLS.bind((String)Resources.minValueInfoMessage, (Object)MinMaxInfoAssistContributor.normalizeForDisplay(valprop, min));
                label = "<p>" + MinMaxInfoAssistContributor.escapeForXml(label) + "</p>";
                PropertyEditorAssistContribution contribution = new PropertyEditorAssistContribution();
                contribution.setText(label);
                section.addContribution(contribution);
            }
            if ((max = range.max()).length() > 0) {
                String label = NLS.bind((String)Resources.maxValueInfoMessage, (Object)MinMaxInfoAssistContributor.normalizeForDisplay(valprop, max));
                label = "<p>" + MinMaxInfoAssistContributor.escapeForXml(label) + "</p>";
                PropertyEditorAssistContribution contribution = new PropertyEditorAssistContribution();
                contribution.setText(label);
                section.addContribution(contribution);
            }
        }
    }

    private static final String normalizeForDisplay(ValueProperty property, String value) {
        String result = property.encodeKeywords(property.decodeKeywords(value));
        ValueKeyword keyword = property.getKeyword(result);
        if (keyword != null) {
            result = keyword.toDisplayString();
        }
        return result;
    }

    private static final class Resources
    extends NLS {
        public static String minValueInfoMessage;
        public static String maxValueInfoMessage;

        static {
            Resources.initializeMessages((String)MinMaxInfoAssistContributor.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

