/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.build.internal;

import java.io.ByteArrayOutputStream;
import java.io.Reader;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.sapphire.ui.build.internal.DomUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringResourcesExtractor {
    private static final Set<String> LOCALIZABLE_ELEMENTS = new HashSet<String>();

    static {
        LOCALIZABLE_ELEMENTS.add("page-header-text");
        LOCALIZABLE_ELEMENTS.add("initial-selection");
        LOCALIZABLE_ELEMENTS.add("label");
        LOCALIZABLE_ELEMENTS.add("conditional");
        LOCALIZABLE_ELEMENTS.add("description");
        LOCALIZABLE_ELEMENTS.add("null-value-label");
    }

    public static String extract(Reader input) throws Exception {
        Document doc = DomUtil.doc(input);
        if (doc == null) {
            return null;
        }
        Element root = doc.getDocumentElement();
        if (root == null) {
            return null;
        }
        HashSet<String> resources = new HashSet<String>();
        StringResourcesExtractor.gatherStringResources(root, resources);
        if (resources.isEmpty()) {
            return null;
        }
        Properties resourceLookupTable = new Properties();
        for (String str : resources) {
            String key;
            String keyAlt = key = StringResourcesExtractor.generateResourceKey(str);
            int counter = 0;
            while (resourceLookupTable.containsKey(keyAlt)) {
                keyAlt = String.valueOf(key) + String.valueOf(++counter);
            }
            resourceLookupTable.put(keyAlt, str);
        }
        ByteArrayOutputStream resourcesFileContentBytes = new ByteArrayOutputStream();
        resourceLookupTable.store(resourcesFileContentBytes, null);
        String resourcesFileContent = new String(resourcesFileContentBytes.toByteArray());
        return resourcesFileContent;
    }

    private static void gatherStringResources(Element element, Set<String> resources) {
        String text;
        if (LOCALIZABLE_ELEMENTS.contains(element.getLocalName()) && (text = DomUtil.text(element)) != null && (text = text.trim()).length() != 0) {
            resources.add(text);
        }
        for (Element child : DomUtil.elements(element)) {
            StringResourcesExtractor.gatherStringResources(child, resources);
        }
    }

    private static String generateResourceKey(String str) {
        StringBuilder buf = new StringBuilder();
        if (str.length() > 20) {
            buf.append(str.substring(0, 20));
        } else {
            buf.append(str);
        }
        int i = 0;
        int n = buf.length();
        while (i < n) {
            char ch = buf.charAt(i);
            if (ch >= 'a' && ch <= 'z') {
                buf.setCharAt(i, Character.toUpperCase(ch));
            } else if (!(ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9')) {
                buf.setCharAt(i, '_');
            }
            ++i;
        }
        return buf.toString();
    }
}

