/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.def.internal;

import org.eclipse.sapphire.modeling.IModel;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ReferenceValue;
import org.eclipse.sapphire.modeling.xml.ModelElementForXml;
import org.eclipse.sapphire.modeling.xml.ModelStoreForXml;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.ui.def.ISapphirePartListenerDef;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SapphirePartListenerDef
extends ModelElementForXml
implements ISapphirePartListenerDef {
    private ReferenceValue<Class<?>> listenerClass = null;

    public SapphirePartListenerDef(IModelParticle parent, ModelProperty parentProperty, XmlElement element) {
        super(TYPE, parent, parentProperty, element);
        ((ModelStoreForXml)this.getModel().getModelStore()).registerModelElement((Node)element.getDomNode(), (IModelElement)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReferenceValue<Class<?>> getListenerClass() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.listenerClass == null) {
                this.refresh((ModelProperty)PROP_LISTENER_CLASS, true);
            }
            return this.listenerClass;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setListenerClass(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_LISTENER_CLASS.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_LISTENER_CLASS, true);
            if (!SapphirePartListenerDef.equal((String)this.listenerClass.getText(false), (String)value)) {
                this.validateEdit();
                this.getXmlElement(true).setText(value);
                this.refresh((ModelProperty)PROP_LISTENER_CLASS, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModel iModel = this.model;
        synchronized (iModel) {
            property = property.refine((IModelElement)this);
            if (property == PROP_LISTENER_CLASS && (this.listenerClass != null || force)) {
                ReferenceValue<Class<?>> oldValue = this.listenerClass;
                XmlElement element = this.getXmlElement(false);
                String val = element == null ? null : element.getText(false);
                this.listenerClass = new ReferenceValue((IModelElement)this, PROP_LISTENER_CLASS, PROP_LISTENER_CLASS.encodeKeywords(val));
                this.listenerClass.init();
                boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_LISTENER_CLASS);
                if (oldValue != null) {
                    if (this.listenerClass.equals(oldValue)) {
                        this.listenerClass = oldValue;
                    }
                    if (this.listenerClass != oldValue || propertyEnabledStatusChanged) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_LISTENER_CLASS);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        IModel iModel = this.model;
        synchronized (iModel) {
            XmlElement element = this.getXmlElement(false);
            if (element != null) {
                this.validateEdit();
                element.remove();
            }
        }
        IModelParticle parent = this.getParent();
        if (parent != null) {
            if (parent instanceof ModelElementList) {
                ((ModelElementList)parent).handleElementRemovedEvent();
            } else {
                ((IModelElement)parent).refresh(this.getParentProperty());
            }
        }
    }
}

