/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.def.internal;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.ui.def.IDefinitionReference;
import org.eclipse.sapphire.ui.def.IImportDirective;
import org.eclipse.sapphire.ui.def.IMasterDetailsTreeNodeDef;
import org.eclipse.sapphire.ui.def.IMasterDetailsTreeNodeFactoryDef;
import org.eclipse.sapphire.ui.def.ISapphireCompositeDef;
import org.eclipse.sapphire.ui.def.ISapphireDialogDef;
import org.eclipse.sapphire.ui.def.ISapphireUiDef;
import org.eclipse.sapphire.ui.def.ISapphireWizardDef;
import org.eclipse.sapphire.ui.def.SapphireUiDefFactory;
import org.eclipse.sapphire.ui.def.internal.ImportDirectiveMethods;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SapphireUiDefMethods {
    public static List<ISapphireUiDef> getImportedDefinitions(ISapphireUiDef def) {
        ArrayList<ISapphireUiDef> result = new ArrayList<ISapphireUiDef>();
        for (IImportDirective importDirective : def.getImportDirectives()) {
            String bundleId = importDirective.getBundle().getText();
            if (bundleId == null) continue;
            for (IDefinitionReference ref : importDirective.getDefinitions()) {
                ISapphireUiDef referencedDefinition;
                String path = ref.getPath().getText();
                if (path == null || (referencedDefinition = SapphireUiDefFactory.load(bundleId, path)) == null) continue;
                result.add(referencedDefinition);
            }
        }
        return result;
    }

    public static ISapphireCompositeDef getCompositeDef(ISapphireUiDef rootdef, String id, boolean searchImportedDefinitions) {
        if (id != null) {
            for (ISapphireCompositeDef def : rootdef.getCompositeDefs()) {
                if (!id.equals(def.getId().getText())) continue;
                return def;
            }
            if (searchImportedDefinitions) {
                for (ISapphireUiDef importedDefinition : rootdef.getImportedDefinitions()) {
                    ISapphireCompositeDef def = importedDefinition.getCompositeDef(id, true);
                    if (def == null) continue;
                    return def;
                }
            }
        }
        return null;
    }

    public static ISapphireDialogDef getDialogDef(ISapphireUiDef rootdef, String id, boolean searchImportedDefinitions) {
        if (id != null) {
            for (ISapphireDialogDef def : rootdef.getDialogDefs()) {
                if (!id.equals(def.getId().getText())) continue;
                return def;
            }
            if (searchImportedDefinitions) {
                for (ISapphireUiDef importedDefinition : rootdef.getImportedDefinitions()) {
                    ISapphireDialogDef def = importedDefinition.getDialogDef(id, true);
                    if (def == null) continue;
                    return def;
                }
            }
        }
        return null;
    }

    public static ISapphireWizardDef getWizardDef(ISapphireUiDef rootdef, String id, boolean searchImportedDefinitions) {
        if (id != null) {
            for (ISapphireWizardDef def : rootdef.getWizardDefs()) {
                if (!id.equals(def.getId().getText())) continue;
                return def;
            }
            if (searchImportedDefinitions) {
                for (ISapphireUiDef importedDefinition : rootdef.getImportedDefinitions()) {
                    ISapphireWizardDef def = importedDefinition.getWizardDef(id, true);
                    if (def == null) continue;
                    return def;
                }
            }
        }
        return null;
    }

    public static IMasterDetailsTreeNodeDef getMasterDetailsTreeNodeDef(ISapphireUiDef rootdef, String id, boolean searchImportedDefinitions) {
        if (id != null) {
            for (IMasterDetailsTreeNodeDef def : rootdef.getMasterDetailsTreeNodeDefs()) {
                if (!id.equals(def.getId().getText())) continue;
                return def;
            }
            if (searchImportedDefinitions) {
                for (ISapphireUiDef importedDefinition : rootdef.getImportedDefinitions()) {
                    IMasterDetailsTreeNodeDef def = importedDefinition.getMasterDetailsTreeNodeDef(id, true);
                    if (def == null) continue;
                    return def;
                }
            }
        }
        return null;
    }

    public static IMasterDetailsTreeNodeFactoryDef getMasterDetailsTreeNodeFactoryDef(ISapphireUiDef rootdef, String id, boolean searchImportedDefinitions) {
        if (id != null) {
            for (IMasterDetailsTreeNodeFactoryDef def : rootdef.getMasterDetailsTreeNodeFactoryDefs()) {
                if (!id.equals(def.getId().getText())) continue;
                return def;
            }
            if (searchImportedDefinitions) {
                for (ISapphireUiDef importedDefinition : rootdef.getImportedDefinitions()) {
                    IMasterDetailsTreeNodeFactoryDef def = importedDefinition.getMasterDetailsTreeNodeFactoryDef(id, true);
                    if (def == null) continue;
                    return def;
                }
            }
        }
        return null;
    }

    public static Class<?> resolveClass(ISapphireUiDef def, String className) {
        Class<?> cl = ImportDirectiveMethods.resolveClass(className, "org.eclipse.sapphire.ui", "org.eclipse.sapphire.ui.actions", "org.eclipse.sapphire.ui.listeners", "org.eclipse.sapphire.ui.xml");
        if (cl == null) {
            for (IImportDirective directive : def.getImportDirectives()) {
                cl = directive.resolveClass(className);
                if (cl != null) break;
            }
        }
        return cl;
    }

    public static ModelProperty resolveProperty(ISapphireUiDef def, String qualifiedPropertyName) {
        ModelProperty property = null;
        if (qualifiedPropertyName != null) {
            int dot = qualifiedPropertyName.indexOf(46);
            String className = qualifiedPropertyName.substring(0, dot);
            String propertyName = qualifiedPropertyName.substring(dot + 1);
            Class<?> cl = def.resolveClass(className);
            if (cl == null) {
                return null;
            }
            try {
                Field field = cl.getField(propertyName);
                property = (ModelProperty)field.get(null);
            }
            catch (Throwable e) {
                System.err.println("Failed to resolve property: " + qualifiedPropertyName);
                e.printStackTrace();
                return null;
            }
        }
        return property;
    }

    public static ImageDescriptor resolveImage(ISapphireUiDef def, String imagePath) {
        ImageDescriptor img = null;
        for (IImportDirective directive : def.getImportDirectives()) {
            img = directive.resolveImage(imagePath);
            if (img != null) break;
        }
        return img;
    }
}

