/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.editor.views.masterdetails.actions;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementListener;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.editor.views.masterdetails.MasterDetailsContentNode;
import org.eclipse.sapphire.ui.editor.views.masterdetails.MasterDetailsContentTree;
import org.eclipse.sapphire.ui.editor.views.masterdetails.actions.NodeAction;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NodeMoveAction
extends NodeAction {
    private ModelElementListener listPropertyListener = null;
    private MasterDetailsContentTree contentTree = null;
    private MasterDetailsContentTree.Listener contentTreeListener = null;

    @Override
    public boolean isEnabled() {
        return this.contentTree != null && this.contentTree.getFilterText().length() == 0;
    }

    @Override
    public void setPart(ISapphirePart part) {
        super.setPart(part);
        this.contentTree = this.getNode().getContentTree();
        this.contentTreeListener = new MasterDetailsContentTree.Listener(){

            public void handleFilterChange(String newFilterText) {
                NodeMoveAction.this.notifyChangeListeners();
            }
        };
        this.contentTree.addListener(this.contentTreeListener);
        final Runnable op = new Runnable(){

            public void run() {
                NodeMoveAction.this.notifyChangeListeners();
            }
        };
        final ListProperty property = this.getList().getParentProperty();
        this.listPropertyListener = new ModelElementListener(){

            public void propertyChanged(ModelPropertyChangeEvent event) {
                if (event.getProperty() == property) {
                    Display.getDefault().asyncExec(op);
                }
            }
        };
        this.getNode().getParentNode().getModelElement().addListener(this.listPropertyListener);
    }

    protected final ModelElementList<?> getList() {
        MasterDetailsContentNode node = this.getNode();
        IModelElement modelElement = node.getModelElement();
        return (ModelElementList)modelElement.getParent();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.getNode().getModelElement().removeListener(this.listPropertyListener);
        if (this.contentTree != null) {
            this.contentTree.removeListener(this.contentTreeListener);
        }
    }
}

