/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.internal;

import java.util.List;
import org.eclipse.sapphire.ui.actions.Action;
import org.eclipse.sapphire.ui.actions.ActionGroup;
import org.eclipse.sapphire.ui.def.IActionDef;
import org.eclipse.sapphire.ui.def.IActionGroupDef;
import org.eclipse.sapphire.ui.def.IActionOverride;
import org.eclipse.sapphire.ui.def.IActionSetDef;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ActionsHostUtil {
    public static void initActions(List<ActionGroup> actions, IActionSetDef actionSetDef) {
        if (actionSetDef != null) {
            if (((Boolean)actionSetDef.getSuppressDefaultActions().getContent()).booleanValue()) {
                actions.clear();
            } else {
                for (IActionOverride override : actionSetDef.getOverrides()) {
                    Action overridingAction = ActionsHostUtil.createAction(override.getAction());
                    if (overridingAction == null) continue;
                    for (ActionGroup adg : actions) {
                        for (Action ad : adg.getActions()) {
                            if (!ad.getId().equals(override.getId().getText())) continue;
                            adg.replaceAction(ad, overridingAction);
                        }
                    }
                }
            }
            for (IActionGroupDef agd : actionSetDef.getGroups()) {
                ActionGroup ag = new ActionGroup();
                actions.add(ag);
                for (IActionDef ad : agd.getActionDefs()) {
                    Action a = ActionsHostUtil.createAction(ad);
                    if (a == null) continue;
                    ag.addAction(a);
                }
            }
        }
    }

    private static Action createAction(IActionDef def) {
        try {
            Action action = (Action)((Class)def.getImplClass().resolve()).newInstance();
            if (def.getId().getText() != null) {
                action.setId(def.getId().getText());
            }
            if (def.getLabel().getText() != null) {
                action.setLabel(def.getLabel().getText());
            }
            return action;
        }
        catch (Exception e) {
            SapphireUiFrameworkPlugin.log(e);
            return null;
        }
    }
}

