/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.internal.binding;

import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.internal.binding.AbstractBinding;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEnumBinding
extends AbstractBinding {
    protected Enum<?>[] enumValues;

    public AbstractEnumBinding(IModelElement modelElement, ValueProperty property, SapphireRenderingContext context, Control control) {
        super(modelElement, (ModelProperty)property, context, control);
    }

    @Override
    protected void initialize(IModelElement modelElement, ModelProperty property, SapphireRenderingContext context, Control control) {
        super.initialize(modelElement, property, context, control);
        this.enumValues = (Enum[])this.getProperty().getTypeClass().getEnumConstants();
    }

    public ValueProperty getProperty() {
        return (ValueProperty)super.getProperty();
    }

    public Value<Enum<?>> getPropertyValue() {
        return (Value)super.getPropertyValue();
    }

    @Override
    protected final void doUpdateModel() {
        int index = this.getSelectionIndex();
        if (index >= 0 && index < this.enumValues.length) {
            Enum<?> newValue = this.enumValues[index];
            this.getModelElement().service().write(this.getProperty(), newValue);
            this.removeMalformedItem();
        }
    }

    @Override
    protected final void doUpdateTarget() {
        int existingSelection = this.getSelectionIndex();
        Value<Enum<?>> value = this.getPropertyValue();
        int newSelection = this.enumValues.length;
        if (!value.isMalformed()) {
            Enum newValueEnum = (Enum)value.getContent(true);
            int i = 0;
            int n = this.enumValues.length;
            while (i < n) {
                if (this.enumValues[i] == newValueEnum) {
                    newSelection = i;
                    break;
                }
                ++i;
            }
        }
        if (newSelection == this.enumValues.length) {
            String newValueString = value.getText(true);
            String label = newValueString == null ? Resources.nullValueLabel : newValueString;
            this.createMalformedItem(label);
        } else {
            this.removeMalformedItem();
        }
        if (existingSelection != newSelection) {
            this.setSelectionIndex(newSelection);
        }
    }

    protected abstract int getSelectionIndex();

    protected abstract void setSelectionIndex(int var1);

    protected abstract void createMalformedItem(String var1);

    protected abstract void removeMalformedItem();

    protected static final class Resources
    extends NLS {
        public static String nullValueLabel;

        static {
            Resources.initializeMessages((String)AbstractEnumBinding.class.getName(), Resources.class);
        }

        protected Resources() {
        }
    }
}

