/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.internal.binding;

import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.EnumValueType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.internal.binding.AbstractEnumBinding;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;

public class ComboBinding
extends AbstractEnumBinding {
    private Combo combo;

    public ComboBinding(IModelElement modelElement, ValueProperty property, SapphireRenderingContext context, Combo combo) {
        super(modelElement, property, context, (Control)combo);
    }

    protected void initialize(IModelElement modelElement, ModelProperty property, SapphireRenderingContext context, Control control) {
        super.initialize(modelElement, property, context, control);
        this.combo = (Combo)control;
        EnumValueType enumValueType = new EnumValueType(this.enumValues[0].getDeclaringClass());
        Enum[] enumArray = this.enumValues;
        int n = this.enumValues.length;
        int n2 = 0;
        while (n2 < n) {
            Enum enumItem = enumArray[n2];
            String enumItemLabel = enumValueType.getLabel(enumItem, false, CapitalizationType.FIRST_WORD_ONLY, false);
            this.combo.add(enumItemLabel);
            ++n2;
        }
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ComboBinding.this.updateModel();
                ComboBinding.this.updateTargetAttributes();
            }
        });
    }

    protected int getSelectionIndex() {
        return this.combo.getSelectionIndex();
    }

    protected void setSelectionIndex(int selection) {
        this.combo.select(selection);
    }

    protected void createMalformedItem(String label) {
        if (this.combo.getItemCount() > this.enumValues.length) {
            this.combo.setItem(this.enumValues.length, label);
        } else {
            this.combo.add(label);
        }
    }

    protected void removeMalformedItem() {
        if (this.combo.getItemCount() > this.enumValues.length) {
            this.combo.remove(this.enumValues.length);
        }
    }
}

