/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.renderers.swt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.EditFailedException;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.LongString;
import org.eclipse.sapphire.modeling.annotations.SensitiveData;
import org.eclipse.sapphire.ui.SapphireCommands;
import org.eclipse.sapphire.ui.SapphireImageCache;
import org.eclipse.sapphire.ui.SapphirePropertyEditor;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.assist.JumpHandler;
import org.eclipse.sapphire.ui.assist.internal.PropertyEditorAssistDecorator;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.ui.internal.binding.TextFieldBinding;
import org.eclipse.sapphire.ui.listeners.ValuePropertyEditorListener;
import org.eclipse.sapphire.ui.renderers.swt.BrowseCommandHandler;
import org.eclipse.sapphire.ui.renderers.swt.PropertyEditorRenderer;
import org.eclipse.sapphire.ui.renderers.swt.PropertyEditorRendererFactory;
import org.eclipse.sapphire.ui.renderers.swt.ValuePropertyEditorRenderer;
import org.eclipse.sapphire.ui.util.SwtUtil;
import org.eclipse.sapphire.ui.util.TextOverlayPainter;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class DefaultValuePropertyEditorRenderer
extends ValuePropertyEditorRenderer {
    private Text textField;

    public DefaultValuePropertyEditorRenderer(SapphireRenderingContext context, SapphirePropertyEditor part) {
        super(context, part);
    }

    protected void createContents(Composite parent) {
        this.createContents(parent, false);
    }

    protected Control createContents(Composite parent, boolean suppressBrowseAction) {
        final SapphirePropertyEditor part = this.getPart();
        final IModelElement element = part.getModelElement();
        final ValueProperty property = (ValueProperty)part.getProperty();
        boolean isLongString = property.hasAnnotation(LongString.class);
        boolean isDeprecated = property.hasAnnotation(Deprecated.class);
        boolean isReadOnly = property.isReadOnly() || part.getRenderingHint("read.only", false);
        boolean isSensitiveData = property.hasAnnotation(SensitiveData.class);
        List<Object> browseHandlers = !isReadOnly && !suppressBrowseAction ? part.createBrowseHandlers() : Collections.emptyList();
        final JumpHandler jumpHandler = part.createJumpHandler();
        boolean needsBrowseButton = !browseHandlers.isEmpty();
        boolean isBrowseOnly = part.getRenderingHint("browse.only", false) && needsBrowseButton;
        boolean showLabelAbove = part.getRenderingHint("show.label.above", false);
        boolean showLabelInline = part.getRenderingHint("show.label", !showLabelAbove);
        Label label = null;
        int baseIndent = part.getLeftMarginHint() + 9;
        if (showLabelInline || showLabelAbove) {
            label = new Label(parent, 0);
            label.setText(String.valueOf(property.getLabel(false, CapitalizationType.FIRST_WORD_ONLY, true)) + ":");
            label.setLayoutData((Object)SwtUtil.gdhindent(SwtUtil.hspan(SwtUtil.valign(SwtUtil.gd(), isLongString ? 128 : 0x1000000), showLabelAbove ? 2 : 1), baseIndent));
            this.context.adapt((Control)label);
        }
        this.setSpanBothColumns(!showLabelInline);
        Composite textFieldParent = this.createMainComposite(parent);
        this.context.adapt((Control)textFieldParent);
        int textFieldParentColumns = 1;
        if (needsBrowseButton) {
            ++textFieldParentColumns;
        }
        if (isDeprecated) {
            ++textFieldParentColumns;
        }
        textFieldParent.setLayout((Layout)SwtUtil.glayout(textFieldParentColumns, 0, 0, 0, 0));
        Composite nestedComposite = new Composite(textFieldParent, 0);
        nestedComposite.setLayoutData((Object)(isLongString ? SwtUtil.gdfill() : SwtUtil.valign(SwtUtil.gdhfill(), 0x1000000)));
        nestedComposite.setLayout((Layout)SwtUtil.glspacing(SwtUtil.glayout(2, 0, 0), 2));
        this.context.adapt((Control)nestedComposite);
        PropertyEditorAssistDecorator decorator = new PropertyEditorAssistDecorator(part, this.context, nestedComposite);
        decorator.getControl().setLayoutData((Object)SwtUtil.valign(SwtUtil.gd(), 128));
        decorator.addEditorControl((Control)nestedComposite);
        int style = (part.getRenderingHint("border", !isReadOnly) ? 2048 : 0) | (isLongString ? 578 : 0) | (isReadOnly || isBrowseOnly ? 8 : 0) | (isSensitiveData ? 0x400000 : 0);
        this.textField = new Text(nestedComposite, style);
        this.textField.setLayoutData((Object)SwtUtil.gdfill());
        this.textField.setData("assist-decorator", (Object)decorator);
        this.context.adapt((Control)this.textField);
        decorator.addEditorControl((Control)this.textField);
        TextOverlayPainter.Controller textOverlayPainterController = jumpHandler != null ? new TextOverlayPainter.Controller(){

            public boolean isHyperlinkEnabled() {
                return jumpHandler.canLocateJumpTarget(part, DefaultValuePropertyEditorRenderer.this.context, DefaultValuePropertyEditorRenderer.this.getModelElement(), property);
            }

            public void handleHyperlinkEvent() {
                jumpHandler.jump(part, DefaultValuePropertyEditorRenderer.this.context, DefaultValuePropertyEditorRenderer.this.getModelElement(), property);
            }

            public String getDefaultText() {
                Value value = (Value)DefaultValuePropertyEditorRenderer.this.getProperty().invokeGetterMethod((Object)DefaultValuePropertyEditorRenderer.this.getModelElement());
                return value.getDefaultText();
            }
        } : new TextOverlayPainter.Controller(){

            public String getDefaultText() {
                Value value = (Value)DefaultValuePropertyEditorRenderer.this.getProperty().invokeGetterMethod((Object)DefaultValuePropertyEditorRenderer.this.getModelElement());
                return value.getDefaultText();
            }
        };
        TextOverlayPainter.install(this.textField, textOverlayPainterController);
        SapphireCommands.configurePropertyEditorContext((Control)this.textField);
        if (isBrowseOnly) {
            final Color bgcolor = new Color((Device)this.textField.getDisplay(), 235, 235, 235);
            this.textField.setBackground(bgcolor);
            this.textField.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    bgcolor.dispose();
                }
            });
        }
        ArrayList<Object> relatedControls = new ArrayList<Object>();
        this.textField.setData("related-controls", relatedControls);
        relatedControls.add(label);
        if (needsBrowseButton) {
            ToolBar toolBar = new ToolBar(textFieldParent, 0x800000);
            toolBar.setLayoutData((Object)SwtUtil.gdvfill());
            this.context.adapt((Control)toolBar);
            decorator.addEditorControl((Control)toolBar);
            SapphireCommands.configurePropertyEditorContext((Control)toolBar);
            relatedControls.add(toolBar);
            final ToolItem browseButton = new ToolItem(toolBar, 8);
            browseButton.setImage(this.getImageCache().getImage(SapphireImageCache.ACTION_BROWSE));
            browseButton.setToolTipText(Resources.browseButtonToolTip);
            final BrowseCommandHandler browseCommandHandler = new BrowseCommandHandler(this.context, browseHandlers){

                protected Rectangle getInvokerBounds() {
                    Rectangle bounds = browseButton.getBounds();
                    Point convertedCoordinates = browseButton.getParent().toDisplay(bounds.x, bounds.y);
                    bounds.x = convertedCoordinates.x;
                    bounds.y = convertedCoordinates.y;
                    return bounds;
                }

                protected void handleBrowseCompleted(String text) {
                    block3: {
                        try {
                            property.invokeSetterMethod((Object)element, (Object)text);
                        }
                        catch (Exception e) {
                            EditFailedException editFailedException = EditFailedException.findAsCause((Throwable)e);
                            if (editFailedException != null) break block3;
                            SapphireUiFrameworkPlugin.log(e);
                        }
                    }
                    if (!DefaultValuePropertyEditorRenderer.this.textField.isDisposed()) {
                        DefaultValuePropertyEditorRenderer.this.textField.setFocus();
                        DefaultValuePropertyEditorRenderer.this.textField.setSelection(0, DefaultValuePropertyEditorRenderer.this.textField.getText().length());
                    }
                }
            };
            browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    browseCommandHandler.execute(null);
                }
            });
            SapphireCommands.attachBrowseHandler((Control)this.textField, (IHandler)browseCommandHandler);
            toolBar.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent event) {
                    event.result = Resources.browseButtonToolTip;
                }
            });
        }
        if (isDeprecated) {
            Text deprecatedLabel = new Text(textFieldParent, 8);
            deprecatedLabel.setLayoutData((Object)SwtUtil.gd());
            deprecatedLabel.setText(Resources.deprecatedLabelText);
            this.context.adapt((Control)deprecatedLabel);
            deprecatedLabel.setForeground(parent.getDisplay().getSystemColor(16));
        }
        this.binding = new TextFieldBinding(this.getModelElement(), property, this.context, this.textField);
        this.textField.setData("binding", (Object)this.binding);
        this.addControl((Control)this.textField);
        List listenerClasses = part.getRenderingHint("listeners", Collections.emptyList());
        if (!listenerClasses.isEmpty()) {
            final ArrayList<ValuePropertyEditorListener> listeners = new ArrayList<ValuePropertyEditorListener>();
            for (Class cl : listenerClasses) {
                try {
                    ValuePropertyEditorListener listener = (ValuePropertyEditorListener)cl.newInstance();
                    listener.initialize(this.context, this.getModelElement(), (ModelProperty)property);
                    listeners.add(listener);
                }
                catch (Exception e) {
                    SapphireUiFrameworkPlugin.log(e);
                }
            }
            if (!listeners.isEmpty()) {
                this.textField.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent event) {
                        for (ValuePropertyEditorListener listener : listeners) {
                            try {
                                listener.handleValueChanged();
                            }
                            catch (Exception e) {
                                SapphireUiFrameworkPlugin.log(e);
                            }
                        }
                    }
                });
            }
        }
        return this.textField;
    }

    protected boolean canExpandVertically() {
        return this.getProperty().hasAnnotation(LongString.class);
    }

    protected void handleFocusReceivedEvent() {
        this.textField.setFocus();
    }

    public static final class Factory
    extends PropertyEditorRendererFactory {
        public boolean isApplicableTo(SapphirePropertyEditor propertyEditorDefinition) {
            return propertyEditorDefinition.getProperty() instanceof ValueProperty;
        }

        public PropertyEditorRenderer create(SapphireRenderingContext context, SapphirePropertyEditor part) {
            return new DefaultValuePropertyEditorRenderer(context, part);
        }
    }

    private static final class Resources
    extends NLS {
        public static String deprecatedLabelText;
        public static String browseButtonToolTip;

        static {
            Resources.initializeMessages((String)DefaultValuePropertyEditorRenderer.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

