/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.renderers.swt;

import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.ui.SapphirePropertyEditor;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.assist.internal.PropertyEditorAssistDecorator;
import org.eclipse.sapphire.ui.renderers.swt.PropertyEditorRenderer;
import org.eclipse.sapphire.ui.renderers.swt.PropertyEditorRendererFactory;
import org.eclipse.sapphire.ui.renderers.swt.ValuePropertyEditorRenderer;
import org.eclipse.sapphire.ui.util.SwtUtil;
import org.eclipse.sapphire.ui.util.TextOverlayPainter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Text;

public final class ScalePropertyEditorRenderer
extends ValuePropertyEditorRenderer {
    private int minimum;
    private int maximum;
    private int offset;
    private Scale scale;
    private Text textField;

    public ScalePropertyEditorRenderer(SapphireRenderingContext context, SapphirePropertyEditor part) {
        super(context, part);
    }

    protected void createContents(Composite parent) {
        SapphirePropertyEditor part = this.getPart();
        ValueProperty property = (ValueProperty)part.getProperty();
        boolean showLabel = part.getRenderingHint("show.label", true);
        int baseIndent = part.getLeftMarginHint();
        NumericRange rangeAnnotation = (NumericRange)property.getAnnotation(NumericRange.class);
        try {
            this.minimum = Integer.parseInt(rangeAnnotation.min());
            this.maximum = Integer.parseInt(rangeAnnotation.max());
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(e);
        }
        if (this.minimum < 0) {
            this.offset = this.minimum * -1;
            this.minimum += this.offset;
            this.maximum += this.offset;
        } else {
            this.offset = 0;
        }
        if (showLabel) {
            String labelText = property.getLabel(false, CapitalizationType.FIRST_WORD_ONLY, true);
            Label label = new Label(parent, 0);
            label.setLayoutData((Object)SwtUtil.gdhindent(SwtUtil.gd(), baseIndent + 9));
            label.setText(String.valueOf(labelText) + ":");
            this.context.adapt((Control)label);
            this.addControl((Control)label);
        }
        this.setSpanBothColumns(!showLabel);
        Composite composite = this.createMainComposite(parent);
        composite.setLayout((Layout)SwtUtil.glspacing(SwtUtil.glayout(2, 0, 0), 2));
        Composite textFieldComposite = new Composite(composite, 0);
        textFieldComposite.setLayoutData((Object)SwtUtil.gdwhint(SwtUtil.gd(), 60));
        textFieldComposite.setLayout((Layout)SwtUtil.glspacing(SwtUtil.glayout(2, 0, 0), 2));
        PropertyEditorAssistDecorator decorator = this.createDecorator(textFieldComposite);
        decorator.getControl().setLayoutData((Object)SwtUtil.valign(SwtUtil.gd(), 128));
        this.textField = new Text(textFieldComposite, 2048);
        this.textField.setLayoutData((Object)SwtUtil.gdhfill());
        this.textField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ScalePropertyEditorRenderer.this.setPropertyValue(ScalePropertyEditorRenderer.this.textField.getText());
            }
        });
        TextOverlayPainter.Controller textOverlayPainterController = new TextOverlayPainter.Controller(){

            public String getDefaultText() {
                return ScalePropertyEditorRenderer.this.getPropertyValue().getDefaultText();
            }
        };
        TextOverlayPainter.install(this.textField, textOverlayPainterController);
        this.scale = new Scale(composite, 256);
        this.scale.setLayoutData((Object)SwtUtil.gdhfill());
        this.scale.setMinimum(this.minimum);
        this.scale.setMaximum(this.maximum);
        this.scale.setIncrement(1);
        this.scale.setPageIncrement(1);
        this.scale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int value = ScalePropertyEditorRenderer.this.scale.getSelection() - ScalePropertyEditorRenderer.this.offset;
                ScalePropertyEditorRenderer.this.setPropertyValue(String.valueOf(value));
            }
        });
        decorator.addEditorControl((Control)composite);
        this.addControl((Control)this.textField);
        this.addControl((Control)this.scale);
    }

    protected void handlePropertyChangedEvent() {
        Integer newValueInteger;
        int newValueForScale;
        super.handlePropertyChangedEvent();
        Value value = this.getPropertyValue();
        String existingValueInTextField = this.textField.getText();
        String newValueForTextField = value.getText(false);
        if (!existingValueInTextField.equals(newValueForTextField)) {
            this.textField.setText(newValueForTextField == null ? "" : newValueForTextField);
        }
        int n = newValueForScale = (newValueInteger = (Integer)value.getContent(true)) == null ? this.scale.getMinimum() : newValueInteger + this.offset;
        if (newValueForScale < this.minimum) {
            newValueForScale = this.minimum;
        } else if (newValueForScale > this.maximum) {
            newValueForScale = this.maximum;
        }
        if (this.scale.getSelection() != newValueForScale) {
            this.scale.setSelection(newValueForScale);
        }
    }

    protected void handleFocusReceivedEvent() {
        this.scale.setFocus();
    }

    public static final class Factory
    extends PropertyEditorRendererFactory {
        public boolean isApplicableTo(SapphirePropertyEditor propertyEditorDefinition) {
            NumericRange rangeAnnotation;
            ModelProperty property = propertyEditorDefinition.getProperty();
            if (property.isOfType(Integer.class) && (rangeAnnotation = (NumericRange)property.getAnnotation(NumericRange.class)) != null) {
                String minStr = rangeAnnotation.min();
                String maxStr = rangeAnnotation.max();
                if (minStr.length() > 0 && maxStr.length() > 0) {
                    return true;
                }
            }
            return false;
        }

        public PropertyEditorRenderer create(SapphireRenderingContext context, SapphirePropertyEditor part) {
            return new ScalePropertyEditorRenderer(context, part);
        }
    }
}

