/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt;

import java.util.Collections;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.ui.SapphireDialogPart;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ISapphireDialogDef;
import org.eclipse.sapphire.ui.def.SapphireUiDefFactory;
import org.eclipse.sapphire.ui.util.SwtUtil;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SapphireDialog
extends Dialog {
    private final SapphireDialogPart part;
    private final boolean preferFormStyle;

    public SapphireDialog(Shell shell, IModelElement modelElement, String dialogDefPath) {
        this(shell, modelElement, SapphireUiDefFactory.getDialogDef(dialogDefPath));
    }

    public SapphireDialog(Shell shell, IModelElement modelElement, ISapphireDialogDef definition) {
        this(shell, (SapphireDialogPart)SapphirePart.create(null, modelElement, definition, Collections.<String, String>emptyMap()));
    }

    public SapphireDialog(Shell shell, SapphireDialogPart part) {
        super(shell);
        this.part = part;
        this.preferFormStyle = part.getPreferFormStyle();
    }

    public final IModelElement getModelElement() {
        return this.part.getModelElement();
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.part.getLabel());
        Composite composite = (Composite)super.createDialogArea(parent);
        if (this.preferFormStyle) {
            composite.setBackground(Display.getCurrent().getSystemColor(1));
        }
        Composite innerComposite = new Composite(composite, 0);
        innerComposite.setLayout((Layout)SwtUtil.glayout(2, 0, 0));
        innerComposite.setLayoutData((Object)SwtUtil.gdfill());
        SapphireRenderingContext context = new SapphireRenderingContext(this.part, innerComposite);
        this.part.render(context);
        String initialFocusProperty = (String)this.part.getDefinition().getInitialFocus().getContent();
        if (initialFocusProperty != null) {
            this.part.setFocus(initialFocusProperty);
        }
        return composite;
    }

    protected Control createContents(Composite parent) {
        Composite composite = (Composite)super.createContents(parent);
        if (this.preferFormStyle) {
            composite.setBackground(Display.getCurrent().getSystemColor(1));
        }
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = (Composite)super.createButtonBar(parent);
        if (this.preferFormStyle) {
            composite.setBackground(Display.getCurrent().getSystemColor(1));
        }
        return composite;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        if (this.preferFormStyle) {
            button.setBackground(Display.getCurrent().getSystemColor(1));
        }
        return button;
    }

    protected boolean isResizable() {
        return true;
    }
}

