/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModel;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementDisposedEvent;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementListener;
import org.eclipse.sapphire.modeling.ModelElementService;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelParticle;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.ModelPropertyListener;
import org.eclipse.sapphire.modeling.SapphireMultiStatus;
import org.eclipse.sapphire.modeling.StandardModelElementService;
import org.eclipse.sapphire.modeling.ValidationStateChangeEvent;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.PossibleValuesChangedEvent;
import org.eclipse.sapphire.modeling.annotations.PossibleValuesProviderImpl;
import org.eclipse.sapphire.modeling.annotations.PossibleValuesProviderListener;
import org.eclipse.sapphire.modeling.extensibility.ServicesExtensionPoint;
import org.eclipse.sapphire.modeling.internal.SapphireModelingFrameworkPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelElement
extends ModelParticle
implements IModelElement {
    private final ModelElementType type;
    private final ModelProperty parentProperty;
    private IStatus valres;
    private Set<ModelElementListener> listeners;
    private Map<ModelProperty, Set<ModelPropertyListener>> propertyListeners;
    private final Map<ModelProperty, Boolean> enablementStatuses;
    private final Map<Class<? extends ModelElementService>, ModelElementService> services;

    public ModelElement(ModelElementType type, IModelParticle parent, ModelProperty parentProperty) {
        super(parent);
        this.type = type;
        this.parentProperty = parentProperty;
        this.valres = null;
        this.listeners = null;
        this.propertyListeners = null;
        this.enablementStatuses = new HashMap<ModelProperty, Boolean>();
        this.services = new HashMap<Class<? extends ModelElementService>, ModelElementService>();
        final HashMap<ModelProperty, 1> refreshListeners = new HashMap<ModelProperty, 1>();
        for (final ModelProperty property : type.getProperties()) {
            PossibleValuesProviderImpl possibleValuesProvider;
            Set<ModelPath> dependencies = property.getDependencies();
            if (!dependencies.isEmpty()) {
                ModelPropertyListener listener = new ModelPropertyListener(){

                    public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
                        ModelElement.this.refresh(property);
                    }
                };
                refreshListeners.put(property, listener);
                for (ModelPath depPath : dependencies) {
                    this.addListener(listener, depPath);
                }
            }
            if (!(property instanceof ValueProperty) || (possibleValuesProvider = this.service().getPossibleValuesProvider((ValueProperty)property)) == null) continue;
            possibleValuesProvider.addListener(new PossibleValuesProviderListener(){

                public void handlePossibleValuesChangedEvent(PossibleValuesChangedEvent event) {
                    ModelElement.this.refresh(property);
                }
            });
        }
        if (!refreshListeners.isEmpty()) {
            ModelElementListener disposeListener = new ModelElementListener(){

                public void handleElementDisposedEvent(ModelElementDisposedEvent event) {
                    for (Map.Entry entry : refreshListeners.entrySet()) {
                        ModelProperty property = (ModelProperty)entry.getKey();
                        ModelPropertyListener listener = (ModelPropertyListener)entry.getValue();
                        for (ModelPath depPath : property.getDependencies()) {
                            ModelElement.this.removeListener(listener, depPath);
                        }
                    }
                }
            };
            this.addListener(disposeListener);
        }
    }

    @Override
    public ModelElementType getModelElementType() {
        return this.type;
    }

    @Override
    public ModelProperty getParentProperty() {
        return this.parentProperty;
    }

    @Override
    public final void refresh() {
        this.refresh(false, false);
    }

    @Override
    public final void refresh(boolean force) {
        this.refresh(force, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void refresh(boolean force, boolean deep) {
        IModel iModel = this.model;
        synchronized (iModel) {
            for (ModelProperty property : this.getModelElementType().getProperties()) {
                this.refresh(property, force, deep);
            }
        }
    }

    @Override
    public final void refresh(ModelProperty property) {
        this.refresh(property, false, false);
    }

    @Override
    public final void refresh(ModelProperty property, boolean force) {
        this.refresh(property, force, false);
    }

    @Override
    public final void refresh(ModelProperty property, boolean force, boolean deep) {
        this.refreshProperty(property, force);
        if (deep) {
            if (property instanceof ElementProperty) {
                IModelElement child = this.service().read((ElementProperty)property);
                if (child != null) {
                    child.refresh(force, true);
                }
            } else if (property instanceof ListProperty) {
                for (IModelElement child : this.service().read((ListProperty)property)) {
                    child.refresh(force, true);
                }
            }
        }
    }

    protected void refreshProperty(ModelProperty property, boolean force) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <S extends ModelElementService> S service(Class<S> serviceType) {
        IModel iModel = this.model;
        synchronized (iModel) {
            ModelElementService service = this.services.get(serviceType);
            if (service == null && (service = ServicesExtensionPoint.getService(serviceType)) != null) {
                service.init(this);
                this.services.put(serviceType, service);
            }
            return (S)service;
        }
    }

    @Override
    public final StandardModelElementService service() {
        return this.service(StandardModelElementService.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isPropertyEnabled(ModelProperty property) {
        IModel iModel = this.model;
        synchronized (iModel) {
            Boolean status = this.enablementStatuses.get(property);
            if (status == null) {
                this.refreshPropertyEnabledStatus(property);
                status = this.enablementStatuses.get(property);
            }
            return status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean refreshPropertyEnabledStatus(ModelProperty property) {
        IModel iModel = this.model;
        synchronized (iModel) {
            Boolean oldStatus = this.enablementStatuses.get(property);
            boolean newStatus = this.service().isEnabled(property);
            this.enablementStatuses.put(property, newStatus);
            return oldStatus != null && !oldStatus.equals(newStatus);
        }
    }

    @Override
    public IStatus validate() {
        if (this.valres == null) {
            this.refreshValidationResult();
        }
        return this.valres;
    }

    private void refreshValidationResult() {
        SapphireMultiStatus st = new SapphireMultiStatus();
        for (ModelProperty property : this.type.getProperties()) {
            if (!this.service().isEnabled(property)) continue;
            Object val = property.invokeGetterMethod(this);
            IStatus x = null;
            if (property instanceof ValueProperty) {
                x = ((Value)val).validate();
            } else if (property instanceof ListProperty) {
                if (val != null) {
                    x = ((ModelElementList)val).validate();
                }
            } else if (property instanceof ElementProperty) {
                if (val != null) {
                    x = ((IModelElement)val).validate();
                }
            } else {
                throw new IllegalStateException();
            }
            if (x == null) continue;
            st.add(x);
        }
        if (this.valres == null) {
            this.valres = st;
        } else if (!this.valres.equals((Object)st)) {
            IStatus oldValidationState = this.valres;
            this.valres = st;
            this.notifyValidationStateChangeListeners(oldValidationState, this.valres);
            IModelParticle parent = this.getParent();
            if (parent != null && parent instanceof IModelElement) {
                ((IModelElement)parent).notifyPropertyChangeListeners(this.parentProperty);
            }
        }
    }

    protected void validateEdit() {
        this.model.validateEdit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addListener(ModelElementListener listener) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.listeners == null) {
                this.listeners = new CopyOnWriteArraySet<ModelElementListener>();
            }
            this.listeners.add(listener);
        }
    }

    @Override
    public final void addListener(ModelPropertyListener listener, String path) {
        this.addListener(listener, new ModelPath(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addListener(ModelPropertyListener listener, ModelPath path) {
        IModel iModel = this.model;
        synchronized (iModel) {
            ModelPath.Segment head = path.head();
            if (head instanceof ModelPath.ModelRootSegment) {
                this.getModel().addListener(listener, path.tail());
            } else if (head instanceof ModelPath.ParentElementSegment) {
                IModelParticle parent = this.getParent();
                if (parent == null) {
                    this.logInvalidModelPathMessage(path);
                    return;
                }
                if (parent instanceof ModelElementList) {
                    parent = parent.getParent();
                }
                ((IModelElement)parent).addListener(listener, path.tail());
            } else if (head instanceof ModelPath.AllSiblingsSegment) {
                IModelParticle parent = this.getParent();
                if (parent == null || !(parent instanceof ModelElementList)) {
                    this.logInvalidModelPathMessage(path);
                    return;
                }
                parent = parent.getParent();
                ModelPath p = new ModelPath(this.parentProperty.getName()).append(path.tail());
                ((IModelElement)parent).addListener(listener, p);
            } else if (head instanceof ModelPath.AllDescendentsSegment) {
                for (ModelProperty property : this.type.getProperties()) {
                    PropagationListener pListener;
                    Set<ModelPropertyListener> listeners = this.getListenersForEdit(property);
                    listeners.add(listener);
                    if (property instanceof ValueProperty || !listeners.add(pListener = new PropagationListener(property, path, listener))) continue;
                    pListener.handlePropertyChangedEvent(null);
                }
            } else if (head instanceof ModelPath.TypeFilterSegment) {
                String t = this.type.getSimpleName();
                boolean match = false;
                for (String type : ((ModelPath.TypeFilterSegment)head).getTypes()) {
                    if (!type.equalsIgnoreCase(t)) continue;
                    match = true;
                    break;
                }
                if (match) {
                    this.addListener(listener, path.tail());
                }
            } else {
                String propertyName = ((ModelPath.PropertySegment)head).getPropertyName();
                ModelProperty property = this.type.getProperty(propertyName);
                if (property == null) {
                    this.logInvalidModelPathMessage(path);
                    return;
                }
                Set<ModelPropertyListener> listeners = this.getListenersForEdit(property);
                if (path.length() == 1) {
                    listeners.add(listener);
                } else {
                    if (property instanceof ValueProperty) {
                        this.logInvalidModelPathMessage(path);
                        return;
                    }
                    PropagationListener pListener = new PropagationListener(property, path.tail(), listener);
                    if (listeners.add(pListener)) {
                        pListener.handlePropertyChangedEvent(null);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeListener(ModelElementListener listener) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.listeners != null) {
                this.listeners.remove(listener);
            }
        }
    }

    @Override
    public final void removeListener(ModelPropertyListener listener, String path) {
        this.removeListener(listener, new ModelPath(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeListener(ModelPropertyListener listener, ModelPath path) {
        IModel iModel = this.model;
        synchronized (iModel) {
            ModelPath.Segment head = path.head();
            if (head instanceof ModelPath.ModelRootSegment) {
                this.getModel().removeListener(listener, path.tail());
            } else if (head instanceof ModelPath.ParentElementSegment) {
                IModelParticle parent = this.getParent();
                if (parent == null) {
                    this.logInvalidModelPathMessage(path);
                    return;
                }
                if (parent instanceof ModelElementList) {
                    parent = parent.getParent();
                }
                ((IModelElement)parent).removeListener(listener, path.tail());
            } else if (head instanceof ModelPath.AllSiblingsSegment) {
                IModelParticle parent = this.getParent();
                if (parent == null || !(parent instanceof ModelElementList)) {
                    this.logInvalidModelPathMessage(path);
                    return;
                }
                parent = parent.getParent();
                ModelPath p = new ModelPath(this.parentProperty.getName()).append(path.tail());
                ((IModelElement)parent).removeListener(listener, p);
            } else if (head instanceof ModelPath.AllDescendentsSegment) {
                for (ModelProperty property : this.type.getProperties()) {
                    Set<ModelPropertyListener> listeners = this.getListenersForEdit(property);
                    listeners.remove(listener);
                    if (property instanceof ValueProperty) continue;
                    PropagationListener pListener = new PropagationListener(property, path, listener);
                    listeners.remove(pListener);
                    Object val = property.invokeGetterMethod(this);
                    if (property instanceof ElementProperty) {
                        if (val == null) continue;
                        ((IModelElement)val).removeListener(listener, path);
                        continue;
                    }
                    if (!(property instanceof ListProperty)) continue;
                    ModelElementList list = (ModelElementList)val;
                    for (IModelElement x : list) {
                        x.removeListener(listener, path);
                    }
                }
            } else if (head instanceof ModelPath.TypeFilterSegment) {
                String t = this.type.getSimpleName();
                boolean match = false;
                for (String type : ((ModelPath.TypeFilterSegment)head).getTypes()) {
                    if (!type.equalsIgnoreCase(t)) continue;
                    match = true;
                    break;
                }
                if (match) {
                    this.removeListener(listener, path.tail());
                }
            } else {
                String propertyName = ((ModelPath.PropertySegment)head).getPropertyName();
                ModelProperty property = this.type.getProperty(propertyName);
                if (property == null) {
                    this.logInvalidModelPathMessage(path);
                    return;
                }
                Set<ModelPropertyListener> listeners = this.getListenersForEdit(property);
                if (path.length() == 1) {
                    listeners.remove(listener);
                } else {
                    PropagationListener pListener = new PropagationListener(property, path.tail(), listener);
                    listeners.remove(pListener);
                    Object val = property.invokeGetterMethod(this);
                    ModelPath tail = path.tail();
                    if (property instanceof ElementProperty) {
                        if (val != null) {
                            ((IModelElement)val).removeListener(listener, tail);
                        }
                    } else if (property instanceof ListProperty) {
                        ModelElementList list = (ModelElementList)val;
                        for (IModelElement x : list) {
                            x.removeListener(listener, tail);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void notifyPropertyChangeListeners(ModelProperty property) {
        ModelPropertyChangeEvent event = new ModelPropertyChangeEvent(this, property);
        IModel iModel = this.model;
        synchronized (iModel) {
            Set<ModelPropertyListener> set;
            if (this.valres != null) {
                this.refreshValidationResult();
            }
            if (this.listeners != null) {
                for (ModelElementListener modelElementListener : this.listeners) {
                    try {
                        modelElementListener.propertyChanged(event);
                    }
                    catch (Exception e) {
                        SapphireModelingFrameworkPlugin.log(e);
                    }
                }
            }
            if (this.propertyListeners != null && (set = this.propertyListeners.get(property)) != null) {
                for (ModelPropertyListener listener : set) {
                    try {
                        listener.handlePropertyChangedEvent(event);
                    }
                    catch (Exception e) {
                        SapphireModelingFrameworkPlugin.log(e);
                    }
                }
            }
            for (ModelPropertyListener modelPropertyListener : property.getListeners()) {
                try {
                    modelPropertyListener.handlePropertyChangedEvent(event);
                }
                catch (Exception e) {
                    SapphireModelingFrameworkPlugin.log(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyValidationStateChangeListeners(IStatus oldValidationState, IStatus newValidationState) {
        ValidationStateChangeEvent event = new ValidationStateChangeEvent(this, oldValidationState, newValidationState);
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.listeners != null) {
                for (ModelElementListener listener : this.listeners) {
                    try {
                        listener.validationStateChanged(event);
                    }
                    catch (Exception e) {
                        SapphireModelingFrameworkPlugin.log(e);
                    }
                }
            }
        }
    }

    private Set<ModelPropertyListener> getListenersForEdit(ModelProperty property) {
        Set<ModelPropertyListener> set;
        if (this.propertyListeners == null) {
            this.propertyListeners = new HashMap<ModelProperty, Set<ModelPropertyListener>>();
        }
        set = (set = this.propertyListeners.get(property)) == null ? new HashSet<ModelPropertyListener>() : new HashSet<ModelPropertyListener>(set);
        this.propertyListeners.put(property, set);
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void dispose() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.listeners != null) {
                ModelElementDisposedEvent event = new ModelElementDisposedEvent(this);
                for (ModelElementListener listener : this.listeners) {
                    try {
                        listener.handleElementDisposedEvent(event);
                    }
                    catch (Exception e) {
                        SapphireModelingFrameworkPlugin.log(e);
                    }
                }
            }
        }
    }

    private void logInvalidModelPathMessage(ModelPath path) {
        String message = NLS.bind((String)Resources.invalidModelPath, (Object)this.type.getModelElementClass().getName(), (Object)path.toString());
        SapphireModelingFrameworkPlugin.logError(message, null);
    }

    protected static final boolean equal(String value1, String value2) {
        String val1 = ModelElement.normalize(value1);
        String val2 = ModelElement.normalize(value2);
        boolean valuesAreEqual = false;
        if (val1 == val2) {
            valuesAreEqual = true;
        } else if (val1 != null && val2 != null) {
            valuesAreEqual = val1.equals(val2);
        }
        return valuesAreEqual;
    }

    protected static final String normalize(String value) {
        if (value != null && value.equals("")) {
            return null;
        }
        return value;
    }

    private final class PropagationListener
    extends ModelPropertyListener {
        private final ModelProperty property;
        private final ModelPath path;
        private final ModelPropertyListener listener;

        public PropagationListener(ModelProperty property, ModelPath path, ModelPropertyListener listener) {
            if (property instanceof ValueProperty) {
                throw new IllegalArgumentException();
            }
            this.property = property;
            this.path = path;
            this.listener = listener;
        }

        public boolean equals(Object obj) {
            if (obj instanceof PropagationListener) {
                PropagationListener pl = (PropagationListener)obj;
                return this.property == pl.property && this.path.equals(pl.path) && this.listener == pl.listener;
            }
            return false;
        }

        public int hashCode() {
            return this.property.hashCode() ^ this.path.hashCode();
        }

        public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
            Object val = this.property.invokeGetterMethod(ModelElement.this);
            if (this.property instanceof ElementProperty) {
                if (val != null) {
                    ((IModelElement)val).addListener(this.listener, this.path);
                }
            } else {
                ModelElementList list = (ModelElementList)val;
                for (IModelElement x : list) {
                    x.addListener(this.listener, this.path);
                }
            }
            this.listener.handlePropertyChangedEvent(event);
        }
    }

    private static final class Resources
    extends NLS {
        public static String invalidModelPath;

        static {
            Resources.initializeMessages((String)ModelElement.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

