/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.IRemovable;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementListController;
import org.eclipse.sapphire.modeling.ModelElementListener;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelParticle;
import org.eclipse.sapphire.modeling.SapphireMultiStatus;
import org.eclipse.sapphire.modeling.ValidationStateChangeEvent;
import org.eclipse.sapphire.modeling.annotations.ModelPropertyValidator;
import org.eclipse.sapphire.modeling.internal.SapphireModelingFrameworkPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModelElementList<T extends IModelElement>
extends ModelParticle
implements List<T>,
IModelParticle {
    private final ListProperty property;
    private ModelElementListController<T> controller;
    private List<T> data;
    private boolean copyOnNextChange;
    private boolean ignoreRefresh;
    private IStatus valres;
    private ModelElementListener listMemberListener;

    public ModelElementList(IModelElement parent, ListProperty property) {
        super(parent);
        this.property = property;
        this.data = Collections.emptyList();
        this.copyOnNextChange = true;
        this.ignoreRefresh = false;
        this.valres = null;
        this.listMemberListener = new ModelElementListener(){

            public void validationStateChanged(ValidationStateChangeEvent event) {
                ModelElementList.this.refreshValidationResult(true);
            }
        };
    }

    public final void init(ModelElementListController<T> controller) {
        this.controller = controller;
    }

    @Override
    public IModelElement getParent() {
        return (IModelElement)super.getParent();
    }

    public ListProperty getParentProperty() {
        return this.property;
    }

    @Override
    public synchronized IStatus validate() {
        if (this.valres == null) {
            this.refreshValidationResult(false);
        }
        return this.valres;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean refresh() {
        boolean changed = false;
        ModelElementList modelElementList = this;
        synchronized (modelElementList) {
            if (!this.ignoreRefresh) {
                List<IModelElement> oldListElements = Collections.unmodifiableList(this.data);
                ArrayList<IModelElement> newListElements = new ArrayList<IModelElement>(this.controller.refresh(oldListElements));
                boolean refreshNeeded = false;
                if (newListElements != oldListElements) {
                    int newListElementsSize = newListElements.size();
                    if (newListElementsSize != oldListElements.size()) {
                        refreshNeeded = true;
                    } else {
                        int i = 0;
                        while (i < newListElementsSize) {
                            if (newListElements.get(i) != oldListElements.get(i)) {
                                refreshNeeded = true;
                                break;
                            }
                            ++i;
                        }
                    }
                }
                if (refreshNeeded) {
                    for (IModelElement modelElement : oldListElements) {
                        boolean retained = false;
                        for (IModelElement x : newListElements) {
                            if (x != modelElement) continue;
                            retained = true;
                            break;
                        }
                        if (retained) continue;
                        try {
                            modelElement.dispose();
                        }
                        catch (Exception e) {
                            SapphireModelingFrameworkPlugin.log(e);
                        }
                    }
                    this.data = newListElements;
                    for (IModelElement modelElement : this) {
                        modelElement.addListener(this.listMemberListener);
                    }
                    this.copyOnNextChange = false;
                    changed = true;
                }
            }
        }
        if (changed) {
            this.getParent().notifyPropertyChangeListeners(this.property);
        }
        this.refreshValidationResult(true);
        return changed;
    }

    private void refreshValidationResult(boolean notifyListenersIfChanged) {
        SapphireMultiStatus st = new SapphireMultiStatus();
        ModelPropertyValidator<?> validator = this.property.getValidator();
        if (validator != null) {
            st.add(validator.validate(this));
        }
        for (IModelElement item : this) {
            st.add(item.validate());
        }
        if (this.valres == null) {
            this.valres = st;
        } else if (!this.valres.equals((Object)st)) {
            this.valres = st;
            if (notifyListenersIfChanged) {
                this.getParent().notifyPropertyChangeListeners(this.property);
            }
        }
    }

    public void handleElementRemovedEvent() {
        this.refresh();
        this.controller.handleElementRemovedEvent();
    }

    public T addNewElement() {
        return this.addNewElement(this.property.getAllPossibleTypes().get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T addNewElement(ModelElementType type) {
        T newElement;
        ModelElementList modelElementList = this;
        synchronized (modelElementList) {
            this.ignoreRefresh = true;
            try {
                newElement = this.controller.createNewElement(type);
                if (this.copyOnNextChange) {
                    this.data = new ArrayList<T>(this.data);
                    this.copyOnNextChange = false;
                }
                newElement.addListener(this.listMemberListener);
                this.data.add(newElement);
            }
            finally {
                this.ignoreRefresh = false;
            }
            if (!this.refresh()) {
                this.getParent().notifyPropertyChangeListeners(this.property);
            }
        }
        return newElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveUp(T modelElement) {
        ModelElementList modelElementList = this;
        synchronized (modelElementList) {
            int index = this.indexOf(modelElement);
            if (index == -1) {
                throw new IllegalArgumentException();
            }
            if (index > 0) {
                IModelElement previousModelElement = (IModelElement)this.data.get(index - 1);
                this.swap(modelElement, previousModelElement);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveDown(T modelElement) {
        ModelElementList modelElementList = this;
        synchronized (modelElementList) {
            int index = this.indexOf(modelElement);
            if (index == -1) {
                throw new IllegalArgumentException();
            }
            if (index < this.data.size() - 1) {
                IModelElement nextModelElement = (IModelElement)this.data.get(index + 1);
                this.swap(modelElement, nextModelElement);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void swap(T a, T b) {
        ModelElementList modelElementList = this;
        synchronized (modelElementList) {
            if (this.data.indexOf(a) == -1 || this.data.indexOf(b) == -1) {
                throw new IllegalArgumentException();
            }
            this.ignoreRefresh = true;
            try {
                this.controller.swap(a, b);
            }
            finally {
                this.ignoreRefresh = false;
            }
            this.refresh();
        }
    }

    @Override
    public void clear() {
        ArrayList entries = new ArrayList(this);
        for (IModelElement entry : entries) {
            ((IRemovable)((Object)entry)).remove();
        }
        this.refresh();
    }

    @Override
    public synchronized T get(int index) {
        return (T)((IModelElement)this.data.get(index));
    }

    @Override
    public synchronized int indexOf(Object object) {
        return this.data.indexOf(object);
    }

    @Override
    public synchronized int lastIndexOf(Object object) {
        return this.data.lastIndexOf(object);
    }

    @Override
    public synchronized boolean contains(Object object) {
        return this.data.contains(object);
    }

    @Override
    public synchronized boolean containsAll(Collection<?> collection) {
        return this.data.containsAll(collection);
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public synchronized int size() {
        return this.data.size();
    }

    @Override
    public synchronized Iterator<T> iterator() {
        this.copyOnNextChange = true;
        return new Itr<T>(this.data.iterator());
    }

    @Override
    public synchronized ListIterator<T> listIterator() {
        this.copyOnNextChange = true;
        return new ListItr<T>(this.data.listIterator());
    }

    @Override
    public synchronized ListIterator<T> listIterator(int index) {
        this.copyOnNextChange = true;
        return new ListItr<T>(this.data.listIterator(index));
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized Object[] toArray() {
        return this.data.toArray();
    }

    @Override
    public synchronized <E> E[] toArray(E[] array) {
        return this.data.toArray(array);
    }

    @Override
    public boolean add(T object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Itr<T>
    implements Iterator<T> {
        private final Iterator<T> baseIterator;

        public Itr(Iterator<T> baseIterator) {
            this.baseIterator = baseIterator;
        }

        @Override
        public boolean hasNext() {
            return this.baseIterator.hasNext();
        }

        @Override
        public T next() {
            return this.baseIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ListItr<T>
    extends Itr<T>
    implements ListIterator<T> {
        private final ListIterator<T> baseIterator;

        public ListItr(ListIterator<T> baseIterator) {
            super(baseIterator);
            this.baseIterator = baseIterator;
        }

        @Override
        public int nextIndex() {
            return this.baseIterator.nextIndex();
        }

        @Override
        public boolean hasPrevious() {
            return this.baseIterator.hasPrevious();
        }

        @Override
        public T previous() {
            return this.baseIterator.previous();
        }

        @Override
        public int previousIndex() {
            return this.baseIterator.previousIndex();
        }

        @Override
        public void add(T object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(T object) {
            throw new UnsupportedOperationException();
        }
    }
}

