/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.sapphire.modeling.EditFailedException;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelMetadataItem;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.ModelPropertyListener;
import org.eclipse.sapphire.modeling.SapphireMultiStatus;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DependsOn;
import org.eclipse.sapphire.modeling.annotations.EnabledByBooleanProperty;
import org.eclipse.sapphire.modeling.annotations.EnabledByEnumProperty;
import org.eclipse.sapphire.modeling.annotations.ModelPropertyValidator;
import org.eclipse.sapphire.modeling.annotations.PropertyListeners;
import org.eclipse.sapphire.modeling.annotations.ReadOnly;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.annotations.Validator;
import org.eclipse.sapphire.modeling.annotations.Validators;
import org.eclipse.sapphire.modeling.internal.SapphireModelingFrameworkPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelProperty
extends ModelMetadataItem {
    public static final String PROPERTY_FIELD_PREFIX = "PROP_";
    private final ModelElementType modelElementType;
    private final String propertyName;
    private final ModelProperty baseProperty;
    private final Class<?> typeClass;
    private final ModelElementType type;
    private final List<Class<?>> allPossibleTypeClasses;
    private final List<Class<?>> allPossibleTypeClassesReadOnly;
    private final List<ModelElementType> allPossibleTypes;
    private final List<ModelElementType> allPossibleTypesReadOnly;
    private final Method getterMethod;
    private final Map<Class<? extends Annotation>, Annotation> annotations;
    private ModelPropertyValidator<?> validator;
    private boolean isValidatorInitialized;
    private Set<ModelPropertyListener> listeners;
    private Set<ModelPropertyListener> listenersReadOnly;
    private Set<ModelPath> dependencies;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ModelProperty(ModelElementType modelElementType, String propertyName, ModelProperty baseProperty) {
        block21: {
            block20: {
                try {
                    this.modelElementType = modelElementType;
                    this.propertyName = propertyName;
                    this.baseProperty = baseProperty;
                    this.dependencies = null;
                    String propLowerCase = this.propertyName.toLowerCase();
                    String alt1 = "get" + propLowerCase;
                    String alt2 = "is" + propLowerCase;
                    Method getter = null;
                    Method[] methodArray = this.modelElementType.getModelElementClass().getMethods();
                    int n = methodArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Method method = methodArray[n2];
                        String methodName = method.getName().toLowerCase();
                        if ((methodName.equals(alt1) || methodName.equals(alt2)) && method.getParameterTypes().length == 0) {
                            getter = method;
                            break;
                        }
                        ++n2;
                    }
                    if (getter == null) {
                        throw new IllegalStateException(propertyName);
                    }
                    this.getterMethod = getter;
                    this.annotations = new HashMap<Class<? extends Annotation>, Annotation>();
                    this.gatherAnnotations();
                    PropertyListeners propertyListenersAnnotation = this.getAnnotation(PropertyListeners.class);
                    if (propertyListenersAnnotation == null) break block20;
                    Class<? extends ModelPropertyListener>[] classArray = propertyListenersAnnotation.value();
                    int n3 = classArray.length;
                    n = 0;
                    while (n < n3) {
                        Class<? extends ModelPropertyListener> cl = classArray[n];
                        try {
                            this.addListener(cl.newInstance());
                        }
                        catch (Exception e) {
                            SapphireModelingFrameworkPlugin.log(e);
                        }
                        ++n;
                    }
                }
                catch (RuntimeException e) {
                    SapphireModelingFrameworkPlugin.log(e);
                    throw e;
                }
            }
            try {
                Type typeAnnotation = this.getAnnotation(Type.class);
                if (typeAnnotation == null) {
                    if (!(this instanceof ValueProperty)) {
                        String message = "Property \"" + propertyName + "\" of " + this.modelElementType.getModelElementClass().getClass() + " is missing the required Type annotation.";
                        throw new IllegalStateException(message);
                    }
                    this.typeClass = String.class;
                    this.allPossibleTypeClasses = Collections.singletonList(this.typeClass);
                    this.allPossibleTypeClassesReadOnly = this.allPossibleTypeClasses;
                    break block21;
                }
                this.typeClass = typeAnnotation.base();
                if (typeAnnotation.possible().length == 0) {
                    this.allPossibleTypeClasses = Collections.singletonList(this.typeClass);
                    this.allPossibleTypeClassesReadOnly = this.allPossibleTypeClasses;
                    break block21;
                }
                this.allPossibleTypeClasses = new ArrayList();
                Class<?>[] classArray = typeAnnotation.possible();
                int n = classArray.length;
                int n4 = 0;
                while (true) {
                    if (n4 >= n) {
                        this.allPossibleTypeClassesReadOnly = Collections.unmodifiableList(this.allPossibleTypeClasses);
                        break;
                    }
                    Class<?> cl = classArray[n4];
                    this.allPossibleTypeClasses.add(cl);
                    ++n4;
                }
            }
            catch (RuntimeException e) {
                SapphireModelingFrameworkPlugin.log(e);
                throw e;
            }
        }
        if (this instanceof ValueProperty) {
            this.type = null;
            this.allPossibleTypes = Collections.emptyList();
            this.allPossibleTypesReadOnly = Collections.emptyList();
        } else {
            this.type = ModelElementType.getModelElementType(this.typeClass);
            if (this.allPossibleTypeClasses.size() == 1) {
                this.allPossibleTypes = Collections.singletonList(ModelElementType.getModelElementType(this.typeClass));
                this.allPossibleTypesReadOnly = this.allPossibleTypes;
            } else {
                this.allPossibleTypes = new ArrayList<ModelElementType>();
                for (Class<?> cl : this.allPossibleTypeClasses) {
                    this.allPossibleTypes.add(ModelElementType.getModelElementType(cl));
                }
                this.allPossibleTypesReadOnly = Collections.unmodifiableList(this.allPossibleTypes);
            }
        }
        this.modelElementType.addProperty(this);
    }

    public ModelElementType getModelElementType() {
        return this.modelElementType;
    }

    public String getName() {
        return this.propertyName;
    }

    public final Class<?> getTypeClass() {
        return this.typeClass;
    }

    public final ModelElementType getType() {
        return this.type;
    }

    public final List<Class<?>> getAllPossibleTypeClasses() {
        return this.allPossibleTypeClassesReadOnly;
    }

    public final List<ModelElementType> getAllPossibleTypes() {
        return this.allPossibleTypesReadOnly;
    }

    public final boolean isOfType(Class<?> type) {
        return type.isAssignableFrom(this.getTypeClass());
    }

    @Override
    public ModelProperty getBase() {
        return this.baseProperty;
    }

    public Method getGetterMethod() {
        return this.getterMethod;
    }

    public <T> T invokeGetterMethod(Object model) {
        try {
            return (T)this.getterMethod.invoke(model, new Object[0]);
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof EditFailedException) {
                throw (EditFailedException)cause;
            }
            Class<?> expectedClass = this.getModelElementType().getModelElementClass();
            Class<?> actualClass = model.getClass();
            StringBuilder buf = new StringBuilder();
            buf.append("Expected: ");
            buf.append(expectedClass.getName());
            buf.append('\n');
            buf.append("Actual: ");
            buf.append(actualClass.getName());
            throw new RuntimeException(buf.toString(), cause);
        }
    }

    @Override
    public <A extends Annotation> List<A> getAnnotations(Class<A> type) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        Annotation annotation = this.annotations.get(type);
        if (annotation != null) {
            annotations.add(annotation);
        }
        if (this.baseProperty != null) {
            annotations.addAll(this.baseProperty.getAnnotations(type));
        }
        return annotations;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> type, boolean localOnly) {
        Annotation annotation = this.annotations.get(type);
        if (annotation == null && this.baseProperty != null && !localOnly) {
            annotation = this.baseProperty.getAnnotation(type);
        }
        return (A)annotation;
    }

    @Override
    public String getResource(String key) {
        String resource = this.modelElementType.getResource(key);
        if (resource == null && this.baseProperty != null) {
            resource = this.baseProperty.getResource(key);
        }
        return resource;
    }

    @Override
    protected String getLabelResourceKeyBase() {
        return this.propertyName;
    }

    @Override
    protected String getDefaultLabel() {
        return this.transformCamelCaseToLabel(this.propertyName);
    }

    public ModelProperty refine(ModelElementType type) {
        return type.getProperty(this.propertyName);
    }

    public ModelProperty refine(IModelElement modelElement) {
        return this.refine(ModelElementType.getModelElementType(modelElement.getClass()));
    }

    public final synchronized ModelPropertyValidator<?> getValidator() {
        if (!this.isValidatorInitialized) {
            ModelPropertyValidator<Object> unionValidator;
            final List<ModelPropertyValidator<? extends Object>> validators = this.createValidators();
            this.validator = validators.isEmpty() ? null : (validators.size() == 1 ? validators.get(0) : (unionValidator = new ModelPropertyValidator<Object>(){

                @Override
                public IStatus validate(Object value) {
                    SapphireMultiStatus multiStatus = new SapphireMultiStatus();
                    for (ModelPropertyValidator validator : validators) {
                        multiStatus.add(validator.validate(value));
                    }
                    return multiStatus;
                }
            }));
            this.isValidatorInitialized = true;
        }
        return this.validator;
    }

    protected List<ModelPropertyValidator<? extends Object>> createValidators() {
        ArrayList<ModelPropertyValidator<? extends Object>> validators = new ArrayList<ModelPropertyValidator<? extends Object>>();
        ModelProperty.createValidators(validators, this);
        return validators;
    }

    private static void createValidators(List<ModelPropertyValidator<? extends Object>> validators, ModelProperty property) {
        ModelProperty baseProperty;
        Validators validatorsAnnotation;
        Validator validatorAnnotation = property.getAnnotation(Validator.class, true);
        if (validatorAnnotation != null) {
            ModelProperty.createValidator(validators, validatorAnnotation);
        }
        if ((validatorsAnnotation = property.getAnnotation(Validators.class, true)) != null) {
            Validator[] validatorArray = validatorsAnnotation.value();
            int n = validatorArray.length;
            int n2 = 0;
            while (n2 < n) {
                Validator x = validatorArray[n2];
                ModelProperty.createValidator(validators, x);
                ++n2;
            }
        }
        if ((baseProperty = property.getBase()) != null) {
            ModelProperty.createValidators(validators, baseProperty);
        }
    }

    private static void createValidator(List<ModelPropertyValidator<? extends Object>> validators, Validator validatorAnnotation) {
        Class<ModelPropertyValidator<?>> validatorClass = validatorAnnotation.impl();
        try {
            ModelPropertyValidator<?> validator = validatorClass.newInstance();
            validator.init(validatorAnnotation.params());
            validators.add(validator);
        }
        catch (Exception e) {
            SapphireModelingFrameworkPlugin.log(e);
        }
    }

    public boolean isReadOnly() {
        return this.hasAnnotation(ReadOnly.class);
    }

    private void gatherAnnotations() {
        AccessibleObject propField = null;
        Object[] objectArray = this.modelElementType.getModelElementClass().getFields();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            String propName;
            Field field = objectArray[n2];
            String fieldName = field.getName();
            if (fieldName.startsWith(PROPERTY_FIELD_PREFIX) && this.propertyName.equalsIgnoreCase(propName = ModelProperty.convertFieldNameToPropertyName(fieldName))) {
                propField = field;
                break;
            }
            ++n2;
        }
        if (propField != null) {
            objectArray = propField.getAnnotations();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                Object x = objectArray[n2];
                this.annotations.put(x.annotationType(), (Annotation)x);
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ModelPropertyListener> getListeners() {
        ModelProperty modelProperty = this;
        synchronized (modelProperty) {
            if (this.listeners == null) {
                return Collections.emptySet();
            }
            return this.listenersReadOnly;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ModelPropertyListener listener) {
        ModelProperty modelProperty = this;
        synchronized (modelProperty) {
            if (this.listeners == null) {
                this.listeners = new CopyOnWriteArraySet<ModelPropertyListener>();
                this.listenersReadOnly = Collections.unmodifiableSet(this.listeners);
            }
            this.listeners.add(listener);
        }
    }

    protected RuntimeException convertReflectiveInvocationException(Exception e) {
        Throwable cause = e.getCause();
        if (cause instanceof EditFailedException) {
            return (EditFailedException)cause;
        }
        return new RuntimeException(e);
    }

    private static String convertFieldNameToPropertyName(String fieldName) {
        if (fieldName.startsWith(PROPERTY_FIELD_PREFIX)) {
            StringBuilder buffer = new StringBuilder();
            int i = PROPERTY_FIELD_PREFIX.length();
            while (i < fieldName.length()) {
                char ch = fieldName.charAt(i);
                if (ch != '_') {
                    buffer.append(ch);
                }
                ++i;
            }
            return buffer.toString();
        }
        return null;
    }

    public final Set<ModelPath> getDependencies() {
        if (this.dependencies == null) {
            EnabledByEnumProperty enabledByEnumProperty;
            EnabledByBooleanProperty enabledByBooleanProperty;
            HashSet<String> dependenciesAsStrings = new HashSet<String>();
            DependsOn dependsOnAnnotation = this.getAnnotation(DependsOn.class);
            if (dependsOnAnnotation != null) {
                String[] stringArray = dependsOnAnnotation.value();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String dependsOnPropertyRef = stringArray[n2];
                    dependenciesAsStrings.add(dependsOnPropertyRef);
                    ++n2;
                }
            }
            if ((enabledByBooleanProperty = this.getAnnotation(EnabledByBooleanProperty.class)) != null) {
                dependenciesAsStrings.add(enabledByBooleanProperty.value());
            }
            if ((enabledByEnumProperty = this.getAnnotation(EnabledByEnumProperty.class)) != null) {
                dependenciesAsStrings.add(enabledByEnumProperty.property());
            }
            HashSet<ModelPath> dependencies = new HashSet<ModelPath>();
            for (String str : dependenciesAsStrings) {
                ModelPath path = null;
                try {
                    path = new ModelPath(str);
                }
                catch (ModelPath.MalformedPathException e) {
                    SapphireModelingFrameworkPlugin.log(e);
                }
                dependencies.add(path);
            }
            this.dependencies = Collections.unmodifiableSet(dependencies);
        }
        return this.dependencies;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.modelElementType.getModelElementClass().getName());
        buf.append('#');
        buf.append(this.propertyName);
        return buf.toString();
    }
}

