/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.extensibility;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.sapphire.modeling.ModelElementService;
import org.eclipse.sapphire.modeling.util.internal.PluginUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServicesExtensionPoint {
    private static final String EL_SERVICE = "service";
    private static final String ATTR_IMPL = "impl";
    private static final ServiceRecord BAD_SERVICE_RECORD = new ServiceRecord();
    private static List<ServiceRecord> services = null;
    private static Map<Class<?>, ServiceRecord> cachedServiceLookups = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <S extends ModelElementService> S getService(Class<S> serviceType) {
        ServicesExtensionPoint.initialize();
        ServiceRecord serviceRecord = null;
        Class<ServicesExtensionPoint> clazz = ServicesExtensionPoint.class;
        synchronized (ServicesExtensionPoint.class) {
            serviceRecord = cachedServiceLookups.get(serviceType);
            if (serviceRecord == null) {
                for (ServiceRecord rec : services) {
                    if (!serviceType.isAssignableFrom(rec.implClass)) continue;
                    serviceRecord = rec;
                    cachedServiceLookups.put(serviceType, rec);
                    break;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            ModelElementService service = null;
            if (serviceRecord == null || serviceRecord == BAD_SERVICE_RECORD || (service = PluginUtil.instantiate(serviceRecord.declaringBundleId, serviceRecord.implClass)) != null) return (S)service;
            Class<ServicesExtensionPoint> clazz2 = ServicesExtensionPoint.class;
            synchronized (ServicesExtensionPoint.class) {
                cachedServiceLookups.put(serviceType, BAD_SERVICE_RECORD);
                services.remove(serviceRecord);
                // ** MonitorExit[var3_4] (shouldn't be in output)
                return (S)service;
            }
        }
    }

    private static synchronized void initialize() {
        if (services == null) {
            services = new ArrayList<ServiceRecord>();
            cachedServiceLookups = new HashMap();
            for (IConfigurationElement el : PluginUtil.getTopLevelElements(PluginUtil.findExtensions("org.eclipse.sapphire.modeling", "services"))) {
                String declaringBundleId = el.getNamespaceIdentifier();
                if (!el.getName().equals(EL_SERVICE)) continue;
                ServiceRecord serviceRecord = new ServiceRecord();
                serviceRecord.declaringBundleId = declaringBundleId;
                try {
                    String clname = PluginUtil.findRequiredAttribute(el, ATTR_IMPL);
                    serviceRecord.implClass = PluginUtil.loadClass(declaringBundleId, clname, ModelElementService.class);
                    if (serviceRecord.implClass == null) continue;
                    services.add(serviceRecord);
                }
                catch (PluginUtil.InvalidExtensionException invalidExtensionException) {}
            }
        }
    }

    private static final class ServiceRecord {
        public Class<ModelElementService> implClass;
        public String declaringBundleId;

        private ServiceRecord() {
        }
    }
}

