/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.sapphire.modeling.ByteArrayModelStore;
import org.eclipse.sapphire.modeling.EclipseFileModelStore;
import org.eclipse.sapphire.modeling.FileModelStore;
import org.eclipse.sapphire.modeling.IEclipseFileModelStore;
import org.eclipse.sapphire.modeling.IFileModelStore;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelStore;
import org.eclipse.sapphire.modeling.xml.XmlDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ModelStoreForXml
extends ModelStore
implements IEclipseFileModelStore {
    private static final String UTF8_ENCODING = "UTF-8";
    private final ByteArrayModelStore baseModelStore;
    protected Document document;

    public ModelStoreForXml(ByteArrayModelStore baseModelStore) {
        this.baseModelStore = baseModelStore;
        this.document = null;
    }

    public ModelStoreForXml(byte[] contents) {
        this(new ByteArrayModelStore(contents));
    }

    public ModelStoreForXml(InputStream contents) throws IOException {
        this(new ByteArrayModelStore(contents));
    }

    public ModelStoreForXml(File file) {
        this(ModelStoreForXml.createFileModelStore(file));
    }

    public ModelStoreForXml(IFile file) {
        this(new EclipseFileModelStore(file));
    }

    public IFile getEclipseFile() {
        if (this.baseModelStore instanceof IEclipseFileModelStore) {
            return ((IEclipseFileModelStore)((Object)this.baseModelStore)).getEclipseFile();
        }
        return null;
    }

    public File getFile() {
        if (this.baseModelStore instanceof IFileModelStore) {
            return ((IFileModelStore)((Object)this.baseModelStore)).getFile();
        }
        return null;
    }

    public Document getDocument() {
        return this.document;
    }

    public boolean isXmlDeclarationNeeded() {
        return false;
    }

    public void registerRootModelElement(IModelElement rootModelElement) {
    }

    public void registerModelElement(Node xmlNode, IModelElement modelElement) {
    }

    public void open() throws IOException {
        block9: {
            try {
                this.baseModelStore.open();
                byte[] contents = this.baseModelStore.getContents();
                if (contents.length <= 0) break block9;
                ByteArrayInputStream in = new ByteArrayInputStream(contents);
                try {
                    InputStreamReader reader = new InputStreamReader((InputStream)in, UTF8_ENCODING);
                    this.document = ModelStoreForXml.doc(reader);
                }
                catch (Throwable throwable) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
            }
            catch (Exception exception) {}
        }
        if (this.document == null) {
            this.document = ModelStoreForXml.doc();
        }
        this.document.setStrictErrorChecking(false);
    }

    public void save() throws IOException {
        if (this.validateEdit()) {
            try {
                if (this.document.getDocumentElement() != null) {
                    NodeList nodes = this.document.getChildNodes();
                    int i = 0;
                    int n = nodes.getLength();
                    while (i < n) {
                        Node node = nodes.item(i);
                        if (node == null || node.getNodeType() != 3 || node.getNodeValue().trim().length() != 0) break;
                        this.document.removeChild(node);
                        ++i;
                    }
                    XmlDocument.addXmlProcessingInstruction(this.document);
                    StringWriter sw = new StringWriter();
                    DOMSource source = new DOMSource(this.document);
                    StreamResult result = new StreamResult(sw);
                    TransformerFactory factory = TransformerFactory.newInstance();
                    Transformer transformer = factory.newTransformer();
                    transformer.setOutputProperty("omit-xml-declaration", "yes");
                    transformer.transform(source, result);
                    this.baseModelStore.setContents(sw.toString().getBytes(UTF8_ENCODING));
                } else {
                    this.baseModelStore.setContents(new byte[0]);
                }
                this.baseModelStore.save();
            }
            catch (Exception e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
        }
    }

    public boolean validateEdit() {
        return this.baseModelStore.validateEdit();
    }

    public boolean isOutOfDate() {
        return this.baseModelStore.isOutOfDate();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ModelStoreForXml) {
            return this.baseModelStore.equals(((ModelStoreForXml)obj).baseModelStore);
        }
        return false;
    }

    public int hashCode() {
        return this.baseModelStore.hashCode();
    }

    public String getLocalizedText(String text, Locale locale) {
        return this.baseModelStore.getLocalizedText(text, locale);
    }

    private static IFile getWorkspaceFile(File f) {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot wsroot = ws.getRoot();
        IFile[] wsFiles = wsroot.findFilesForLocationURI(f.toURI());
        if (wsFiles.length > 0) {
            return wsFiles[0];
        }
        return null;
    }

    private static ByteArrayModelStore createFileModelStore(File file) {
        IFile ifile = ModelStoreForXml.getWorkspaceFile(file);
        if (ifile != null) {
            return new EclipseFileModelStore(ifile);
        }
        return new FileModelStore(file);
    }

    private static Document doc(Reader r) {
        DocumentBuilder docbuilder = ModelStoreForXml.docbuilder();
        try {
            return docbuilder.parse(new InputSource(r));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SAXParseException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private static Document doc() {
        return ModelStoreForXml.docbuilder().newDocument();
    }

    private static DocumentBuilder docbuilder() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            factory.setIgnoringComments(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicID, String systemID) {
                    return new InputSource(new StringReader(""));
                }
            });
            return builder;
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }
}

