/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml;

import org.eclipse.sapphire.modeling.CorruptedModelStoreException;
import org.eclipse.sapphire.modeling.CorruptedModelStoreExceptionInterceptor;
import org.eclipse.sapphire.modeling.xml.ModelStoreForXml;
import org.eclipse.sapphire.modeling.xml.RootElementController;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public final class XmlDocument
extends XmlNode {
    private static final String PI_XML_TARGET = "xml";
    private static final String PI_XML_DATA = "version=\"1.0\" encoding=\"UTF-8\"";
    private final Document document;

    public XmlDocument(Document document, ModelStoreForXml modelStoreForXml) {
        super(document, modelStoreForXml);
        this.document = document;
    }

    public XmlElement getRootElement(RootElementController rootElementController) {
        return this.getRootElement(rootElementController, false);
    }

    public XmlElement getRootElement(RootElementController rootElementController, boolean createIfNecessary) {
        return this.getRootElement(rootElementController, createIfNecessary, null);
    }

    public XmlElement getRootElement(RootElementController rootElementController, boolean createIfNecessary, CorruptedModelStoreExceptionInterceptor interceptor) {
        Element root = this.document.getDocumentElement();
        if (this.document.getChildNodes().getLength() == 0) {
            if (createIfNecessary) {
                root = this.createRootElement(rootElementController);
            }
        } else {
            boolean isRootValid;
            boolean bl = isRootValid = root == null ? false : rootElementController.checkRootElement(this.document);
            if (!isRootValid) {
                root = null;
                if (createIfNecessary) {
                    if (interceptor != null && interceptor.shouldAttemptRepair()) {
                        root = this.createRootElement(rootElementController);
                    } else {
                        throw new CorruptedModelStoreException();
                    }
                }
            }
        }
        if (root == null) {
            return null;
        }
        return new XmlElement(null, root, this.getModelStoreForXml());
    }

    private Element createRootElement(RootElementController rootElementController) {
        NodeList topLevelNodes = this.document.getChildNodes();
        Node[] nodes = new Node[topLevelNodes.getLength()];
        int i = 0;
        int n = nodes.length;
        while (i < n) {
            nodes[i] = topLevelNodes.item(i);
            ++i;
        }
        Node[] nodeArray = nodes;
        int n2 = nodes.length;
        int n3 = 0;
        while (n3 < n2) {
            Node node = nodeArray[n3];
            this.document.removeChild(node);
            ++n3;
        }
        XmlDocument.addXmlProcessingInstruction(this.document);
        rootElementController.createRootElement(this.document);
        return this.document.getDocumentElement();
    }

    public static void addXmlProcessingInstruction(Document document) {
        NodeList nodes = document.getChildNodes();
        int i = 0;
        int n = nodes.getLength();
        while (i < n) {
            ProcessingInstruction pi;
            Node node = nodes.item(i);
            if (node.getNodeType() == 7 && (pi = (ProcessingInstruction)node).getTarget().equals(PI_XML_TARGET)) {
                pi.setData(PI_XML_DATA);
                return;
            }
            ++i;
        }
        ProcessingInstruction pi = document.createProcessingInstruction(PI_XML_TARGET, PI_XML_DATA);
        document.insertBefore(pi, document.getFirstChild());
    }

    protected String getTextInternal() {
        throw new UnsupportedOperationException();
    }

    public void setText(String text) {
        throw new UnsupportedOperationException();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

