/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.sapphire.modeling.xml.ModelStoreForXml;
import org.eclipse.sapphire.modeling.xml.XmlAttribute;
import org.eclipse.sapphire.modeling.xml.XmlComment;
import org.eclipse.sapphire.modeling.xml.XmlMetaComment;
import org.eclipse.sapphire.modeling.xml.XmlNode;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.modeling.xml.schema.XmlContentModel;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchema;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchemasCache;
import org.eclipse.sapphire.modeling.xml.schema.XmlElementDefinition;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlElement
extends XmlNode {
    private final XmlElement parent;
    private final Element domElement;
    private QName qname;
    private XmlContentModel contentModel;
    private boolean contentModelInitialized;

    public XmlElement(XmlElement parent, Element domElement, ModelStoreForXml modelStoreForXml) {
        super(domElement, modelStoreForXml);
        this.parent = parent;
        this.domElement = domElement;
        this.qname = null;
        this.contentModel = null;
        this.contentModelInitialized = false;
    }

    public XmlElement getParent() {
        return this.parent;
    }

    @Override
    public Element getDomNode() {
        return this.domElement;
    }

    public String getLocalName() {
        return this.domElement.getLocalName();
    }

    public String getNamespace() {
        return this.domElement.getNamespaceURI();
    }

    public QName getQualifiedName() {
        if (this.qname == null) {
            this.qname = new QName(this.getNamespace(), this.getLocalName());
        }
        return this.qname;
    }

    public String getSchemaLocation() {
        String namespace = this.getNamespace();
        if (namespace != null) {
            Element root = this.domElement.getOwnerDocument().getDocumentElement();
            NamedNodeMap attributes = root.getAttributes();
            int i = 0;
            int n = attributes.getLength();
            while (i < n) {
                Attr attr = (Attr)attributes.item(i);
                String attrLocalName = attr.getLocalName();
                if (attrLocalName != null && attrLocalName.equals("schemaLocation")) {
                    String[] segments = attr.getValue().split("[\\s]+");
                    boolean grabNextSegment = false;
                    int j = 0;
                    int m = segments.length;
                    while (j < m) {
                        if (j % 2 == 0) {
                            if (segments[j].equals(namespace)) {
                                grabNextSegment = true;
                            }
                        } else if (grabNextSegment) {
                            return segments[j];
                        }
                        ++j;
                    }
                    return namespace;
                }
                ++i;
            }
            return namespace;
        }
        return null;
    }

    public XmlContentModel getContentModel() {
        if (!this.contentModelInitialized) {
            if (this.parent == null) {
                XmlElementDefinition xmlElementDefinition;
                XmlDocumentSchema xmlDocumentSchema;
                DocumentType type;
                String schemaLocation = this.getSchemaLocation();
                String baseLocation = null;
                if (schemaLocation == null && (type = this.domElement.getOwnerDocument().getDoctype()) != null) {
                    baseLocation = this.getModelStoreForXml().getFile().getAbsolutePath();
                    schemaLocation = type.getSystemId();
                }
                if (schemaLocation != null && (xmlDocumentSchema = XmlDocumentSchemasCache.getSchema(schemaLocation, baseLocation)) != null && (xmlElementDefinition = xmlDocumentSchema.getElement(this.getLocalName())) != null) {
                    this.contentModel = xmlElementDefinition.getContentModel();
                }
            } else {
                XmlContentModel parentXmlContentModel = this.parent.getContentModel();
                if (parentXmlContentModel != null) {
                    this.contentModel = parentXmlContentModel.findChildElementContentModel(this.getQualifiedName());
                }
            }
            this.contentModelInitialized = true;
        }
        return this.contentModel;
    }

    @Override
    protected String getTextInternal() {
        NodeList nodes = this.domElement.getChildNodes();
        String str = null;
        StringBuilder buf = null;
        int i = 0;
        int n = nodes.getLength();
        while (i < n) {
            Node node = nodes.item(i);
            short nodeType = node.getNodeType();
            if (nodeType == 3 || nodeType == 4) {
                String val = node.getNodeValue();
                if (buf != null) {
                    buf.append(val);
                } else if (str != null) {
                    buf = new StringBuilder();
                    buf.append(str);
                    buf.append(val);
                    str = null;
                } else {
                    str = val;
                }
            }
            ++i;
        }
        if (buf != null) {
            return buf.toString();
        }
        return str != null ? str : "";
    }

    @Override
    public void setText(String elementText) {
        if (elementText == null) {
            elementText = "";
        }
        NodeList elementChildren = this.domElement.getChildNodes();
        CharacterData text = null;
        int i = 0;
        int n = elementChildren.getLength();
        while (i < n) {
            Node child = elementChildren.item(i);
            if (text == null && child.getNodeType() == 3) {
                text = (Text)child;
            } else {
                this.domElement.removeChild(elementChildren.item(i));
            }
            ++i;
        }
        if (text != null) {
            text.setData(elementText);
        } else {
            this.domElement.appendChild(this.domElement.getOwnerDocument().createTextNode(elementText));
        }
    }

    public XmlAttribute getAttribute(String name, boolean createIfNecessary) {
        Attr attrNode = this.domElement.getAttributeNode(name);
        if (attrNode == null && createIfNecessary) {
            attrNode = this.domElement.getOwnerDocument().createAttribute(name);
            this.domElement.setAttributeNode(attrNode);
        }
        if (attrNode == null) {
            return null;
        }
        return new XmlAttribute(attrNode, this.getModelStoreForXml());
    }

    public String getAttributeText(String name) {
        XmlAttribute attr = this.getAttribute(name, false);
        if (attr == null) {
            return "";
        }
        return attr.getText();
    }

    public void setAttributeText(String name, String value, boolean removeIfNullOrEmpty) {
        String val;
        String string = val = value == null ? "" : value;
        if (val.length() == 0) {
            XmlAttribute attr = this.getAttribute(name, false);
            if (attr != null) {
                if (removeIfNullOrEmpty) {
                    attr.remove();
                } else {
                    this.getAttribute(name, true).setText(val);
                }
            }
        } else {
            this.getAttribute(name, true).setText(val);
        }
    }

    public List<XmlElement> getChildElements() {
        Element firstElement = null;
        ArrayList<XmlElement> elements = null;
        NodeList children = this.domElement.getChildNodes();
        int i = 0;
        int n = children.getLength();
        while (i < n) {
            Node node = children.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                if (elements != null) {
                    elements.add(new XmlElement(this, element, this.getModelStoreForXml()));
                } else if (firstElement != null) {
                    elements = new ArrayList<XmlElement>();
                    elements.add(new XmlElement(this, firstElement, this.getModelStoreForXml()));
                    elements.add(new XmlElement(this, element, this.getModelStoreForXml()));
                    firstElement = null;
                } else {
                    firstElement = element;
                }
            }
            ++i;
        }
        if (elements != null) {
            return elements;
        }
        if (firstElement != null) {
            return Collections.singletonList(new XmlElement(this, firstElement, this.getModelStoreForXml()));
        }
        return Collections.emptyList();
    }

    public List<XmlElement> getChildElements(QName childElementName) {
        String namespace = this.domElement.getNamespaceURI();
        Element firstElement = null;
        ArrayList<XmlElement> elements = null;
        NodeList children = this.domElement.getChildNodes();
        int i = 0;
        int n = children.getLength();
        while (i < n) {
            Node node = children.item(i);
            if (node.getNodeType() == 1 && XmlElement.equal(node.getNamespaceURI(), namespace) && childElementName.equals(new QName(node.getNamespaceURI(), node.getLocalName()))) {
                Element element = (Element)node;
                if (elements != null) {
                    elements.add(new XmlElement(this, element, this.getModelStoreForXml()));
                } else if (firstElement != null) {
                    elements = new ArrayList<XmlElement>();
                    elements.add(new XmlElement(this, firstElement, this.getModelStoreForXml()));
                    elements.add(new XmlElement(this, element, this.getModelStoreForXml()));
                    firstElement = null;
                } else {
                    firstElement = element;
                }
            }
            ++i;
        }
        if (elements != null) {
            return elements;
        }
        if (firstElement != null) {
            return Collections.singletonList(new XmlElement(this, firstElement, this.getModelStoreForXml()));
        }
        return Collections.emptyList();
    }

    public List<XmlElement> getChildElements(String childElementName) {
        return this.getChildElements(this.createQualifiedName(childElementName));
    }

    public XmlElement getChildElement(QName qname, boolean createIfNecessary) {
        String namespace = qname.getNamespaceURI();
        String localName = qname.getLocalPart();
        NodeList children = this.domElement.getChildNodes();
        int i = 0;
        int n = children.getLength();
        while (i < n) {
            Node node = children.item(i);
            if (node.getNodeType() == 1 && XmlElement.equal(XmlElement.normalizeToNull(node.getNamespaceURI()), XmlElement.normalizeToNull(namespace)) && node.getLocalName().equals(localName)) {
                return new XmlElement(this, (Element)node, this.getModelStoreForXml());
            }
            ++i;
        }
        if (createIfNecessary) {
            return this.addChildElement(qname);
        }
        return null;
    }

    public XmlElement getChildElement(String name, boolean createIfNecessary) {
        return this.getChildElement(this.createQualifiedName(name), createIfNecessary);
    }

    public XmlElement addChildElement(QName name) {
        Element element;
        Node prevChild;
        Document document = this.domElement.getOwnerDocument();
        NodeList nodes = this.domElement.getChildNodes();
        XmlContentModel xmlContentModel = this.getContentModel();
        int position = xmlContentModel == null ? nodes.getLength() : xmlContentModel.findInsertionPosition(nodes, name);
        Node refChild = position < nodes.getLength() ? nodes.item(position) : null;
        int prevPosition = position - 1;
        Node node = prevChild = prevPosition < nodes.getLength() ? nodes.item(prevPosition) : null;
        if (prevChild != null && prevChild.getNodeType() == 3 && prevChild.getNodeValue().trim().length() == 0) {
            refChild = prevChild;
            position = prevPosition;
        }
        prevChild = (prevPosition = position - 1) < nodes.getLength() ? nodes.item(prevPosition) : null;
        String namespace = name.getNamespaceURI();
        if (namespace == null || namespace.length() == 0) {
            element = document.createElementNS(null, name.getLocalPart());
        } else {
            String prefix = this.findNamespacePrefix(namespace, name.getPrefix());
            String qname = prefix == null || prefix.length() == 0 ? name.getLocalPart() : String.valueOf(prefix) + ":" + name.getLocalPart();
            element = document.createElementNS(namespace, qname);
        }
        this.domElement.insertBefore(element, refChild);
        XmlElement wrappedElement = new XmlElement(this, element, this.getModelStoreForXml());
        if (this.domElement.getNodeType() == 1 && this.domElement.getChildNodes().getLength() == 1) {
            this.format();
        } else {
            wrappedElement.format();
        }
        return wrappedElement;
    }

    public XmlElement addChildElement(String name) {
        return this.addChildElement(this.createQualifiedName(name));
    }

    private String findNamespacePrefix(String namespace, String defaultPrefix) {
        String prefix = null;
        if (namespace != null && namespace.length() > 0) {
            String ns = this.getNamespace();
            if (ns != null && ns.equals(namespace)) {
                prefix = this.domElement.getPrefix();
            } else {
                Element el = this.domElement;
                boolean found = false;
                while (el != null && !found) {
                    NamedNodeMap attributes = el.getAttributes();
                    int i = 0;
                    int n = attributes.getLength();
                    while (i < n) {
                        Attr attr = (Attr)attributes.item(i);
                        String attrName = attr.getName();
                        String attrValue = attr.getValue();
                        if (attrName.equals("xmlns")) {
                            if (attrValue.equals(namespace)) {
                                found = true;
                                break;
                            }
                        } else if (attrName.startsWith("xmlns:") && attrValue.equals(namespace)) {
                            prefix = attrName.substring(6);
                            found = true;
                            break;
                        }
                        ++i;
                    }
                    Node parent = el.getParentNode();
                    el = parent instanceof Element ? (Element)parent : null;
                }
                if (!found) {
                    prefix = defaultPrefix;
                    String xmlnsAttrName = "xmlns:" + defaultPrefix;
                    Element root = this.domElement.getOwnerDocument().getDocumentElement();
                    root.setAttribute(xmlnsAttrName, namespace);
                    if (!namespace.equals("http://www.w3.org/2001/XMLSchema-instance")) {
                        XmlContentModel xmlContentModel = this.getContentModel();
                        String schemaLocation = null;
                        if (xmlContentModel != null) {
                            schemaLocation = xmlContentModel.getSchema().getSchemaLocation(namespace);
                        }
                        this.addSchemaLocation(namespace, schemaLocation);
                    }
                }
            }
        }
        return prefix;
    }

    private void addSchemaLocation(String namespace, String schemaLocation) {
        if (schemaLocation != null) {
            String xsiNamespacePrefix = this.findNamespacePrefix("http://www.w3.org/2001/XMLSchema-instance", "xsi");
            String schemaLocationAttrName = xsiNamespacePrefix == null ? "schemaLocation" : String.valueOf(xsiNamespacePrefix) + ":schemaLocation";
            Element root = this.domElement.getOwnerDocument().getDocumentElement();
            String existingSchemaLocations = root.getAttribute(schemaLocationAttrName);
            LinkedHashMap<String, String> schemaLocations = new LinkedHashMap<String, String>();
            if (existingSchemaLocations != null && existingSchemaLocations.length() > 0) {
                String ns = null;
                String[] stringArray = existingSchemaLocations.split("[\\s]+");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String segment = stringArray[n2];
                    if (ns == null) {
                        ns = segment;
                    } else {
                        schemaLocations.put(ns, segment);
                        ns = null;
                    }
                    ++n2;
                }
            }
            schemaLocations.put(namespace, schemaLocation);
            StringBuilder buf = new StringBuilder();
            for (Map.Entry entry : schemaLocations.entrySet()) {
                if (buf.length() > 0) {
                    buf.append(' ');
                }
                buf.append((String)entry.getKey());
                buf.append(' ');
                buf.append((String)entry.getValue());
            }
            root.setAttribute(schemaLocationAttrName, buf.toString());
        }
    }

    public XmlNode getChildNode(XmlPath path, boolean createIfNecessary) {
        XmlElement el = this;
        for (XmlPath.Segment segment : path.getSegments()) {
            XmlNode node = el.getChildNode(segment, createIfNecessary);
            if (node instanceof XmlElement) {
                el = (XmlElement)node;
                continue;
            }
            return node;
        }
        return el;
    }

    public XmlNode getChildNode(XmlPath.Segment pathSegment, boolean createIfNecessary) {
        XmlPath.Segment resolvedPathSegment = this.resolveXmlPathSegment(pathSegment);
        QName qname = resolvedPathSegment.getQualifiedName();
        if (resolvedPathSegment.isAttribute()) {
            return this.getAttribute(qname.getLocalPart(), createIfNecessary);
        }
        if (resolvedPathSegment.isComment()) {
            return this.getMetaComment(qname.getLocalPart(), createIfNecessary);
        }
        return this.getChildElement(qname, createIfNecessary);
    }

    public String getChildNodeText(XmlPath path) {
        return this.getChildNodeText(path, false);
    }

    public String getChildNodeText(XmlPath path, boolean removeExtraWhitespace) {
        XmlNode node = this.getChildNode(path, false);
        if (node != null) {
            return node.getText(removeExtraWhitespace);
        }
        return "";
    }

    public String getChildNodeText(String path) {
        return this.getChildNodeText(new XmlPath(path));
    }

    public String getChildNodeText(String path, boolean removeExtraWhitespace) {
        return this.getChildNodeText(new XmlPath(path), removeExtraWhitespace);
    }

    public void setChildNodeText(XmlPath path, String text, boolean removeIfNullOrEmpty) {
        if (removeIfNullOrEmpty && (text == null || text.trim().length() == 0)) {
            this.removeChildNode(path);
        } else {
            this.getChildNode(path, true).setText(text);
        }
    }

    public void setChildNodeText(String path, String text, boolean removeIfNullOrEmpty) {
        this.setChildNodeText(new XmlPath(path), text, removeIfNullOrEmpty);
    }

    public void removeChildNode(XmlPath path) {
        XmlElement.removeChildNode(this, path, 0);
    }

    private static void removeChildNode(XmlElement el, XmlPath path, int pathPosition) {
        XmlPath.Segment segment = path.getSegment(pathPosition);
        XmlNode child = el.getChildNode(segment, false);
        if (child != null) {
            if (pathPosition == path.getSegmentCount() - 1) {
                child.remove();
            } else if (child instanceof XmlElement) {
                XmlElement childElement = (XmlElement)child;
                XmlElement.removeChildNode(childElement, path, pathPosition + 1);
                if (childElement.isEmpty()) {
                    childElement.remove();
                }
            }
        }
    }

    public void swap(XmlElement y) {
        Node parent = this.domElement.getParentNode();
        Document document = parent.getOwnerDocument();
        Text xBookmark = document.createTextNode("");
        parent.insertBefore(xBookmark, this.domElement);
        Text yBookmark = document.createTextNode("");
        parent.insertBefore(yBookmark, y.domElement);
        parent.removeChild(this.domElement);
        parent.removeChild(y.domElement);
        parent.insertBefore(this.domElement, yBookmark);
        parent.insertBefore(y.domElement, xBookmark);
        parent.removeChild(xBookmark);
        parent.removeChild(yBookmark);
    }

    @Override
    public void remove() {
        Node parentDomNode = this.domElement.getParentNode();
        if (parentDomNode != null) {
            Node previousSibling = this.domElement.getPreviousSibling();
            parentDomNode.removeChild(this.domElement);
            if (previousSibling != null && previousSibling.getNodeType() == 3 && previousSibling.getNodeValue().trim().length() == 0) {
                parentDomNode.removeChild(previousSibling);
            }
        }
    }

    public boolean isEmpty() {
        NodeList nodes = this.domElement.getChildNodes();
        int i = 0;
        int n = nodes.getLength();
        while (i < n) {
            Node child = nodes.item(i);
            if (child.getNodeType() != 3 || child.getNodeValue().trim().length() > 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public XmlComment addComment(String commentText) {
        Node prevChild;
        Document document = this.domElement.getOwnerDocument();
        NodeList nodes = this.domElement.getChildNodes();
        int position = 0;
        int n = nodes.getLength();
        while (position < n) {
            Node child = nodes.item(position);
            if (child.getNodeType() != 8 && child.getNodeType() != 3) break;
            ++position;
        }
        Node refChild = position < nodes.getLength() ? nodes.item(position) : null;
        int prevPosition = position - 1;
        Node node = prevChild = prevPosition < nodes.getLength() ? nodes.item(prevPosition) : null;
        if (prevChild != null && prevChild.getNodeType() == 3 && prevChild.getNodeValue().trim().length() == 0) {
            refChild = prevChild;
            position = prevPosition;
        }
        prevChild = (prevPosition = position - 1) < nodes.getLength() ? nodes.item(prevPosition) : null;
        Comment comment = document.createComment(commentText);
        this.domElement.insertBefore(comment, refChild);
        XmlComment wrappedComment = new XmlComment(comment, this.getModelStoreForXml());
        if (this.domElement.getNodeType() == 1 && this.domElement.getChildNodes().getLength() == 1) {
            this.format();
        } else {
            wrappedComment.format();
        }
        return wrappedComment;
    }

    public XmlMetaComment getMetaComment(String name, boolean createIfNecessary) {
        String prefix = String.valueOf(name) + ":";
        NodeList children = this.domElement.getChildNodes();
        Comment xmlMetaComment = null;
        int i = 0;
        int n = children.getLength();
        while (i < n) {
            Comment comment;
            Node child = children.item(i);
            if (child.getNodeType() == 8 && (comment = (Comment)child).getNodeValue().trim().startsWith(prefix)) {
                xmlMetaComment = comment;
            }
            ++i;
        }
        if (xmlMetaComment == null && createIfNecessary) {
            xmlMetaComment = this.addComment(prefix).getDomComment();
        }
        if (xmlMetaComment == null) {
            return null;
        }
        return new XmlMetaComment(xmlMetaComment, this.getModelStoreForXml());
    }

    public String getMetaCommentText(String name) {
        XmlMetaComment comment = this.getMetaComment(name, false);
        if (comment != null) {
            return comment.getText();
        }
        return null;
    }

    public void setMetaCommentText(String name, String value) {
        if (value != null && value.length() == 0) {
            value = null;
        }
        XmlMetaComment comment = this.getMetaComment(name, true);
        if (value != null) {
            comment.setText(value);
        } else {
            comment.remove();
        }
    }

    private XmlPath.Segment resolveXmlPathSegment(XmlPath.Segment pathSegment) {
        String namespace = pathSegment.getQualifiedName().getNamespaceURI();
        if (pathSegment.isAttribute() || pathSegment.isComment() || namespace.length() != 0) {
            return pathSegment;
        }
        String prefix = pathSegment.getQualifiedName().getPrefix();
        if (prefix.length() == 0) {
            namespace = this.domElement.getNamespaceURI();
        }
        QName newQualifiedName = new QName(namespace, pathSegment.getQualifiedName().getLocalPart(), prefix);
        return new XmlPath.Segment(newQualifiedName, false, false);
    }

    private QName createQualifiedName(String localName) {
        String namespace = this.domElement.getNamespaceURI();
        return new QName(namespace, localName);
    }

    private static final boolean equal(Object obj1, Object obj2) {
        boolean objectsAreEqual = false;
        if (obj1 == obj2) {
            objectsAreEqual = true;
        } else if (obj1 != null && obj2 != null) {
            objectsAreEqual = obj1.equals(obj2);
        }
        return objectsAreEqual;
    }

    private static final String normalizeToNull(String str) {
        if (str != null && str.equals("")) {
            return null;
        }
        return str;
    }
}

