/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.IHandler;
import org.eclipse.sapphire.ui.util.internal.MutableReference;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;

public final class SapphireCommands {
    public static final String CONTEXT_PROPERTY_EDITOR = "sapphire.property.editor";
    public static final String CONTEXT_CONTENT_OUTLINE = "sapphire.content.outline";
    public static final String COMMAND_BROWSE = "sapphire.browse";
    public static final String COMMAND_SHOW_ASSIST = "sapphire.show.assist";
    public static final String COMMAND_JUMP = "sapphire.jump";
    public static final String COMMAND_MOVE_UP = "sapphire.move.up";
    public static final String COMMAND_MOVE_DOWN = "sapphire.move.down";
    private static final Map<String, IContextActivation> CONTEXTS = new HashMap<String, IContextActivation>();
    private static final Map<String, IHandlerActivation> HANDLERS = new HashMap<String, IHandlerActivation>();

    public static void configurePropertyEditorContext(Control control) {
        SapphireCommands.configureContext(control, CONTEXT_PROPERTY_EDITOR);
    }

    public static void configureContentOutlineContext(Control control) {
        SapphireCommands.configureContext(control, CONTEXT_CONTENT_OUTLINE);
    }

    private static void configureContext(Control control, final String contextId) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        final IContextService contextService = (IContextService)workbench.getService(IContextService.class);
        final MutableReference contextActivationRef = new MutableReference();
        control.addListener(26, new Listener(){

            public void handleEvent(Event event) {
                IContextActivation existingContextActivation = (IContextActivation)CONTEXTS.get(contextId);
                if (existingContextActivation != null) {
                    contextService.deactivateContext(existingContextActivation);
                }
                IContextActivation contextActivation = contextService.activateContext(contextId);
                contextActivationRef.set(contextActivation);
                CONTEXTS.put(contextId, contextActivation);
            }
        });
        final Runnable deactivateContextOperation = new Runnable(){

            public void run() {
                IContextActivation contextActivation = (IContextActivation)contextActivationRef.get();
                if (contextActivation != null) {
                    contextService.deactivateContext(contextActivation);
                    if (CONTEXTS.get(contextId) == contextActivation) {
                        CONTEXTS.remove(contextId);
                    }
                }
            }
        };
        control.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                deactivateContextOperation.run();
            }
        });
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                deactivateContextOperation.run();
            }
        });
    }

    public static void attachBrowseHandler(Control control, IHandler handler) {
        SapphireCommands.attachHandler(control, COMMAND_BROWSE, handler);
    }

    public static void attachShowAssistHandler(Control control, IHandler handler) {
        SapphireCommands.attachHandler(control, COMMAND_SHOW_ASSIST, handler);
    }

    public static void attachJumpHandler(Control control, IHandler handler) {
        SapphireCommands.attachHandler(control, COMMAND_JUMP, handler);
    }

    private static void attachHandler(Control control, final String commandId, final IHandler handler) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        final IHandlerService handlerService = (IHandlerService)workbench.getService(IHandlerService.class);
        final MutableReference handlerActivationRef = new MutableReference();
        control.addListener(26, new Listener(){

            public void handleEvent(Event event) {
                IHandlerActivation existingHandler = (IHandlerActivation)HANDLERS.get(commandId);
                if (existingHandler != null) {
                    handlerService.deactivateHandler(existingHandler);
                }
                IHandlerActivation handlerActivation = handlerService.activateHandler(commandId, handler);
                handlerActivationRef.set(handlerActivation);
                HANDLERS.put(commandId, handlerActivation);
            }
        });
        final Runnable deactivateHandlerOperation = new Runnable(){

            public void run() {
                IHandlerActivation handlerActivation = (IHandlerActivation)handlerActivationRef.get();
                if (handlerActivation != null) {
                    handlerService.deactivateHandler(handlerActivation);
                    if (HANDLERS.get(commandId) == handlerActivation) {
                        HANDLERS.remove(commandId);
                    }
                }
            }
        };
        control.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                deactivateHandlerOperation.run();
            }
        });
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                deactivateHandlerOperation.run();
            }
        });
    }
}

