/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.sapphire.modeling.IModel;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelStore;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.xml.IModelElementForXml;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlNode;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.SapphireEditor;
import org.eclipse.sapphire.ui.SapphireImageCache;
import org.eclipse.sapphire.ui.SapphirePartListener;
import org.eclipse.sapphire.ui.actions.Action;
import org.eclipse.sapphire.ui.xml.ModelStoreForXmlEditor;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SapphireEditorFormPage
extends FormPage
implements ISapphirePart {
    private final SapphireEditor editor;
    private final IModelElement rootModelElement;

    public SapphireEditorFormPage(SapphireEditor editor, IModelElement rootModelElement) {
        super((FormEditor)editor, null, null);
        this.editor = editor;
        this.rootModelElement = rootModelElement;
    }

    public SapphireEditor getEditor() {
        return this.editor;
    }

    public IModelElement getRootModelElement() {
        return this.rootModelElement;
    }

    public abstract String getId();

    public IModel getModel() {
        return this.editor.getModel();
    }

    public final Preferences getGlobalPreferences(boolean createIfNecessary) throws BackingStoreException {
        Preferences prefs = this.editor.getGlobalPreferences(createIfNecessary);
        String pageName = this.getPartName();
        if (prefs != null && (prefs.nodeExists(pageName) || createIfNecessary)) {
            return prefs.node(pageName);
        }
        return null;
    }

    public final Preferences getInstancePreferences(boolean createIfNecessary) throws BackingStoreException {
        Preferences prefs = this.editor.getInstancePreferences(createIfNecessary);
        String pageName = this.getPartName();
        if (prefs != null && (prefs.nodeExists(pageName) || createIfNecessary)) {
            return prefs.node(pageName);
        }
        return null;
    }

    public ITextEditor getSourceView() {
        ModelStore modelStore = this.rootModelElement.getModel().getModelStore();
        if (modelStore instanceof ModelStoreForXmlEditor) {
            return ((ModelStoreForXmlEditor)modelStore).getXmlEditor();
        }
        return null;
    }

    public void showInSourceView(IModelElement element, ModelProperty property) {
        ITextEditor sourceView = this.getSourceView();
        if (sourceView != null) {
            List<XmlNode> xmlNodes;
            Range range = new Range();
            if (property != null && !(xmlNodes = SapphireEditorFormPage.getXmlNodes((IModelElementForXml)element, property)).isEmpty()) {
                if (property instanceof ValueProperty) {
                    IDOMNode domNode = (IDOMNode)xmlNodes.get(0).getDomNode();
                    if (domNode instanceof IDOMElement) {
                        IDOMElement domElement = (IDOMElement)domNode;
                        if (domElement.hasEndTag()) {
                            range.merge(domElement.getStartEndOffset(), domElement.getEndStartOffset());
                        }
                    } else if (domNode instanceof IDOMAttr) {
                        IDOMAttr domAttr = (IDOMAttr)domNode;
                        int start = domAttr.getValueRegionStartOffset();
                        range.merge(start + 1, start + domAttr.getValueRegionText().length() - 1);
                    } else {
                        range.merge(domNode.getStartOffset(), domNode.getEndOffset());
                    }
                } else {
                    for (XmlNode xmlNode : xmlNodes) {
                        IDOMNode domNode = (IDOMNode)xmlNode.getDomNode();
                        range.merge(domNode.getStartOffset(), domNode.getEndOffset());
                    }
                }
            }
            if (!range.isInitialized()) {
                IModelElementForXml modElement = (IModelElementForXml)element;
                XmlElement xmlElement = modElement.getXmlElement();
                while (xmlElement == null && modElement != null) {
                    if ((modElement = (IModelElementForXml)modElement.getParent()) == null) continue;
                    xmlElement = modElement.getXmlElement();
                }
                if (xmlElement != null) {
                    IDOMNode domNode = (IDOMNode)xmlElement.getDomNode();
                    range.merge(domNode.getStartOffset(), domNode.getEndOffset());
                }
            }
            sourceView.getSelectionProvider().setSelection((ISelection)range.toTextSelection());
            this.getEditor().showPage(sourceView);
        }
    }

    public boolean isOptimalConversionPossible(IModelElement element, ModelProperty property) {
        return element != null && (property != null ? !SapphireEditorFormPage.getXmlNodes((IModelElementForXml)element, property).isEmpty() : ((IModelElementForXml)element).getXmlElement() != null);
    }

    private static List<XmlNode> getXmlNodes(IModelElementForXml modelElement, ModelProperty property) {
        if (property instanceof ListProperty) {
            ModelElementList list = (ModelElementList)property.invokeGetterMethod((Object)modelElement);
            ArrayList<XmlNode> xmlNodes = new ArrayList<XmlNode>();
            for (IModelElement element : list) {
                XmlElement xmlNode;
                if (!(element instanceof IModelElementForXml) || (xmlNode = ((IModelElementForXml)element).getXmlElement()) == null) continue;
                xmlNodes.add((XmlNode)xmlNode);
            }
            return xmlNodes;
        }
        XmlNode xmlNode = modelElement.getXmlNode(property);
        if (xmlNode != null) {
            return Collections.singletonList(xmlNode);
        }
        return Collections.emptyList();
    }

    @Override
    public ISapphirePart getParentPart() {
        return this.editor;
    }

    @Override
    public final <T> T getNearestPart(Class<T> partType) {
        if (partType.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        if (this.editor != null) {
            return this.editor.getNearestPart(partType);
        }
        return null;
    }

    @Override
    public IModelElement getModelElement() {
        return this.rootModelElement;
    }

    @Override
    public Action getAction(String id) {
        if (this.editor != null) {
            return this.editor.getAction(id);
        }
        return null;
    }

    @Override
    public IStatus getValidationState() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getHelpContextId() {
        return null;
    }

    @Override
    public SapphireImageCache getImageCache() {
        return this.editor.getImageCache();
    }

    public void collectAllReferencedProperties(Set<ModelProperty> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addListener(SapphirePartListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeListener(SapphirePartListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dispose() {
    }

    private static final class Range {
        private boolean initialized = false;
        private int start;
        private int end;

        public boolean isInitialized() {
            return this.initialized;
        }

        public void merge(int start, int end) {
            if (this.initialized) {
                this.start = start < this.start ? start : this.start;
                this.end = end > this.end ? end : this.end;
            } else {
                this.start = start;
                this.end = end;
                this.initialized = true;
            }
        }

        public TextSelection toTextSelection() {
            return this.initialized ? new TextSelection(this.start, this.end - this.start) : null;
        }
    }
}

