/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.ui.SapphirePageBook;
import org.eclipse.sapphire.ui.SapphirePropertyEditor;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ISapphirePageBookExtDef;
import org.eclipse.sapphire.ui.def.ISapphireUiDef;
import org.eclipse.sapphire.ui.util.internal.MutableReference;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;

public final class SapphireListControlledPageBook
extends SapphirePageBook {
    private ListProperty property;

    protected void init() {
        super.init();
        this.property = (ListProperty)this.resolve((String)((ISapphirePageBookExtDef)this.definition).getControlProperty().getContent());
    }

    protected Object parsePageKey(String pageKeyString) {
        ISapphireUiDef rootdef = (ISapphireUiDef)this.definition.getModel();
        Class<?> cl = rootdef.resolveClass(pageKeyString);
        return SapphirePageBook.ClassBasedKey.create(cl);
    }

    public void render(SapphireRenderingContext context) {
        super.render(context);
        Table table = SapphirePropertyEditor.findControlForProperty((Control)context.getComposite(), (ModelProperty)this.property, Table.class);
        ISelectionProvider selectionProvider = (ISelectionProvider)table.getData("selection.provider");
        final MutableReference selectedModelElementRef = new MutableReference();
        selectionProvider.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SapphirePageBook.ClassBasedKey newPageKey;
                IModelElement newModelElement;
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (!sel.isEmpty()) {
                    newModelElement = (IModelElement)sel.getFirstElement();
                    newPageKey = SapphirePageBook.ClassBasedKey.create(newModelElement);
                } else {
                    newModelElement = SapphireListControlledPageBook.this.getModelElement();
                    newPageKey = null;
                }
                if (selectedModelElementRef.get() != newModelElement) {
                    selectedModelElementRef.set(newModelElement);
                    Runnable inputChangeOperation = new Runnable(){

                        public void run() {
                            SapphireListControlledPageBook.this.changePage(newModelElement, newPageKey);
                        }
                    };
                    Display.getDefault().syncExec(inputChangeOperation);
                }
            }
        });
        this.changePage(this.getModelElement(), (Object)null);
    }
}

