/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.ui.SapphireComposite;
import org.eclipse.sapphire.ui.SapphirePageBookListener;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphirePartListener;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ISapphireCompositeDef;
import org.eclipse.sapphire.ui.def.ISapphirePageBookDef;
import org.eclipse.sapphire.ui.def.ISapphirePageBookKeyMapping;
import org.eclipse.sapphire.ui.util.SwtUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class SapphirePageBook
extends SapphirePart {
    private Map<Object, ISapphireCompositeDef> pageDefs;
    private ISapphireCompositeDef defaultPageDef;
    private SapphireComposite currentPage;
    private boolean exposePageValidationState = false;
    private SapphirePartListener childPartListener = null;

    protected void init() {
        super.init();
        ISapphirePageBookDef def = (ISapphirePageBookDef)this.definition;
        this.pageDefs = new HashMap<Object, ISapphireCompositeDef>();
        for (ISapphirePageBookKeyMapping page : def.getPages()) {
            Object key = this.parsePageKey(page.getKey().getText());
            this.pageDefs.put(key, page);
        }
        this.defaultPageDef = def.getDefaultPage();
    }

    public void render(final SapphireRenderingContext context) {
        final Composite composite = new Composite(context.getComposite(), 0);
        composite.setLayoutData((Object)SwtUtil.hspan(SwtUtil.gdhfill(), 2));
        composite.setLayout((Layout)SwtUtil.glayout(2, 0, 0));
        context.adapt((Control)composite);
        final SapphirePageBookListener pageChangeListener = new SapphirePageBookListener(){

            public void handlePageChange() {
                Control[] controlArray = composite.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control control = controlArray[n2];
                    control.dispose();
                    ++n2;
                }
                if (SapphirePageBook.this.currentPage != null) {
                    SapphirePageBook.this.currentPage.render(new SapphireRenderingContext(SapphirePageBook.this, context, composite));
                }
                context.layout();
            }
        };
        this.addListener(pageChangeListener);
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                SapphirePageBook.this.removeListener(pageChangeListener);
            }
        });
        if (this.currentPage != null) {
            this.currentPage.render(new SapphireRenderingContext(this, context, composite));
        }
    }

    public final SapphireComposite getCurrentPage() {
        return this.currentPage;
    }

    protected final void changePage(IModelElement modelElementForPage, Object pageKey) {
        ISapphireCompositeDef pageDef = this.defaultPageDef;
        for (Map.Entry<Object, ISapphireCompositeDef> entry : this.pageDefs.entrySet()) {
            if (!entry.getKey().equals(pageKey)) continue;
            pageDef = entry.getValue();
            break;
        }
        this.changePage(modelElementForPage, pageDef);
    }

    protected final void changePage(IModelElement modelElementForPage, ISapphireCompositeDef pageDef) {
        if (modelElementForPage == null) {
            throw new IllegalArgumentException();
        }
        if (this.currentPage != null) {
            this.currentPage.dispose();
        }
        if (pageDef != null) {
            this.currentPage = (SapphireComposite)SapphirePageBook.create(this, modelElementForPage, pageDef, this.params);
            if (this.childPartListener != null) {
                this.currentPage.addListener(this.childPartListener);
            }
        } else {
            this.currentPage = null;
        }
        this.updateValidationState();
        for (SapphirePartListener listener : this.getListeners()) {
            if (!(listener instanceof SapphirePageBookListener)) continue;
            ((SapphirePageBookListener)listener).handlePageChange();
        }
    }

    protected abstract Object parsePageKey(String var1);

    protected IStatus computeValidationState() {
        SapphireComposite currentPage;
        if (this.exposePageValidationState && (currentPage = this.getCurrentPage()) != null) {
            return currentPage.getValidationState();
        }
        return Status.OK_STATUS;
    }

    protected final void setExposePageValidationState(boolean exposePageValidationState) {
        if (this.exposePageValidationState != exposePageValidationState) {
            this.exposePageValidationState = exposePageValidationState;
            if (this.exposePageValidationState) {
                this.childPartListener = new SapphirePartListener(){

                    public void handleValidateStateChange(IStatus oldValidateState, IStatus newValidationState) {
                        SapphirePageBook.this.updateValidationState();
                    }
                };
                if (this.currentPage != null) {
                    this.currentPage.addListener(this.childPartListener);
                }
            } else {
                this.childPartListener = null;
            }
            this.updateValidationState();
        }
    }

    public void dispose() {
        super.dispose();
        if (this.currentPage != null) {
            this.currentPage.dispose();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class ClassBasedKey {
        private final Class<?> cl;

        private ClassBasedKey(Class<?> cl) {
            this.cl = cl;
        }

        public static ClassBasedKey create(Class<?> cl) {
            return cl == null ? null : new ClassBasedKey(cl);
        }

        public static ClassBasedKey create(Object obj) {
            return obj == null ? null : new ClassBasedKey(obj.getClass());
        }

        public int hashCode() {
            return this.cl == null ? -1 : this.cl.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ClassBasedKey)) {
                return false;
            }
            Class<?> cl2 = ((ClassBasedKey)obj).cl;
            return this.cl.isAssignableFrom(cl2) || cl2.isAssignableFrom(this.cl);
        }
    }
}

