/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.ui.SapphireImageCache;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;

public class SapphireRenderingContext {
    private final SapphirePart part;
    private final SapphireRenderingContext parent;
    protected Composite composite;
    private String helpContextIdPrefix;

    public SapphireRenderingContext(SapphirePart part, Composite composite) {
        this(part, null, composite);
    }

    public SapphireRenderingContext(SapphirePart part, SapphireRenderingContext parent, Composite composite) {
        this.part = part;
        this.parent = parent;
        this.composite = composite;
        this.helpContextIdPrefix = null;
    }

    public SapphirePart getPart() {
        return this.part;
    }

    public final SapphireImageCache getImageCache() {
        return this.getPart().getImageCache();
    }

    public Shell getShell() {
        return this.composite.getShell();
    }

    public Display getDisplay() {
        return this.composite.getDisplay();
    }

    public Composite getComposite() {
        return this.composite;
    }

    public void layout() {
        Composite composite = this.composite;
        while (composite != null) {
            if (composite instanceof SharedScrolledComposite) {
                composite.getShell().layout(true, true);
                ((SharedScrolledComposite)composite).reflow(true);
                return;
            }
            if (composite instanceof Shell) {
                composite.layout(true, true);
                return;
            }
            composite = composite.getParent();
        }
    }

    public void adapt(Control control) {
        if (this.parent != null) {
            this.parent.adapt(control);
        }
    }

    public final void setHelp(Control control, IModelElement modelElement, ModelProperty property) {
        String prefix = this.getHelpContextIdPrefix();
        if (prefix != null) {
            String helpContextId = null;
            ModelProperty p = property;
            while (p != null) {
                StringBuilder buf = new StringBuilder();
                buf.append(prefix);
                buf.append(this.getUnqualifiedTypeName(p.getModelElementType()));
                buf.append('-');
                buf.append(property.getName());
                IContext context = HelpSystem.getContext((String)buf.toString());
                if (context != null) {
                    helpContextId = buf.toString();
                    break;
                }
                p = p.getBase();
            }
            if (helpContextId == null) {
                ModelElementType type = ModelElementType.getModelElementType(modelElement.getClass());
                StringBuilder buf = new StringBuilder();
                buf.append(prefix);
                buf.append(this.getUnqualifiedTypeName(type));
                IContext context = HelpSystem.getContext((String)buf.toString());
                if (context != null) {
                    helpContextId = buf.toString();
                }
            }
            if (helpContextId != null) {
                PlatformUI.getWorkbench().getHelpSystem().setHelp(control, helpContextId);
            }
        }
    }

    protected String getHelpContextIdPrefix() {
        if (this.helpContextIdPrefix != null) {
            return this.helpContextIdPrefix;
        }
        if (this.parent != null) {
            return this.parent.getHelpContextIdPrefix();
        }
        return null;
    }

    public void setHelpContextIdPrefix(String helpContextIdPrefix) {
        this.helpContextIdPrefix = helpContextIdPrefix;
    }

    private String getUnqualifiedTypeName(ModelElementType type) {
        String className = type.getModelElementClass().getName();
        int lastDot = className.lastIndexOf(46);
        return lastDot == -1 ? className : className.substring(lastDot + 1);
    }
}

