/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.actions;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IRemovable;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.SapphireComposite;
import org.eclipse.sapphire.ui.SapphireElementPropertyComposite;
import org.eclipse.sapphire.ui.SapphireEnumControlledPageBook;
import org.eclipse.sapphire.ui.SapphireIfElseDirective;
import org.eclipse.sapphire.ui.SapphireImageCache;
import org.eclipse.sapphire.ui.SapphirePartContainer;
import org.eclipse.sapphire.ui.SapphirePropertyEditor;
import org.eclipse.sapphire.ui.actions.Action;
import org.eclipse.sapphire.ui.util.SwtUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestoreDefaultsAction
extends Action {
    public static final String ACTION_ID = "section:restore-defaults";

    public RestoreDefaultsAction() {
        this.setId(ACTION_ID);
        this.setLabel(Resources.actionLabel);
        this.setImageDescriptor(SapphireImageCache.ACTION_RESTORE_DEFAULTS);
    }

    @Override
    public boolean isVisible() {
        HashSet<PropertyRef> properties = new HashSet<PropertyRef>();
        RestoreDefaultsAction.collectProperties(this.getPart(), properties);
        return !properties.isEmpty();
    }

    @Override
    public void setVisible(boolean visible) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected final Object run(Shell shell) {
        ISapphirePart part = this.getPart();
        LinkedHashSet<PropertyRef> properties = new LinkedHashSet<PropertyRef>();
        RestoreDefaultsAction.collectProperties(part, properties);
        Iterator itr = properties.iterator();
        while (itr.hasNext()) {
            PropertyRef pref = (PropertyRef)itr.next();
            if (pref.property instanceof ValueProperty) {
                Value value = (Value)pref.property.invokeGetterMethod((Object)pref.modelElement);
                if (!value.isDefault()) continue;
                itr.remove();
                continue;
            }
            if (pref.property instanceof ListProperty) {
                ModelElementList list = (ModelElementList)pref.property.invokeGetterMethod((Object)pref.modelElement);
                if (!list.isEmpty()) continue;
                itr.remove();
                continue;
            }
            IModelElement child = (IModelElement)pref.property.invokeGetterMethod((Object)pref.modelElement);
            if (child != null && child instanceof IRemovable) continue;
            itr.remove();
        }
        if (properties.isEmpty()) {
            MessageDialog.openInformation((Shell)shell, (String)Resources.dialogTitle, (String)Resources.nothingToDoMessage);
        } else {
            Set selectedProperties = PromptDialog.open(shell, properties);
            for (PropertyRef pref : selectedProperties) {
                if (pref.property instanceof ValueProperty) {
                    ((ValueProperty)pref.property).invokeSetterMethod((Object)pref.modelElement, null);
                    continue;
                }
                if (pref.property instanceof ListProperty) {
                    for (Object item : (List)pref.property.invokeGetterMethod((Object)pref.modelElement)) {
                        ((IRemovable)item).remove();
                    }
                    continue;
                }
                if (!(pref.property instanceof ElementProperty)) continue;
                IModelElement child = (IModelElement)pref.property.invokeGetterMethod((Object)pref.modelElement);
                ((IRemovable)child).remove();
            }
        }
        return null;
    }

    private static void collectProperties(ISapphirePart part, Set<PropertyRef> result) {
        block7: {
            block9: {
                block8: {
                    block6: {
                        if (!(part instanceof SapphirePartContainer)) break block6;
                        for (ISapphirePart iSapphirePart : ((SapphirePartContainer)part).getChildParts()) {
                            RestoreDefaultsAction.collectProperties(iSapphirePart, result);
                        }
                        break block7;
                    }
                    if (!(part instanceof SapphireElementPropertyComposite)) break block8;
                    result.add(new PropertyRef(part.getModelElement(), (ModelProperty)((SapphireElementPropertyComposite)part).getConditionalProperty()));
                    break block7;
                }
                if (!(part instanceof SapphireEnumControlledPageBook)) break block9;
                SapphireComposite sapphireComposite = ((SapphireEnumControlledPageBook)part).getCurrentPage();
                if (sapphireComposite == null) break block7;
                RestoreDefaultsAction.collectProperties(sapphireComposite, result);
                break block7;
            }
            if (part instanceof SapphirePropertyEditor) {
                SapphirePropertyEditor sapphirePropertyEditor = (SapphirePropertyEditor)part;
                result.add(new PropertyRef(sapphirePropertyEditor.getModelElement(), sapphirePropertyEditor.getProperty()));
                for (SapphirePropertyEditor sapphirePropertyEditor2 : sapphirePropertyEditor.getAuxPropertyEditors()) {
                    RestoreDefaultsAction.collectProperties(sapphirePropertyEditor2, result);
                }
            } else if (part instanceof SapphireIfElseDirective) {
                SapphireIfElseDirective sapphireIfElseDirective = (SapphireIfElseDirective)part;
                for (ISapphirePart iSapphirePart : sapphireIfElseDirective.getConditionState() ? sapphireIfElseDirective.getThenContent() : sapphireIfElseDirective.getElseContent()) {
                    RestoreDefaultsAction.collectProperties(iSapphirePart, result);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PromptDialog
    extends Dialog {
        private final Set<PropertyRef> allProperties;
        private final Set<PropertyRef> selectedProperties;

        private static Set<PropertyRef> open(Shell shell, Set<PropertyRef> properties) {
            PromptDialog dialog = new PromptDialog(shell, properties);
            if (dialog.open() == 0) {
                return dialog.selectedProperties;
            }
            return Collections.emptySet();
        }

        private PromptDialog(Shell shell, Set<PropertyRef> properties) {
            super(shell);
            this.allProperties = properties;
            this.selectedProperties = new HashSet<PropertyRef>(this.allProperties);
        }

        protected boolean isResizable() {
            return true;
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText(Resources.dialogTitle);
            Composite composite = (Composite)super.createDialogArea(parent);
            Label messageLabel = new Label(composite, 64);
            messageLabel.setText(Resources.dialogMessage);
            messageLabel.setLayoutData((Object)SwtUtil.gdwhint(SwtUtil.gdhfill(), 300));
            CheckboxTableViewer tableViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
            Table table = tableViewer.getTable();
            table.setLayoutData((Object)SwtUtil.gdhhint(SwtUtil.gdwhint(SwtUtil.gdfill(), 300), 300));
            tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public Object[] getElements(Object inputElement) {
                    return PromptDialog.this.allProperties.toArray();
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public void dispose() {
                }
            });
            tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

                public String getColumnText(Object element, int columnIndex) {
                    ModelProperty property = ((PropertyRef)element).property;
                    return property.getLabel(true, CapitalizationType.FIRST_WORD_ONLY, false);
                }

                public Image getColumnImage(Object element, int columnIndex) {
                    return null;
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public void removeListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }
            });
            tableViewer.setCheckStateProvider(new ICheckStateProvider(){

                public boolean isChecked(Object element) {
                    return PromptDialog.this.selectedProperties.contains(element);
                }

                public boolean isGrayed(Object element) {
                    return false;
                }
            });
            tableViewer.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    PropertyRef property = (PropertyRef)event.getElement();
                    if (event.getChecked()) {
                        PromptDialog.this.selectedProperties.add(property);
                    } else {
                        PromptDialog.this.selectedProperties.remove(property);
                    }
                }
            });
            tableViewer.setInput((Object)this);
            return composite;
        }
    }

    private static final class PropertyRef {
        public final IModelElement modelElement;
        public final ModelProperty property;

        public PropertyRef(IModelElement modelElement, ModelProperty property) {
            this.modelElement = modelElement;
            this.property = property;
        }
    }

    private static final class Resources
    extends NLS {
        public static String actionLabel;
        public static String dialogTitle;
        public static String dialogMessage;
        public static String nothingToDoMessage;

        static {
            Resources.initializeMessages((String)RestoreDefaultsAction.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

