/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.assist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.util.internal.PluginUtil;
import org.eclipse.sapphire.ui.assist.BrowseHandler;
import org.eclipse.sapphire.ui.assist.BrowseHandlerFactory;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BrowseHandlersExtensionPoint {
    private static final String EL_BROWSE_HANDLER = "browse-handler";
    private static final String ATTR_FACTORY = "factory";
    private static final Comparator<BrowseHandlerFactory> COMPARATOR = new Comparator<BrowseHandlerFactory>(){

        @Override
        public int compare(BrowseHandlerFactory x, BrowseHandlerFactory y) {
            int res = x.getPriority() - y.getPriority();
            if (res == 0) {
                res = x.getClass().getName().compareTo(y.getClass().getName());
            }
            return res;
        }
    };
    private static List<BrowseHandlerFactory> browseHandlerFactories = null;

    public static List<BrowseHandler> getBrowseHandlers(ValueProperty property) {
        BrowseHandlersExtensionPoint.initialize();
        ArrayList<BrowseHandlerFactory> applicableBrowseHandlerFactories = new ArrayList<BrowseHandlerFactory>();
        for (BrowseHandlerFactory browseHandlerFactory : browseHandlerFactories) {
            try {
                if (!browseHandlerFactory.isApplicable(property)) continue;
                applicableBrowseHandlerFactories.add(browseHandlerFactory);
            }
            catch (Exception e) {
                SapphireUiFrameworkPlugin.log(e);
            }
        }
        Collections.sort(applicableBrowseHandlerFactories, COMPARATOR);
        ArrayList<BrowseHandler> applicableBrowseHandlers = new ArrayList<BrowseHandler>();
        for (BrowseHandlerFactory browseHandlerFactory : applicableBrowseHandlerFactories) {
            try {
                applicableBrowseHandlers.add(browseHandlerFactory.create());
            }
            catch (Exception e) {
                SapphireUiFrameworkPlugin.log(e);
            }
        }
        return applicableBrowseHandlers;
    }

    private static synchronized void initialize() {
        if (browseHandlerFactories == null) {
            browseHandlerFactories = new ArrayList<BrowseHandlerFactory>();
            for (IConfigurationElement el : PluginUtil.getTopLevelElements((Collection)PluginUtil.findExtensions((String)"org.eclipse.sapphire.ui", (String)"browseHandlers"))) {
                String pluginId = el.getNamespaceIdentifier();
                if (!el.getName().equals(EL_BROWSE_HANDLER)) continue;
                try {
                    String clname = PluginUtil.findRequiredAttribute((IConfigurationElement)el, (String)ATTR_FACTORY);
                    BrowseHandlerFactory browseHandlerFactory = (BrowseHandlerFactory)PluginUtil.instantiate((String)pluginId, (String)clname, BrowseHandlerFactory.class);
                    if (browseHandlerFactory == null) continue;
                    browseHandlerFactories.add(browseHandlerFactory);
                }
                catch (PluginUtil.InvalidExtensionException invalidExtensionException) {}
            }
        }
    }
}

