/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.assist.internal;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.EnumValueType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.LabelTransformer;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueKeyword;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.NamedValues;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContext;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContribution;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContributor;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistSection;

public final class DefaultValueInfoAssistContributor
extends PropertyEditorAssistContributor {
    public DefaultValueInfoAssistContributor() {
        this.setId("System.DefaultValueContributor");
        this.setPriority(110);
    }

    public void contribute(PropertyEditorAssistContext context) {
        IModelElement element = context.getModelElement();
        ModelProperty property = context.getProperty();
        if (property instanceof ValueProperty && ((Value)property.invokeGetterMethod((Object)element)).getText(false) != null) {
            ValueProperty valprop = (ValueProperty)property;
            String defaultValue = element.service().getDefaultValue(valprop);
            if (defaultValue != null) {
                if (property.isOfType(Enum.class)) {
                    EnumValueType enumValueType = new EnumValueType(property.getTypeClass());
                    Enum[] enumArray = enumValueType.getItems();
                    int n = enumArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Enum item = enumArray[n2];
                        if (item.toString().equals(defaultValue)) {
                            defaultValue = enumValueType.getLabel(item, true, CapitalizationType.NO_CAPS, false);
                            break;
                        }
                        ++n2;
                    }
                } else {
                    ValueKeyword keyword = valprop.getKeyword(defaultValue);
                    if (keyword != null) {
                        defaultValue = keyword.toDisplayString();
                    } else if (property.hasAnnotation(NamedValues.class)) {
                        NamedValues namedValuesAnnotation = (NamedValues)property.getAnnotation(NamedValues.class);
                        NamedValues.NamedValue[] namedValueAnnotations = namedValuesAnnotation.namedValues();
                        String propName = property.getName();
                        int i = 0;
                        int n = namedValueAnnotations.length;
                        while (i < n) {
                            NamedValues.NamedValue x = namedValueAnnotations[i];
                            if (defaultValue.equals(x.value())) {
                                String namedValueLabel = property.getResource(String.valueOf(propName) + ".namedValue." + x.value());
                                namedValueLabel = LabelTransformer.transform((String)namedValueLabel, (CapitalizationType)CapitalizationType.NO_CAPS, (boolean)true);
                                defaultValue = String.valueOf(namedValueLabel) + " (" + x.value() + ")";
                                break;
                            }
                            ++i;
                        }
                    }
                }
                if (!(property.isOfType(Integer.class) || property.isOfType(Long.class) || property.isOfType(Float.class) || property.isOfType(Double.class) || property.isOfType(BigInteger.class) || property.isOfType(BigDecimal.class) || property.isOfType(Boolean.class))) {
                    defaultValue = "\"" + defaultValue + "\"";
                }
                String label = NLS.bind((String)Resources.defaultValueInfoMessage, (Object)defaultValue);
                label = "<p>" + DefaultValueInfoAssistContributor.escapeForXml(label) + "</p>";
                PropertyEditorAssistContribution contribution = new PropertyEditorAssistContribution();
                contribution.setText(label);
                PropertyEditorAssistSection section = context.getSection("info");
                section.addContribution(contribution);
            }
        }
    }

    private static final class Resources
    extends NLS {
        public static String defaultValueInfoMessage;

        static {
            Resources.initializeMessages((String)DefaultValueInfoAssistContributor.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

