/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.assist.internal;

import java.util.Map;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.sapphire.modeling.EditFailedException;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContext;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContribution;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistSection;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class PropertyEditorAssistDialog
extends PopupDialog {
    private final Point position;
    private final PropertyEditorAssistContext context;
    private final FormToolkit toolkit;
    private Composite composite;

    public PropertyEditorAssistDialog(Shell shell, Point point, PropertyEditorAssistContext context) {
        super(shell, 4, true, true, false, false, false, null, null);
        this.position = point;
        this.toolkit = new FormToolkit(Display.getDefault());
        this.context = context;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
    }

    protected Control createContents(Composite parent) {
        this.initializeBounds();
        return this.createDialogArea(parent);
    }

    protected Control createDialogArea(Composite parent) {
        this.composite = (Composite)super.createDialogArea(parent);
        Color bgcolor = this.getShell().getDisplay().getSystemColor(29);
        ScrolledForm form = this.toolkit.createScrolledForm(this.composite);
        form.setBackground(bgcolor);
        TableWrapLayout layout = new TableWrapLayout();
        layout.leftMargin = 10;
        layout.rightMargin = 10;
        layout.topMargin = 10;
        layout.verticalSpacing = 10;
        form.getBody().setLayout((Layout)layout);
        for (PropertyEditorAssistSection secdef : this.context.getSections().values()) {
            if (secdef.getContributions().isEmpty()) continue;
            Section section = this.toolkit.createSection(form.getBody(), 64);
            this.toolkit.createCompositeSeparator((Composite)section);
            section.setBackground(bgcolor);
            section.clientVerticalSpacing = 9;
            section.setText(secdef.getLabel());
            TableWrapData td = new TableWrapData();
            td.align = 128;
            td.grabHorizontal = true;
            section.setLayoutData((Object)td);
            Composite composite = this.toolkit.createComposite((Composite)section);
            layout = new TableWrapLayout();
            layout.leftMargin = 0;
            layout.rightMargin = 0;
            layout.topMargin = 0;
            layout.bottomMargin = 0;
            layout.verticalSpacing = 0;
            composite.setLayout((Layout)layout);
            section.setClient((Control)composite);
            for (PropertyEditorAssistContribution contribution : secdef.getContributions()) {
                FormText text = new FormText(composite, 64);
                text.setBackground(bgcolor);
                td = new TableWrapData();
                td.align = 128;
                td.grabHorizontal = true;
                text.setLayoutData((Object)td);
                for (Map.Entry<String, Image> image : contribution.getImages().entrySet()) {
                    text.setImage(image.getKey(), image.getValue());
                }
                StringBuffer buffer = new StringBuffer();
                buffer.append("<form>");
                buffer.append(contribution.getText());
                buffer.append("</form>");
                text.setText(buffer.toString(), true, false);
                final IHyperlinkListener listener = contribution.getHyperlinkListener();
                if (listener == null) continue;
                text.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent event) {
                        try {
                            try {
                                listener.linkActivated(event);
                            }
                            catch (Exception e) {
                                EditFailedException editFailedException = EditFailedException.findAsCause((Throwable)e);
                                if (editFailedException == null) {
                                    SapphireUiFrameworkPlugin.log(e);
                                }
                                PropertyEditorAssistDialog.this.close();
                            }
                        }
                        finally {
                            PropertyEditorAssistDialog.this.close();
                        }
                    }
                });
            }
        }
        parent.pack();
        return this.composite;
    }

    protected Point getInitialLocation(Point size) {
        if (this.position == null) {
            return super.getInitialLocation(size);
        }
        return this.position;
    }

    public boolean close() {
        if (this.getShell() == null || this.getShell().isDisposed()) {
            return true;
        }
        this.toolkit.dispose();
        return super.close();
    }

    protected Control getFocusControl() {
        return this.composite;
    }
}

