/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.editor.views.masterdetails.actions;

import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IRemovable;
import org.eclipse.sapphire.ui.SapphireImageCache;
import org.eclipse.sapphire.ui.editor.views.masterdetails.MasterDetailsContentNode;
import org.eclipse.sapphire.ui.editor.views.masterdetails.actions.NodeAction;
import org.eclipse.swt.widgets.Shell;

public class NodeDeleteAction
extends NodeAction {
    public static final String ACTION_ID = "node:delete";

    public NodeDeleteAction() {
        this.setId(ACTION_ID);
        this.setLabel(Resources.deleteActionLabel);
        this.setImageDescriptor(SapphireImageCache.ACTION_DELETE);
        this.setCommandId("org.eclipse.ui.edit.delete");
        this.setMergingAllowed(true);
    }

    public boolean isEnabled() {
        IModelElement modelElement = this.getNode().getModelElement();
        return modelElement instanceof IRemovable;
    }

    protected final Object run(Shell shell) {
        MasterDetailsContentNode node = this.getNode();
        MasterDetailsContentNode newSelection = null;
        if (node.getContentTree().getSelectedNodes().contains(node)) {
            MasterDetailsContentNode parent = node.getParentNode();
            List<MasterDetailsContentNode> siblings = parent.getChildNodes();
            int size = siblings.size();
            if (size == 1) {
                newSelection = parent;
            } else {
                int indexOfRemovedNode = siblings.indexOf(node);
                int indexOfNewSelection = indexOfRemovedNode == 0 ? 1 : indexOfRemovedNode - 1;
                newSelection = siblings.get(indexOfNewSelection);
            }
        }
        ((IRemovable)node.getModelElement()).remove();
        if (newSelection != null) {
            node.getContentTree().setSelectedNode(newSelection);
        }
        return null;
    }

    private static final class Resources
    extends NLS {
        public static String deleteActionLabel;

        static {
            Resources.initializeMessages((String)NodeDeleteAction.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

