/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.internal.binding;

import java.util.Collection;
import org.eclipse.sapphire.modeling.EditFailedException;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.ModelPropertyListener;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.assist.internal.PropertyEditorAssistDecorator;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractBinding {
    private IModelElement modelElement;
    private ModelProperty property;
    private ModelPropertyListener propertyChangeListener;
    private SapphireRenderingContext context;
    private Control control;

    public AbstractBinding(IModelElement modelElement, ModelProperty property, SapphireRenderingContext context, Control control) {
        this.modelElement = modelElement;
        this.property = property;
        this.context = context;
        this.control = control;
        this.propertyChangeListener = new ModelPropertyListener(){

            public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
                AbstractBinding.this.updateTarget();
            }
        };
        if (this.modelElement != null) {
            this.modelElement.addListener(this.propertyChangeListener, this.property.getName());
        }
        this.control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                AbstractBinding.this.dispose();
            }
        });
        this.initialize(modelElement, property, context, control);
        this.updateTarget();
    }

    public final IModelElement getModelElement() {
        return this.modelElement;
    }

    public final void setModelElement(IModelElement modelElement) {
        if (this.modelElement != null) {
            this.modelElement.removeListener(this.propertyChangeListener, this.property.getName());
        }
        this.modelElement = modelElement;
        if (this.modelElement != null) {
            this.modelElement.addListener(this.propertyChangeListener, this.property.getName());
        }
        this.updateTarget();
    }

    public ModelProperty getProperty() {
        return this.property;
    }

    public Object getPropertyValue() {
        return this.property.invokeGetterMethod((Object)this.modelElement);
    }

    public final SapphireRenderingContext getContext() {
        return this.context;
    }

    public final Control getControl() {
        return this.control;
    }

    public final void updateModel() {
        if (this.modelElement == null) {
            return;
        }
        boolean rollback = false;
        try {
            this.doUpdateModel();
        }
        catch (Exception e) {
            EditFailedException editFailedException = EditFailedException.findAsCause((Throwable)e);
            if (editFailedException != null) {
                rollback = true;
            }
            SapphireUiFrameworkPlugin.log(e);
        }
        if (rollback) {
            this.updateTarget();
        }
    }

    public final void updateTarget() {
        if (this.control != null) {
            if (this.control.isDisposed()) {
                return;
            }
            if (this.control.getDisplay().getThread() != Thread.currentThread()) {
                this.control.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        AbstractBinding.this.updateTarget();
                    }
                });
                return;
            }
        }
        try {
            this.doUpdateTarget();
            this.updateTargetAttributes();
        }
        catch (Exception e) {
            SapphireUiFrameworkPlugin.log(e);
        }
    }

    public final void updateTargetAttributes() {
        if (this.control.isDisposed()) {
            return;
        }
        PropertyEditorAssistDecorator dec = (PropertyEditorAssistDecorator)this.control.getData("assist-decorator");
        if (dec != null) {
            dec.refresh();
        }
        boolean enabled = this.modelElement == null ? false : this.modelElement.isPropertyEnabled(this.property);
        this.control.setEnabled(enabled);
        Object relatedControls = this.control.getData("related-controls");
        if (relatedControls != null) {
            if (relatedControls instanceof Control) {
                ((Control)relatedControls).setEnabled(enabled);
            } else if (relatedControls instanceof Collection) {
                for (Object control : (Collection)relatedControls) {
                    if (control == null) continue;
                    ((Control)control).setEnabled(enabled);
                }
            }
        }
    }

    public void dispose() {
        if (this.modelElement != null) {
            this.modelElement.removeListener(this.propertyChangeListener, this.property.getName());
        }
    }

    protected void initialize(IModelElement modelElement, ModelProperty property, SapphireRenderingContext context, Control control) {
    }

    protected abstract void doUpdateTarget();

    protected abstract void doUpdateModel();
}

